/*
 * Decompiled with CFR 0.152.
 */
package edsim51di.color;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.JButton;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;

class ColorButton
extends JButton {
    private int size;
    private int radius;
    private Point redCentre;
    private Point greenCentre;
    private Point blueCentre;

    ColorButton(int s) {
        this.size = s - 2;
        this.setPreferredSize(new Dimension(s, s));
        this.setToolTipText("select a target board colour");
        this.setBorder(new CompoundBorder(new BevelBorder(0, Color.LIGHT_GRAY, Color.GRAY), new LineBorder(Color.BLACK, 2)));
        this.radius = this.size / 3;
        this.redCentre = new Point(this.size / 2, this.radius);
        this.greenCentre = new Point(this.size / 3, 2 * this.size / 3);
        this.blueCentre = new Point(2 * this.size / 3, 2 * this.size / 3);
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, this.size, this.size);
        for (int x = 0; x < this.size; ++x) {
            for (int y = 0; y < this.size; ++y) {
                g.setColor(this.getPixelColor(new Point(x, y)));
                g.fillRect(x, y, 1, 1);
            }
        }
    }

    private Color getPixelColor(Point p) {
        int c = 0;
        if (this.isEnabled()) {
            if (p.distance(this.redCentre) < (double)this.radius) {
                c += 0xB40000;
            }
            if (p.distance(this.greenCentre) < (double)this.radius) {
                c += 46080;
            }
            if (p.distance(this.blueCentre) < (double)this.radius) {
                c += 180;
            }
            return new Color(c);
        }
        if (p.distance(this.redCentre) < (double)this.radius) {
            c += 255;
        }
        if (p.distance(this.greenCentre) < (double)this.radius) {
            c += 255;
        }
        if (p.distance(this.blueCentre) < (double)this.radius) {
            c += 255;
        }
        return new Color(c /= 3, c, c);
    }
}

