/*
 * Decompiled with CFR 0.152.
 */
package org.forester.protein;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.forester.protein.Domain;
import org.forester.protein.Protein;
import org.forester.protein.ProteinId;
import org.forester.species.BasicSpecies;
import org.forester.species.Species;
import org.forester.util.ForesterUtil;

public class BasicProtein
implements Protein {
    private final ProteinId _id;
    private final int _length;
    private final Species _species;
    private String _name;
    private String _desc;
    private String _accession;
    private final List<Domain> _protein_domains;
    public static Comparator<Domain> DomainMidPositionComparator = new Comparator<Domain>(){

        @Override
        public int compare(Domain domain, Domain domain2) {
            int n;
            int n2 = domain.getTo() + domain.getFrom();
            return n2 < (n = domain2.getTo() + domain2.getFrom()) ? -1 : (n2 > n ? 1 : domain.getDomainId().compareTo(domain2.getDomainId()));
        }
    };

    public BasicProtein(String string, String string2, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("attempt to create protein of length " + n);
        }
        if (ForesterUtil.isEmpty(string)) {
            throw new IllegalArgumentException("attempt to create protein with null or empty identifier");
        }
        if (ForesterUtil.isEmpty(string2)) {
            throw new IllegalArgumentException("attempt to create protein with null or empty species");
        }
        this._id = new ProteinId(string);
        this._species = new BasicSpecies(string2);
        this._length = n;
        this._protein_domains = new ArrayList<Domain>();
        this.init();
    }

    @Override
    public void addProteinDomain(Domain domain) {
        this.getProteinDomains().add(domain);
    }

    @Override
    public boolean contains(List<String> list, boolean bl) {
        if (!bl) {
            for (String string : list) {
                if (this.getProteinDomainIds().contains(string)) continue;
                return false;
            }
            return true;
        }
        int n = -1;
        block1: for (String string : list) {
            if (this.getProteinDomainIds().contains(string)) {
                List<Domain> list2 = this.getProteinDomains(string);
                TreeSet<Integer> treeSet = new TreeSet<Integer>();
                for (Domain domain : list2) {
                    treeSet.add(domain.getFrom());
                }
                Iterator<Domain> iterator = treeSet.iterator();
                while (iterator.hasNext()) {
                    int n2 = (Integer)((Object)iterator.next());
                    if (n2 <= n) continue;
                    n = n2;
                    continue block1;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public String getAccession() {
        return this._accession;
    }

    @Override
    public String getDescription() {
        return this._desc;
    }

    @Override
    public List<Domain> getDomainsSortedByPosition() {
        ArrayList<Domain> arrayList = new ArrayList<Domain>(this.getProteinDomains().size());
        for (Domain domain : this.getProteinDomains()) {
            arrayList.add(domain);
        }
        Collections.sort(arrayList, DomainMidPositionComparator);
        return arrayList;
    }

    @Override
    public int getLength() {
        return this._length;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public int getNumberOfProteinDomains() {
        return this.getProteinDomains().size();
    }

    @Override
    public Domain getProteinDomain(int n) {
        return this._protein_domains.get(n);
    }

    @Override
    public int getProteinDomainCount(String string) {
        return this.getProteinDomains(string).size();
    }

    @Override
    public List<Domain> getProteinDomains() {
        return this._protein_domains;
    }

    @Override
    public List<Domain> getProteinDomains(String string) {
        ArrayList<Domain> arrayList = new ArrayList<Domain>();
        for (Domain domain : this.getProteinDomains()) {
            if (!domain.getDomainId().equals(string)) continue;
            arrayList.add(domain);
        }
        return arrayList;
    }

    @Override
    public ProteinId getProteinId() {
        return this._id;
    }

    @Override
    public Species getSpecies() {
        return this._species;
    }

    public void setAccession(String string) {
        this._accession = string;
    }

    public void setDescription(String string) {
        this._desc = string;
    }

    public void setName(String string) {
        this._name = string;
    }

    @Override
    public final String toDomainArchitectureString(String string, double d) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Domain domain : this.getDomainsSortedByPosition()) {
            if (!(d <= -1.0) && !(domain.getPerDomainEvalue() <= d)) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(string);
            }
            stringBuilder.append(domain.getDomainId());
        }
        return stringBuilder.toString();
    }

    public final String toDomainArchitectureString(String string) {
        return this.toDomainArchitectureString(string, -1.0);
    }

    public String toDomainArchitectureString(String string, int n, String string2) {
        if (n < 3) {
            throw new IllegalArgumentException("repeats limit cannot be smaller than 3");
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        String string3 = "";
        int n2 = 1;
        for (Domain domain : this.getDomainsSortedByPosition()) {
            String string4 = domain.getDomainId();
            if (string3.equals(string4)) {
                ++n2;
            } else {
                n2 = 1;
                stringBuilder.append((CharSequence)stringBuilder2);
                stringBuilder2 = new StringBuilder();
            }
            if (n2 < n) {
                stringBuilder2.append(string4);
                stringBuilder2.append(string);
            } else if (n2 == n) {
                stringBuilder2 = new StringBuilder();
                stringBuilder2.append(string4);
                stringBuilder2.append(string2);
                stringBuilder2.append(string4);
                stringBuilder2.append(string2);
                stringBuilder2.append(string4);
                stringBuilder2.append(string);
            }
            string3 = string4;
        }
        stringBuilder.append(stringBuilder2.substring(0, stringBuilder2.length() - 1));
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toDomainArchitectureString("--", 1.0);
    }

    private List<String> getProteinDomainIds() {
        ArrayList<String> arrayList = new ArrayList<String>(this.getProteinDomains().size());
        for (Domain domain : this.getProteinDomains()) {
            arrayList.add(domain.getDomainId());
        }
        return arrayList;
    }

    private void init() {
        this._desc = "";
        this._accession = "";
        this._name = "";
    }
}

