/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.writers;

import java.io.IOException;
import java.io.Writer;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.util.ForesterUtil;

public class PhyloXmlNodeWriter {
    public static void toPhyloXml(Writer writer, PhylogenyNode phylogenyNode, int n, String string) throws IOException {
        String string2 = "";
        if (string != null && string.length() > 0) {
            string2 = string + "  ";
        }
        if (!ForesterUtil.isEmpty(phylogenyNode.getName())) {
            PhylogenyDataUtil.appendElement(writer, "name", phylogenyNode.getName(), string);
        }
        if (phylogenyNode.getDistanceToParent() != -1024.0) {
            PhylogenyDataUtil.appendElement(writer, "branch_length", String.valueOf(ForesterUtil.round(phylogenyNode.getDistanceToParent(), 9)), string);
        }
        if (phylogenyNode.getBranchData() != null) {
            phylogenyNode.getBranchData().toPhyloXML(writer, n, string2);
        }
        if (phylogenyNode.getNodeData() != null) {
            phylogenyNode.getNodeData().toPhyloXML(writer, n, string2);
        }
    }
}

