/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.nexus;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.io.parsers.IteratingPhylogenyParser;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.nhx.NHXFormatException;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.io.parsers.util.PhylogenyParserException;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.sequence.BasicSequence;
import org.forester.sequence.MolecularSequence;
import org.forester.util.ForesterUtil;

public final class NexusPhylogeniesParser
implements IteratingPhylogenyParser,
PhylogenyParser {
    private static final boolean DEBUG = false;
    private static final String begin_trees = "Begin Trees;".toLowerCase();
    private static final String end = "End;".toLowerCase();
    private static final String endblock = "endblock";
    private static final Pattern ROOTEDNESS_PATTERN = Pattern.compile(".+=\\s*\\[&([R|U])\\].*");
    private static final String taxlabels = "TaxLabels".toLowerCase();
    private static final Pattern TITLE_PATTERN = Pattern.compile("TITLE.?\\s+([^;]+)", 2);
    private static final String translate = "Translate".toLowerCase();
    private static final String data = "Begin Characters;".toLowerCase();
    private static final String characters = "Begin Data;".toLowerCase();
    private static final String tree = "Tree".toLowerCase();
    private static final Pattern TREE_NAME_PATTERN = Pattern.compile("\\s*.?Tree\\s+(.+?)\\s*=.+", 2);
    private static final Pattern TRANSLATE_PATTERN = Pattern.compile("([0-9A-Za-z]+)\\s+(.+)");
    private static final Pattern ALN_PATTERN = Pattern.compile("(.+)\\s+([A-Za-z-_\\*\\?]+)");
    private static final Pattern DATATYPE_PATTERN = Pattern.compile("datatype\\s?.\\s?([a-z]+)");
    private static final String utree = "UTREE".toLowerCase();
    private BufferedReader _br;
    private boolean _ignore_quotes_in_nh_data = false;
    private boolean _in_taxalabels;
    private boolean _in_translate;
    private boolean _in_tree;
    private boolean _in_trees_block;
    private boolean _in_data_block;
    private boolean _is_rooted;
    private String _datatype;
    private String _name;
    private Phylogeny _next;
    private Object _nexus_source;
    private StringBuilder _nh;
    private boolean _replace_underscores = false;
    private boolean _rooted_info_present;
    private List<String> _taxlabels;
    private NHXParser.TAXONOMY_EXTRACTION _taxonomy_extraction = NHXParser.TAXONOMY_EXTRACTION.NO;
    private String _title;
    private Map<String, String> _translate_map;
    private StringBuilder _translate_sb;
    private Map<String, MolecularSequence> _seqs;
    private final boolean _add_sequences = true;
    private boolean _parse_beast_style_extended_tags = false;

    @Override
    public String getName() {
        return "Nexus Phylogenies Parser";
    }

    @Override
    public final boolean hasNext() {
        return this._next != null;
    }

    @Override
    public final Phylogeny next() throws NHXFormatException, IOException {
        Phylogeny phylogeny = this._next;
        this.getNext();
        return phylogeny;
    }

    @Override
    public final Phylogeny[] parse() throws IOException {
        ArrayList<Phylogeny> arrayList = new ArrayList<Phylogeny>();
        while (this.hasNext()) {
            arrayList.add(this.next());
        }
        Phylogeny[] phylogenyArray = new Phylogeny[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            phylogenyArray[i] = (Phylogeny)arrayList.get(i);
        }
        this.reset();
        return phylogenyArray;
    }

    @Override
    public final void reset() throws FileNotFoundException, IOException {
        this._taxlabels = new ArrayList<String>();
        this._translate_map = new HashMap<String, String>();
        this._nh = new StringBuilder();
        this._name = "";
        this._title = "";
        this._translate_sb = null;
        this._next = null;
        this._in_trees_block = false;
        this._in_taxalabels = false;
        this._in_translate = false;
        this._in_tree = false;
        this._rooted_info_present = false;
        this._is_rooted = false;
        this._seqs = new HashMap<String, MolecularSequence>();
        this._br = ParserUtils.createReader(this._nexus_source, "UTF-8");
        this.getNext();
    }

    public final void setIgnoreQuotes(boolean bl) {
        this._ignore_quotes_in_nh_data = bl;
    }

    public final void setReplaceUnderscores(boolean bl) {
        this._replace_underscores = bl;
    }

    @Override
    public final void setSource(Object object) throws PhylogenyParserException, IOException {
        if (object == null) {
            throw new PhylogenyParserException("attempt to parse null object");
        }
        this._nexus_source = object;
        this.reset();
    }

    public final void setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION tAXONOMY_EXTRACTION) {
        this._taxonomy_extraction = tAXONOMY_EXTRACTION;
    }

    private final void createPhylogeny(String string, String string2, StringBuilder stringBuilder, boolean bl, boolean bl2) throws IOException {
        this._next = null;
        NHXParser nHXParser = new NHXParser();
        nHXParser.setTaxonomyExtraction(this._taxonomy_extraction);
        nHXParser.setReplaceUnderscores(this._replace_underscores);
        nHXParser.setIgnoreQuotes(this._ignore_quotes_in_nh_data);
        nHXParser.setParseBeastStyleExtendedTags(this._parse_beast_style_extended_tags);
        if (bl) {
            nHXParser.setGuessRootedness(false);
        }
        nHXParser.setSource(stringBuilder.toString());
        Phylogeny phylogeny = nHXParser.next();
        if (phylogeny == null) {
            throw new PhylogenyParserException("failed to create phylogeny");
        }
        String string3 = null;
        if (!ForesterUtil.isEmpty(string) && !ForesterUtil.isEmpty(string2)) {
            string3 = string.replace('_', ' ').trim() + " (" + string2.trim() + ")";
        } else if (!ForesterUtil.isEmpty(string)) {
            string3 = string.replace('_', ' ').trim();
        } else if (!ForesterUtil.isEmpty(string2)) {
            string3 = string2.trim();
        }
        if (!ForesterUtil.isEmpty(string3)) {
            phylogeny.setName(string3);
        }
        if (bl) {
            phylogeny.setRooted(bl2);
        }
        if (this._taxlabels.size() > 0 || this._translate_map.size() > 0) {
            PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
            while (phylogenyNodeIterator.hasNext()) {
                PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
                if (this._translate_map.size() > 0 && this._translate_map.containsKey(phylogenyNode.getName())) {
                    phylogenyNode.setName(this._translate_map.get(phylogenyNode.getName()).replaceAll("['\"]+", ""));
                } else if (this._taxlabels.size() > 0) {
                    int n = -1;
                    try {
                        n = Integer.parseInt(phylogenyNode.getName());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (n > 0) {
                        phylogenyNode.setName(this._taxlabels.get(n - 1).replaceAll("['\"]+", ""));
                    }
                }
                if (!this._replace_underscores && this._taxonomy_extraction != NHXParser.TAXONOMY_EXTRACTION.NO) {
                    ParserUtils.extractTaxonomyDataFromNodeName(phylogenyNode, this._taxonomy_extraction);
                } else if (this._replace_underscores && !ForesterUtil.isEmpty(phylogenyNode.getName())) {
                    phylogenyNode.setName(phylogenyNode.getName().replace('_', ' ').trim());
                }
                if (!this._seqs.containsKey(phylogenyNode.getName())) continue;
                MolecularSequence molecularSequence = this._seqs.get(phylogenyNode.getName());
                Sequence sequence = new Sequence(molecularSequence);
                sequence.setMolecularSequenceAligned(true);
                phylogenyNode.getNodeData().addSequence(sequence);
            }
        }
        this._next = phylogeny;
    }

    private final void getNext() throws IOException, NHXFormatException {
        String string;
        this._next = null;
        while ((string = this._br.readLine()) != null) {
            Object object;
            String string2;
            Object object2;
            Object object3;
            Object object4;
            if ((string = string.trim()).length() <= 0 || string.startsWith("#") || string.startsWith(">")) continue;
            string = ForesterUtil.collapseWhiteSpace(string);
            String string3 = (string = NexusPhylogeniesParser.removeWhiteSpaceBeforeSemicolon(string)).toLowerCase();
            if (string3.startsWith(begin_trees)) {
                this._in_trees_block = true;
                this._in_taxalabels = false;
                this._in_translate = false;
                this._in_data_block = false;
                this._datatype = null;
                this._title = "";
            } else if (string3.startsWith(taxlabels)) {
                this._in_trees_block = false;
                this._in_taxalabels = true;
                this._in_translate = false;
                this._in_data_block = false;
                this._datatype = null;
            } else if (string3.startsWith(translate)) {
                this._translate_sb = new StringBuilder();
                this._in_taxalabels = false;
                this._in_translate = true;
                this._in_data_block = false;
                this._datatype = null;
            } else if (string3.startsWith(characters) || string3.startsWith(data)) {
                this._in_taxalabels = false;
                this._in_trees_block = false;
                this._in_translate = false;
                this._in_data_block = true;
                this._datatype = null;
            } else if (this._in_trees_block) {
                if (string3.startsWith("title")) {
                    object4 = TITLE_PATTERN.matcher(string);
                    if (((Matcher)object4).lookingAt()) {
                        this._title = ((Matcher)object4).group(1);
                    }
                } else if (!string3.startsWith("link")) {
                    if (string3.startsWith(end) || string3.startsWith(endblock)) {
                        this._in_trees_block = false;
                        this._in_tree = false;
                        this._in_translate = false;
                        if (this._nh.length() > 0) {
                            this.createPhylogeny(this._title, this._name, this._nh, this._rooted_info_present, this._is_rooted);
                            this._nh = new StringBuilder();
                            this._name = "";
                            this._rooted_info_present = false;
                            this._is_rooted = false;
                            if (this._next != null) {
                                return;
                            }
                        }
                    } else if (string3.startsWith(tree) || string3.startsWith(utree)) {
                        boolean bl = false;
                        if (this._nh.length() > 0) {
                            bl = true;
                            this.createPhylogeny(this._title, this._name, this._nh, this._rooted_info_present, this._is_rooted);
                            this._nh = new StringBuilder();
                            this._name = "";
                            this._rooted_info_present = false;
                            this._is_rooted = false;
                        }
                        this._in_tree = true;
                        this._nh.append(string.substring(string.indexOf(61)));
                        object3 = TREE_NAME_PATTERN.matcher(string);
                        if (((Matcher)object3).matches()) {
                            this._name = ((Matcher)object3).group(1);
                            this._name = this._name.replaceAll("['\"]+", "");
                        }
                        if (((Matcher)(object2 = ROOTEDNESS_PATTERN.matcher(string))).matches()) {
                            string2 = ((Matcher)object2).group(1);
                            string = string.replaceAll("\\[\\&.\\]", "");
                            this._rooted_info_present = true;
                            if (string2.toUpperCase().equals("R")) {
                                this._is_rooted = true;
                            }
                        }
                        if (bl && this._next != null) {
                            return;
                        }
                    } else if (this._in_tree && !this._in_translate) {
                        this._nh.append(string);
                    }
                }
                if (!(string3.startsWith("title") || string3.startsWith("link") || this._in_translate || string3.startsWith(end) || string3.startsWith(endblock) || !string3.endsWith(";"))) {
                    this._in_tree = false;
                    this._in_translate = false;
                    this.createPhylogeny(this._title, this._name, this._nh, this._rooted_info_present, this._is_rooted);
                    this._nh = new StringBuilder();
                    this._name = "";
                    this._rooted_info_present = false;
                    this._is_rooted = false;
                    if (this._next != null) {
                        return;
                    }
                }
            }
            if (this._in_taxalabels) {
                if (string3.startsWith(end) || string3.startsWith(endblock)) {
                    this._in_taxalabels = false;
                } else {
                    object3 = object4 = string.split("\\s+");
                    int n = ((String[])object3).length;
                    for (int i = 0; i < n; ++i) {
                        object = object3[i];
                        if (((String)object).toLowerCase().equals(taxlabels)) continue;
                        if (((String)object).endsWith(";")) {
                            this._in_taxalabels = false;
                            object = ((String)object).substring(0, ((String)object).length() - 1);
                        }
                        if (((String)object).length() <= 0) continue;
                        this._taxlabels.add((String)object);
                    }
                }
            }
            if (this._in_translate) {
                if (string3.startsWith(end) || string3.startsWith(endblock)) {
                    this._in_translate = false;
                } else {
                    this._translate_sb.append(" ");
                    this._translate_sb.append(string.trim());
                    if (string.endsWith(";")) {
                        this._in_translate = false;
                        this.setTranslateKeyValuePairs(this._translate_sb);
                    }
                }
            }
            if (!this._in_data_block) continue;
            if (string3.startsWith(end) || string3.startsWith(endblock)) {
                this._in_data_block = false;
                this._datatype = null;
                continue;
            }
            if (string3.startsWith("link")) continue;
            object4 = DATATYPE_PATTERN.matcher(string3);
            if (((Matcher)object4).find()) {
                this._datatype = ((Matcher)object4).group(1);
                continue;
            }
            if (this._datatype == null || !this._datatype.equals("protein") && !this._datatype.equals("dna") && !this._datatype.equals("rna")) continue;
            if (string.endsWith(";")) {
                this._in_data_block = false;
                string = string.substring(0, string.length() - 1);
            }
            if (!((Matcher)(object3 = ALN_PATTERN.matcher(string))).matches()) continue;
            object2 = ((Matcher)object3).group(1);
            string2 = ((Matcher)object3).group(2);
            object = null;
            object = this._datatype.equals("protein") ? BasicSequence.createAaSequence((String)object2, string2) : (this._datatype.equals("dna") ? BasicSequence.createDnaSequence((String)object2, string2) : BasicSequence.createRnaSequence((String)object2, string2));
            this._seqs.put((String)object2, (MolecularSequence)object);
        }
        if (this._nh.length() > 0) {
            this.createPhylogeny(this._title, this._name, this._nh, this._rooted_info_present, this._is_rooted);
            if (this._next != null) {
                return;
            }
        }
    }

    private final void setTranslateKeyValuePairs(StringBuilder stringBuilder) throws IOException {
        String string = stringBuilder.toString().trim();
        if (string.endsWith(";")) {
            string = string.substring(0, string.length() - 1).trim();
        }
        for (String string2 : string.split(",")) {
            Matcher matcher;
            String string3 = "";
            String string4 = "";
            int n = string2.toLowerCase().indexOf("translate");
            if (n > -1) {
                string2 = string2.substring(n + 9);
            }
            if (!(matcher = TRANSLATE_PATTERN.matcher(string2)).find()) {
                throw new IOException("ill-formatted translate values: " + string2);
            }
            string3 = matcher.group(1);
            string4 = matcher.group(2).replaceAll("'", "").replaceAll("\"", "").trim();
            if (string4.endsWith(";")) {
                string4 = string4.substring(0, string4.length() - 1);
            }
            this._translate_map.put(string3, string4);
        }
    }

    public final void setParseBeastStyleExtendedTags(boolean bl) {
        this._parse_beast_style_extended_tags = bl;
    }

    private static final String removeWhiteSpaceBeforeSemicolon(String string) {
        return string.replaceAll("\\s+;", ";");
    }
}

