/*
 * Decompiled with CFR 0.152.
 */
package org.forester.evoinference.parsimony;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.evoinference.matrix.character.BasicCharacterStateMatrix;
import org.forester.evoinference.matrix.character.CharacterStateMatrix;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.FailedConditionCheckException;
import org.forester.util.ForesterUtil;

public class FitchParsimony<STATE_TYPE> {
    private static final CharacterStateMatrix.BinaryStates ABSENT = CharacterStateMatrix.BinaryStates.ABSENT;
    private static final CharacterStateMatrix.GainLossStates GAIN = CharacterStateMatrix.GainLossStates.GAIN;
    private static final CharacterStateMatrix.GainLossStates LOSS = CharacterStateMatrix.GainLossStates.LOSS;
    private static final CharacterStateMatrix.BinaryStates PRESENT = CharacterStateMatrix.BinaryStates.PRESENT;
    private static final long RANDOM_NUMBER_SEED_DEFAULT = 21L;
    private static final boolean RANDOMIZE_DEFAULT = false;
    private static final boolean RETURN_GAIN_LOSS_MATRIX_DEFAULT = false;
    private static final boolean RETURN_INTERNAL_STATES_DEFAULT = false;
    private static final CharacterStateMatrix.GainLossStates UNCHANGED_ABSENT = CharacterStateMatrix.GainLossStates.UNCHANGED_ABSENT;
    private static final CharacterStateMatrix.GainLossStates UNCHANGED_PRESENT = CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT;
    private static final boolean USE_LAST_DEFAULT = false;
    private int _cost;
    private CharacterStateMatrix<CharacterStateMatrix.GainLossStates> _gain_loss_matrix;
    private CharacterStateMatrix<STATE_TYPE> _internal_states_matrix_after_traceback;
    private CharacterStateMatrix<List<STATE_TYPE>> _internal_states_matrix_prior_to_traceback;
    private Random _random_generator;
    private long _random_number_seed;
    private boolean _randomize;
    private boolean _return_gain_loss = false;
    private boolean _return_internal_states = false;
    private int _total_gains;
    private int _total_losses;
    private int _total_unchanged;
    private boolean _use_last;
    private boolean _verbose = false;

    public FitchParsimony() {
        this.init();
    }

    public void execute(Phylogeny phylogeny, CharacterStateMatrix<STATE_TYPE> characterStateMatrix) {
        this.execute(phylogeny, characterStateMatrix, false);
    }

    public void execute(Phylogeny phylogeny, CharacterStateMatrix<STATE_TYPE> characterStateMatrix, boolean bl) {
        if (!phylogeny.isRooted()) {
            throw new IllegalArgumentException("attempt to execute Fitch parsimony on unroored phylogeny");
        }
        if (characterStateMatrix.isEmpty()) {
            throw new IllegalArgumentException("character matrix is empty");
        }
        if (characterStateMatrix.getNumberOfIdentifiers() != phylogeny.getNumberOfExternalNodes()) {
            throw new IllegalArgumentException("number of external nodes in phylogeny [" + phylogeny.getNumberOfExternalNodes() + "] and number of indentifiers [" + characterStateMatrix.getNumberOfIdentifiers() + "] in matrix are not equal");
        }
        this.setVerbose(bl);
        this.reset();
        if (this.isReturnInternalStates()) {
            this.initializeInternalStates(phylogeny, characterStateMatrix);
        }
        if (this.isReturnGainLossMatrix()) {
            this.initializeGainLossMatrix(phylogeny, characterStateMatrix);
        }
        DecimalFormat decimalFormat = new DecimalFormat("000000");
        if (this.isVerbose()) {
            System.out.println("Number of characters: " + characterStateMatrix.getNumberOfCharacters());
        }
        for (int i = 0; i < characterStateMatrix.getNumberOfCharacters(); ++i) {
            if (this.isVerbose()) {
                ForesterUtil.updateProgress(i, decimalFormat);
            }
            this.executeForOneCharacter(phylogeny, this.getStatesForCharacter(phylogeny, characterStateMatrix, i), this.getStatesForCharacterForTraceback(phylogeny, characterStateMatrix, i), i);
        }
        if (this.isVerbose()) {
            System.out.println();
        }
        if (characterStateMatrix.getState(0, 0) instanceof CharacterStateMatrix.BinaryStates && characterStateMatrix.getNumberOfCharacters() * phylogeny.getNumberOfBranches() != this.getTotalGains() + this.getTotalLosses() + this.getTotalUnchanged()) {
            throw new FailedConditionCheckException("this should not have happened: something is deeply wrong with Fitch parsimony implementation");
        }
    }

    public int getCost() {
        return this._cost;
    }

    public CharacterStateMatrix<CharacterStateMatrix.GainLossStates> getGainLossMatrix() {
        if (!this.isReturnGainLossMatrix()) {
            throw new RuntimeException("creation of gain-loss matrix has not been enabled");
        }
        return this._gain_loss_matrix;
    }

    public CharacterStateMatrix<STATE_TYPE> getInternalStatesMatrix() {
        if (!this.isReturnInternalStates()) {
            throw new RuntimeException("creation of internal state matrix has not been enabled");
        }
        return this._internal_states_matrix_after_traceback;
    }

    public CharacterStateMatrix<List<STATE_TYPE>> getInternalStatesMatrixPriorToTraceback() {
        if (!this.isReturnInternalStates()) {
            throw new RuntimeException("creation of internal state matrix has not been enabled");
        }
        return this._internal_states_matrix_prior_to_traceback;
    }

    public int getTotalGains() {
        return this._total_gains;
    }

    public int getTotalLosses() {
        return this._total_losses;
    }

    public int getTotalUnchanged() {
        return this._total_unchanged;
    }

    public boolean isVerbose() {
        return this._verbose;
    }

    public void setRandomize(boolean bl) {
        if (bl && this.isUseLast()) {
            throw new IllegalArgumentException("attempt to allways use last state (ordered) if more than one choices and randomization at the same time");
        }
        this._randomize = bl;
    }

    public void setRandomNumberSeed(long l) {
        if (!this.isRandomize()) {
            throw new IllegalArgumentException("attempt to set random number generator seed without randomization enabled");
        }
        this._random_number_seed = l;
    }

    public void setReturnGainLossMatrix(boolean bl) {
        this._return_gain_loss = bl;
    }

    public void setReturnInternalStates(boolean bl) {
        this._return_internal_states = bl;
    }

    public void setUseLast(boolean bl) {
        if (bl && this.isRandomize()) {
            throw new IllegalArgumentException("attempt to allways use last state (ordered) if more than one choices and randomization at the same time");
        }
        this._use_last = bl;
    }

    public void setVerbose(boolean bl) {
        this._verbose = bl;
    }

    private int determineIndex(SortedSet<STATE_TYPE> sortedSet, int n) {
        if (this.isRandomize()) {
            n = this.getRandomGenerator().nextInt(sortedSet.size());
        } else if (this.isUseLast()) {
            n = sortedSet.size() - 1;
        }
        return n;
    }

    private void executeForOneCharacter(Phylogeny phylogeny, Map<PhylogenyNode, SortedSet<STATE_TYPE>> map, Map<PhylogenyNode, STATE_TYPE> map2, int n) {
        this.postOrderTraversal(phylogeny, map);
        this.preOrderTraversal(phylogeny, map, map2, n);
    }

    private SortedSet<STATE_TYPE> getIntersectionOfStatesOfChildNodes(Map<PhylogenyNode, SortedSet<STATE_TYPE>> map, PhylogenyNode phylogenyNode) throws AssertionError {
        TreeSet treeSet = new TreeSet();
        for (int i = 0; i < phylogenyNode.getNumberOfDescendants(); ++i) {
            PhylogenyNode phylogenyNode2 = phylogenyNode.getChildNode(i);
            if (!map.containsKey(phylogenyNode2)) {
                throw new AssertionError((Object)("this should not have happened: node [" + phylogenyNode2.getName() + "] not found in node state map"));
            }
            if (i == 0) {
                treeSet.addAll(map.get(phylogenyNode2));
                continue;
            }
            treeSet.retainAll((Collection)map.get(phylogenyNode2));
        }
        return treeSet;
    }

    private Random getRandomGenerator() {
        return this._random_generator;
    }

    private long getRandomNumberSeed() {
        return this._random_number_seed;
    }

    private STATE_TYPE getStateAt(int n, SortedSet<STATE_TYPE> sortedSet) {
        Iterator iterator = sortedSet.iterator();
        for (int i = 0; i < n; ++i) {
            iterator.next();
        }
        return (STATE_TYPE)iterator.next();
    }

    private Map<PhylogenyNode, SortedSet<STATE_TYPE>> getStatesForCharacter(Phylogeny phylogeny, CharacterStateMatrix<STATE_TYPE> characterStateMatrix, int n) {
        HashMap<PhylogenyNode, SortedSet<STATE_TYPE>> hashMap = new HashMap<PhylogenyNode, SortedSet<STATE_TYPE>>(characterStateMatrix.getNumberOfIdentifiers());
        for (int i = 0; i < characterStateMatrix.getNumberOfIdentifiers(); ++i) {
            STATE_TYPE STATE_TYPE = characterStateMatrix.getState(i, n);
            if (STATE_TYPE == null) {
                throw new IllegalArgumentException("value at [" + i + ", " + n + "] is null");
            }
            TreeSet<STATE_TYPE> treeSet = new TreeSet<STATE_TYPE>();
            treeSet.add(STATE_TYPE);
            hashMap.put(phylogeny.getNode(characterStateMatrix.getIdentifier(i)), treeSet);
        }
        return hashMap;
    }

    private Map<PhylogenyNode, STATE_TYPE> getStatesForCharacterForTraceback(Phylogeny phylogeny, CharacterStateMatrix<STATE_TYPE> characterStateMatrix, int n) {
        HashMap<PhylogenyNode, STATE_TYPE> hashMap = new HashMap<PhylogenyNode, STATE_TYPE>(characterStateMatrix.getNumberOfIdentifiers());
        for (int i = 0; i < characterStateMatrix.getNumberOfIdentifiers(); ++i) {
            STATE_TYPE STATE_TYPE = characterStateMatrix.getState(i, n);
            if (STATE_TYPE == null) {
                throw new IllegalArgumentException("value at [" + i + ", " + n + "] is null");
            }
            hashMap.put(phylogeny.getNode(characterStateMatrix.getIdentifier(i)), STATE_TYPE);
        }
        return hashMap;
    }

    private SortedSet<STATE_TYPE> getUnionOfStatesOfChildNodes(Map<PhylogenyNode, SortedSet<STATE_TYPE>> map, PhylogenyNode phylogenyNode) throws AssertionError {
        TreeSet treeSet = new TreeSet();
        for (int i = 0; i < phylogenyNode.getNumberOfDescendants(); ++i) {
            PhylogenyNode phylogenyNode2 = phylogenyNode.getChildNode(i);
            if (!map.containsKey(phylogenyNode2)) {
                throw new AssertionError((Object)("this should not have happened: node [" + phylogenyNode2.getName() + "] not found in node state map"));
            }
            treeSet.addAll(map.get(phylogenyNode2));
        }
        return treeSet;
    }

    private void increaseCost() {
        ++this._cost;
    }

    private void init() {
        this.setReturnInternalStates(false);
        this.setReturnGainLossMatrix(false);
        this.setRandomize(false);
        this.setUseLast(false);
        this._random_number_seed = 21L;
        this.reset();
    }

    private void initializeGainLossMatrix(Phylogeny phylogeny, CharacterStateMatrix<STATE_TYPE> characterStateMatrix) {
        ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            arrayList.add(phylogenyNodeIterator.next());
        }
        this.setGainLossMatrix(new BasicCharacterStateMatrix<CharacterStateMatrix.GainLossStates>(arrayList.size(), characterStateMatrix.getNumberOfCharacters()));
        int n = 0;
        for (PhylogenyNode phylogenyNode : arrayList) {
            this.getGainLossMatrix().setIdentifier(n++, ForesterUtil.isEmpty(phylogenyNode.getName()) ? phylogenyNode.getId() + "" : phylogenyNode.getName());
        }
        for (int i = 0; i < characterStateMatrix.getNumberOfCharacters(); ++i) {
            this.getGainLossMatrix().setCharacter(i, characterStateMatrix.getCharacter(i));
        }
    }

    private void initializeInternalStates(Phylogeny phylogeny, CharacterStateMatrix<STATE_TYPE> characterStateMatrix) {
        ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.isInternal()) continue;
            arrayList.add(phylogenyNode);
        }
        this.setInternalStatesMatrixPriorToTraceback(new BasicCharacterStateMatrix<List<STATE_TYPE>>(arrayList.size(), characterStateMatrix.getNumberOfCharacters()));
        this.setInternalStatesMatrixTraceback(new BasicCharacterStateMatrix(arrayList.size(), characterStateMatrix.getNumberOfCharacters()));
        int n = 0;
        for (PhylogenyNode phylogenyNode : arrayList) {
            this.getInternalStatesMatrix().setIdentifier(n, ForesterUtil.isEmpty(phylogenyNode.getName()) ? phylogenyNode.getId() + "" : phylogenyNode.getName());
            this.getInternalStatesMatrixPriorToTraceback().setIdentifier(n, ForesterUtil.isEmpty(phylogenyNode.getName()) ? phylogenyNode.getId() + "" : phylogenyNode.getName());
            ++n;
        }
        for (int i = 0; i < characterStateMatrix.getNumberOfCharacters(); ++i) {
            this.getInternalStatesMatrix().setCharacter(i, characterStateMatrix.getCharacter(i));
            this.getInternalStatesMatrixPriorToTraceback().setCharacter(i, characterStateMatrix.getCharacter(i));
        }
    }

    private boolean isRandomize() {
        return this._randomize;
    }

    private boolean isReturnGainLossMatrix() {
        return this._return_gain_loss;
    }

    private boolean isReturnInternalStates() {
        return this._return_internal_states;
    }

    private boolean isUseLast() {
        return this._use_last;
    }

    private void postOrderTraversal(Phylogeny phylogeny, Map<PhylogenyNode, SortedSet<STATE_TYPE>> map) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isExternal()) continue;
            SortedSet<STATE_TYPE> sortedSet = this.getIntersectionOfStatesOfChildNodes(map, phylogenyNode);
            if (sortedSet.isEmpty()) {
                sortedSet = this.getUnionOfStatesOfChildNodes(map, phylogenyNode);
            }
            map.put(phylogenyNode, sortedSet);
        }
    }

    private void preOrderTraversal(Phylogeny phylogeny, Map<PhylogenyNode, SortedSet<STATE_TYPE>> map, Map<PhylogenyNode, STATE_TYPE> map2, int n) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            SortedSet<STATE_TYPE> sortedSet = map.get(phylogenyNode);
            Object v = null;
            if (phylogenyNode.isRoot()) {
                int n2 = 0;
                n2 = this.determineIndex(sortedSet, n2);
                map2.put(phylogenyNode, this.getStateAt(n2, sortedSet));
            } else {
                v = map2.get(phylogenyNode.getParent());
                if (sortedSet.contains(v)) {
                    map2.put(phylogenyNode, v);
                } else {
                    this.increaseCost();
                    int n3 = 0;
                    n3 = this.determineIndex(sortedSet, n3);
                    map2.put(phylogenyNode, this.getStateAt(n3, sortedSet));
                }
            }
            if (this.isReturnInternalStates() && !phylogenyNode.isExternal()) {
                this.setInternalNodeStatePriorToTraceback(map, n, phylogenyNode);
                this.setInternalNodeState(map2, n, phylogenyNode);
            }
            if (this.isReturnGainLossMatrix() && !phylogenyNode.isRoot()) {
                if (!(v instanceof CharacterStateMatrix.BinaryStates)) {
                    throw new RuntimeException("attempt to create gain loss matrix for not binary states");
                }
                CharacterStateMatrix.BinaryStates binaryStates = (CharacterStateMatrix.BinaryStates)((Object)v);
                CharacterStateMatrix.BinaryStates binaryStates2 = (CharacterStateMatrix.BinaryStates)((Object)map2.get(phylogenyNode));
                if (binaryStates == PRESENT && binaryStates2 == ABSENT) {
                    ++this._total_losses;
                    this.setGainLossState(n, phylogenyNode, LOSS);
                    continue;
                }
                if ((binaryStates == ABSENT || binaryStates == null) && binaryStates2 == PRESENT) {
                    ++this._total_gains;
                    this.setGainLossState(n, phylogenyNode, GAIN);
                    continue;
                }
                ++this._total_unchanged;
                if (binaryStates2 == PRESENT) {
                    this.setGainLossState(n, phylogenyNode, UNCHANGED_PRESENT);
                    continue;
                }
                if (binaryStates2 != ABSENT) continue;
                this.setGainLossState(n, phylogenyNode, UNCHANGED_ABSENT);
                continue;
            }
            if (!this.isReturnGainLossMatrix() || !phylogenyNode.isRoot()) continue;
            CharacterStateMatrix.BinaryStates binaryStates = (CharacterStateMatrix.BinaryStates)((Object)map2.get(phylogenyNode));
            ++this._total_unchanged;
            if (binaryStates == PRESENT) {
                this.setGainLossState(n, phylogenyNode, UNCHANGED_PRESENT);
                continue;
            }
            if (binaryStates != ABSENT) continue;
            this.setGainLossState(n, phylogenyNode, UNCHANGED_ABSENT);
        }
    }

    private void reset() {
        this.setCost(0);
        this.setTotalLosses(0);
        this.setTotalGains(0);
        this.setTotalUnchanged(0);
        this.setRandomGenerator(new Random(this.getRandomNumberSeed()));
    }

    private void setCost(int n) {
        this._cost = n;
    }

    private void setGainLossMatrix(CharacterStateMatrix<CharacterStateMatrix.GainLossStates> characterStateMatrix) {
        this._gain_loss_matrix = characterStateMatrix;
    }

    private void setGainLossState(int n, PhylogenyNode phylogenyNode, CharacterStateMatrix.GainLossStates gainLossStates) {
        this.getGainLossMatrix().setState(ForesterUtil.isEmpty(phylogenyNode.getName()) ? phylogenyNode.getId() + "" : phylogenyNode.getName(), n, gainLossStates);
    }

    private void setInternalNodeState(Map<PhylogenyNode, STATE_TYPE> map, int n, PhylogenyNode phylogenyNode) {
        this.getInternalStatesMatrix().setState(ForesterUtil.isEmpty(phylogenyNode.getName()) ? phylogenyNode.getId() + "" : phylogenyNode.getName(), n, map.get(phylogenyNode));
    }

    private void setInternalNodeStatePriorToTraceback(Map<PhylogenyNode, SortedSet<STATE_TYPE>> map, int n, PhylogenyNode phylogenyNode) {
        this.getInternalStatesMatrixPriorToTraceback().setState(ForesterUtil.isEmpty(phylogenyNode.getName()) ? String.valueOf(phylogenyNode.getId()) : phylogenyNode.getName(), n, this.toListSorted(map.get(phylogenyNode)));
    }

    private void setInternalStatesMatrixPriorToTraceback(CharacterStateMatrix<List<STATE_TYPE>> characterStateMatrix) {
        this._internal_states_matrix_prior_to_traceback = characterStateMatrix;
    }

    private void setInternalStatesMatrixTraceback(CharacterStateMatrix<STATE_TYPE> characterStateMatrix) {
        this._internal_states_matrix_after_traceback = characterStateMatrix;
    }

    private void setRandomGenerator(Random random) {
        this._random_generator = random;
    }

    private void setTotalGains(int n) {
        this._total_gains = n;
    }

    private void setTotalLosses(int n) {
        this._total_losses = n;
    }

    private void setTotalUnchanged(int n) {
        this._total_unchanged = n;
    }

    private List<STATE_TYPE> toListSorted(SortedSet<STATE_TYPE> sortedSet) {
        ArrayList arrayList = new ArrayList(sortedSet.size());
        for (Object e : sortedSet) {
            arrayList.add(e);
        }
        return arrayList;
    }
}

