/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.sdi.GSDI;
import org.forester.sdi.GSDII;
import org.forester.sdi.GSDIR;
import org.forester.sdi.SDIException;
import org.forester.sdi.SDIutil;
import org.forester.util.CommandLineArguments;
import org.forester.util.EasyWriter;
import org.forester.util.ForesterUtil;

public final class gsdi {
    public static final boolean REPLACE_UNDERSCORES_IN_NH_SPECIES_TREE = true;
    private static final String ALLOW_STRIPPING_OF_GENE_TREE_OPTION = "g";
    private static final String GSDIR_OPTION = "r";
    private static final String MOST_PARSIMONIOUS_OPTION = "m";
    private static final String SUFFIX_FOR_DIR_OPTION = "s";
    private static final String GUESS_FORMAT_OF_SPECIES_TREE = "q";
    private static final String TRANSFER_TAXONOMY_OPTION = "t";
    private static final String REMOVE_DUPLICATE_EXTERNAL_SPECIES_NODES_OPTION = "R";
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String SUFFIX_FOR_SPECIES_TREE_USED = "_species_tree_used.xml";
    private static final String OUTTREE_SUFFIX = "_gsdir.xml";
    private static final String LOGFILE_NAME = "00_gsdi_log.tsv";
    private static final String LOGFILE_SUFFIX = "_gsdi_log.txt";
    private static final String REMAPPED_SUFFIX = "_gsdi_remapped.txt";
    private static final String PRG_NAME = "gsdi";
    private static final String PRG_VERSION = "1.102";
    private static final String PRG_DATE = "180508";
    private static final String PRG_DESC = "general speciation duplication inference";
    private static final String E_MAIL = "phyloxml@gmail.com";
    private static final String WWW = "https://sites.google.com/site/cmzmasek/home/software/forester";

    public static void main(String[] stringArray) {
        try {
            ForesterUtil.printProgramInformation(PRG_NAME, PRG_DESC, PRG_VERSION, PRG_DATE, E_MAIL, WWW, ForesterUtil.getForesterLibraryInformation());
            CommandLineArguments commandLineArguments = null;
            try {
                commandLineArguments = new CommandLineArguments(stringArray);
            }
            catch (Exception exception) {
                ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
            }
            if (commandLineArguments.isOptionSet(HELP_OPTION_1) || commandLineArguments.isOptionSet(HELP_OPTION_2)) {
                System.out.println();
                gsdi.print_help();
                System.exit(0);
            } else if (stringArray.length < 2 || commandLineArguments.getNumberOfNames() != 3) {
                System.out.println();
                System.out.println("Wrong number of arguments.");
                System.out.println();
                gsdi.print_help();
                System.exit(-1);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(GSDIR_OPTION);
            arrayList.add(GUESS_FORMAT_OF_SPECIES_TREE);
            arrayList.add(MOST_PARSIMONIOUS_OPTION);
            arrayList.add(ALLOW_STRIPPING_OF_GENE_TREE_OPTION);
            arrayList.add(TRANSFER_TAXONOMY_OPTION);
            arrayList.add(SUFFIX_FOR_DIR_OPTION);
            arrayList.add(REMOVE_DUPLICATE_EXTERNAL_SPECIES_NODES_OPTION);
            String string = commandLineArguments.validateAllowedOptionsAsString(arrayList);
            if (string.length() > 0) {
                ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + string);
            }
            gsdi.execute(commandLineArguments);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, iOException.getMessage());
        }
    }

    private static final void execute(CommandLineArguments commandLineArguments) throws IOException {
        String string;
        SDIutil.ALGORITHM aLGORITHM = SDIutil.ALGORITHM.GSDI;
        boolean bl = false;
        boolean bl2 = false;
        if (commandLineArguments.isOptionSet(GSDIR_OPTION)) {
            aLGORITHM = SDIutil.ALGORITHM.GSDIR;
        }
        if (commandLineArguments.isOptionSet(MOST_PARSIMONIOUS_OPTION)) {
            if (aLGORITHM == SDIutil.ALGORITHM.SDI) {
                ForesterUtil.fatalError(PRG_NAME, "Cannot use most parsimonious duplication option with SDI");
            }
            if (aLGORITHM == SDIutil.ALGORITHM.GSDIR) {
                ForesterUtil.fatalError(PRG_NAME, "Cannot use most parsimonious duplication option with GSDIR");
            }
            bl = true;
        }
        if (commandLineArguments.isOptionSet(ALLOW_STRIPPING_OF_GENE_TREE_OPTION)) {
            if (aLGORITHM == SDIutil.ALGORITHM.SDI) {
                ForesterUtil.fatalError(PRG_NAME, "Cannot allow stripping of gene tree with SDI");
            }
            bl2 = true;
        }
        boolean bl3 = false;
        if (commandLineArguments.isOptionSet(TRANSFER_TAXONOMY_OPTION)) {
            bl3 = true;
        }
        boolean bl4 = false;
        if (commandLineArguments.isOptionSet(SUFFIX_FOR_DIR_OPTION)) {
            string = commandLineArguments.getOptionValue(SUFFIX_FOR_DIR_OPTION);
            bl4 = true;
        } else {
            string = null;
        }
        boolean bl5 = false;
        if (commandLineArguments.isOptionSet(REMOVE_DUPLICATE_EXTERNAL_SPECIES_NODES_OPTION)) {
            if (aLGORITHM != SDIutil.ALGORITHM.GSDIR) {
                ForesterUtil.fatalError(PRG_NAME, "Can use option to randomly remove external nodes from same species from gene trees only with GSDIR");
            }
            bl5 = true;
        }
        File file = null;
        File file2 = null;
        File file3 = null;
        File file4 = null;
        File file5 = null;
        try {
            file = commandLineArguments.getFile(0);
            file2 = commandLineArguments.getFile(1);
            if (bl4) {
                file5 = commandLineArguments.getFile(2);
                if (file5.exists()) {
                    if (!file5.isDirectory()) {
                        ForesterUtil.fatalError(PRG_NAME, "out-directory [" + file5 + "] already exists but is not a directory");
                    }
                } else {
                    boolean bl6 = file5.mkdirs();
                    if (!bl6) {
                        ForesterUtil.fatalError(PRG_NAME, "could not create out-directory [" + file5 + "]");
                    }
                }
            } else {
                file3 = commandLineArguments.getFile(2);
                file4 = new File(ForesterUtil.removeSuffix(file3.toString()) + LOGFILE_SUFFIX);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ForesterUtil.fatalError(PRG_NAME, "error in command line: " + illegalArgumentException.getMessage());
        }
        if (bl4) {
            String string2;
            File[] fileArray;
            File file6 = new File(file.toString());
            if (!file6.exists()) {
                ForesterUtil.fatalError(PRG_NAME, "in-directory [" + file6 + "] does not exist");
            }
            if (!file6.isDirectory()) {
                ForesterUtil.fatalError(PRG_NAME, "in-directory [" + file6 + "] is not a directory");
            }
            if ((fileArray = file6.listFiles(new FilenameFilter(string2 = file2.getName()){
                final /* synthetic */ String val$species_tree_file_name;
                {
                    this.val$species_tree_file_name = string2;
                }

                @Override
                public boolean accept(File file, String string2) {
                    return string2.endsWith(string) && !string2.equals(this.val$species_tree_file_name);
                }
            })).length < 1) {
                ForesterUtil.fatalError(PRG_NAME, "in-directory [" + file6 + "] does not contain any gene tree files with suffix " + string);
            }
            gsdi.executeDir(aLGORITHM, bl, bl2, bl3, fileArray, file2, file5, bl5);
        } else {
            gsdi.execute(aLGORITHM, bl, bl2, bl3, file, file2, file3, file4);
        }
    }

    private static final void executeDir(SDIutil.ALGORITHM aLGORITHM, boolean bl, boolean bl2, boolean bl3, File[] fileArray, File file, File file2, boolean bl4) throws IOException {
        File file3 = new File(file2, LOGFILE_NAME);
        if (ForesterUtil.isWritableFile(file3) != null) {
            ForesterUtil.fatalError(PRG_NAME, ForesterUtil.isWritableFile(file3));
        }
        EasyWriter easyWriter = null;
        try {
            easyWriter = ForesterUtil.createEasyWriter(file3);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "Failed to create [" + file3 + "]: " + iOException.getMessage());
        }
        easyWriter.println("# gsdi");
        easyWriter.println("# Version\t1.102");
        easyWriter.println("# Date\t180508");
        easyWriter.println("# Forester version\t1.050");
        easyWriter.println("# Species tree\t" + file.getCanonicalPath());
        if (aLGORITHM == SDIutil.ALGORITHM.GSDI) {
            easyWriter.println("# Algorithm\tGSDI");
            easyWriter.println("# Use most parsimonous duplication model\t" + bl);
        } else if (aLGORITHM == SDIutil.ALGORITHM.GSDIR) {
            easyWriter.println("# Algorithm\tGSDIR");
            easyWriter.println("# Randomly remove external nodes from same species from species trees\t" + bl4);
        }
        easyWriter.println("# Allow stripping of gene tree nodes\t" + bl2);
        easyWriter.println("# Start time\t" + new SimpleDateFormat("yyyyMMdd HH:mm:ss").format(new Date()));
        easyWriter.println();
        easyWriter.print("Gene-tree file\t");
        easyWriter.print("Gene-tree name/#\t");
        easyWriter.print("Ext. nodes\t");
        easyWriter.print("Speciations\t");
        easyWriter.print("Duplications\t");
        if (aLGORITHM == SDIutil.ALGORITHM.GSDIR && !bl4) {
            easyWriter.print("Non Spec-spec. Dup\t");
        }
        if (!bl && aLGORITHM == SDIutil.ALGORITHM.GSDI) {
            easyWriter.print("Spec. or Dup.\t");
        }
        if (bl2) {
            easyWriter.print("Stripped gene-tree ext. nodes\t");
        }
        easyWriter.print("Taxonomy mapping");
        easyWriter.println();
        int n = 0;
        Arrays.sort(fileArray);
        for (File file4 : fileArray) {
            String string = file4.getName();
            if (string.indexOf(".") > 0) {
                string = string.substring(0, string.lastIndexOf("."));
            }
            string = string + OUTTREE_SUFFIX;
            easyWriter.flush();
            System.out.print("\r" + (n += gsdi.executeOneTreeInDir(aLGORITHM, bl, bl2, bl3, file4, file, new File(file2, string), easyWriter, bl4)));
        }
        System.out.print("\r");
        easyWriter.close();
        System.out.println("Analyzed " + n + " gene trees");
        System.out.println();
        System.out.println("Wrote log to: " + file3.getCanonicalPath());
        System.out.println();
    }

    private static final int executeOneTreeInDir(SDIutil.ALGORITHM aLGORITHM, boolean bl, boolean bl2, boolean bl3, File file, File file2, File file3, EasyWriter easyWriter, boolean bl4) throws IOException {
        if (ForesterUtil.isReadableFile(file) != null) {
            ForesterUtil.fatalError(PRG_NAME, ForesterUtil.isReadableFile(file));
        }
        if (ForesterUtil.isReadableFile(file2) != null) {
            ForesterUtil.fatalError(PRG_NAME, ForesterUtil.isReadableFile(file2));
        }
        if (ForesterUtil.isWritableFile(file3) != null) {
            ForesterUtil.fatalError(PRG_NAME, ForesterUtil.isWritableFile(file3));
        }
        Phylogeny[] phylogenyArray = null;
        try {
            PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            phylogenyArray = phylogenyFactory.create(file, PhyloXmlParser.createPhyloXmlParserXsdValidating());
        }
        catch (IOException iOException) {
            gsdi.fatalError("error", "failed to read gene tree from [" + file + "]: " + iOException.getMessage(), easyWriter);
        }
        int n = 0;
        ArrayList<Phylogeny> arrayList = new ArrayList<Phylogeny>();
        for (Phylogeny phylogeny : phylogenyArray) {
            int n2;
            Object object;
            if (bl4) {
                PhylogenyMethods.removeDuplicateExternalSpeciesNodes(phylogeny);
            }
            if (phylogeny.isEmpty() || phylogeny.getNumberOfExternalNodes() <= 1) continue;
            Phylogeny phylogeny2 = null;
            try {
                phylogeny2 = SDIutil.parseSpeciesTree(phylogeny, file2, true, true, NHXParser.TAXONOMY_EXTRACTION.NO);
            }
            catch (PhyloXmlDataFormatException phyloXmlDataFormatException) {
                gsdi.fatalError("user error", "failed to transfer general node name, in [" + file2 + "]: " + phyloXmlDataFormatException.getMessage(), easyWriter);
            }
            catch (SDIException sDIException) {
                gsdi.fatalError("user error", sDIException.getMessage(), easyWriter);
            }
            catch (IOException iOException) {
                gsdi.fatalError("error", "Failed to read species tree from [" + file2 + "]: " + iOException.getMessage(), easyWriter);
            }
            phylogeny.setRooted(true);
            phylogeny2.setRooted(true);
            if (aLGORITHM == SDIutil.ALGORITHM.SDI && !phylogeny2.isCompletelyBinary()) {
                gsdi.fatalError("user error", "species tree is not completely binary, use GSDI or GSDIR instead", easyWriter);
            }
            easyWriter.print(file.getName());
            easyWriter.print("\t");
            easyWriter.print(ForesterUtil.isEmpty(phylogeny.getName()) ? "" : phylogeny.getName());
            if (phylogenyArray.length > 1) {
                easyWriter.print(ForesterUtil.isEmpty(phylogeny.getName()) ? Integer.toString(n) : ":" + Integer.toString(n));
            }
            easyWriter.print("\t");
            if (!phylogeny.isCompletelyBinary()) {
                easyWriter.write("not completely binary\n");
                continue;
            }
            GSDII gSDII = null;
            try {
                if (aLGORITHM == SDIutil.ALGORITHM.GSDI) {
                    gSDII = new GSDI(phylogeny, phylogeny2, bl, bl2, true, bl3);
                } else if (aLGORITHM == SDIutil.ALGORITHM.GSDIR) {
                    gSDII = new GSDIR(phylogeny, phylogeny2, bl2, true, bl3);
                }
            }
            catch (SDIException sDIException) {
                gsdi.fatalError("user error", sDIException.getLocalizedMessage(), easyWriter);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                ForesterUtil.outOfMemoryError(outOfMemoryError);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                gsdi.fatalError("unexpected error", exception.toString(), easyWriter);
            }
            if (aLGORITHM == SDIutil.ALGORITHM.GSDIR) {
                object = ((GSDIR)gSDII).getMinDuplicationsSumGeneTree();
                n2 = gsdi.calcNonSpeciesSpecificDups((Phylogeny)object);
                ((Phylogeny)object).setRerootable(false);
                arrayList.add((Phylogeny)object);
            } else {
                n2 = -1;
                phylogeny.setRerootable(false);
                arrayList.add(phylogeny);
            }
            easyWriter.print(phylogeny.getNumberOfExternalNodes() + "\t");
            easyWriter.print(gSDII.getSpeciationsSum() + "\t");
            if (aLGORITHM == SDIutil.ALGORITHM.GSDIR) {
                object = (GSDIR)gSDII;
                easyWriter.print(((GSDIR)object).getMinDuplicationsSum() + "\t");
                if (n2 > ((GSDIR)object).getMinDuplicationsSum()) {
                    ForesterUtil.fatalError(PRG_NAME, "non_species_specific_dups > dups [" + file + "]");
                }
                easyWriter.print(n2 + "\t");
            } else if (aLGORITHM == SDIutil.ALGORITHM.GSDI) {
                object = (GSDI)gSDII;
                easyWriter.print(((GSDI)object).getDuplicationsSum() + "\t");
                if (!bl) {
                    easyWriter.print(((GSDI)object).getSpeciationOrDuplicationEventsSum() + "\t");
                }
            }
            if (bl2) {
                easyWriter.print(gSDII.getStrippedExternalGeneTreeNodes().size() + "\t");
            }
            easyWriter.print(gSDII.getTaxCompBase().toString());
            easyWriter.println();
            ++n;
        }
        if (n > 0) {
            try {
                PhylogenyWriter phylogenyWriter = new PhylogenyWriter();
                phylogenyWriter.toPhyloXML(file3, arrayList, 0, ForesterUtil.LINE_SEPARATOR);
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, "Failed to write to [" + file3.getCanonicalPath() + "]: " + iOException.getMessage());
            }
        }
        return n;
    }

    private static final int calcNonSpeciesSpecificDups(Phylogeny phylogeny) {
        int n = 0;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isExternal() || !phylogenyNode.isDuplication() || PhylogenyMethods.isAllExternalDescedantsFromSameSpecies(phylogenyNode)) continue;
            ++n;
        }
        return n;
    }

    private static final void execute(SDIutil.ALGORITHM aLGORITHM, boolean bl, boolean bl2, boolean bl3, File file, File file2, File file3, File file4) throws IOException {
        Object object;
        Object object2;
        Object object3;
        if (ForesterUtil.isReadableFile(file) != null) {
            ForesterUtil.fatalError(PRG_NAME, ForesterUtil.isReadableFile(file));
        }
        if (ForesterUtil.isReadableFile(file2) != null) {
            ForesterUtil.fatalError(PRG_NAME, ForesterUtil.isReadableFile(file2));
        }
        if (ForesterUtil.isWritableFile(file3) != null) {
            ForesterUtil.fatalError(PRG_NAME, ForesterUtil.isWritableFile(file3));
        }
        if (ForesterUtil.isWritableFile(file4) != null) {
            ForesterUtil.fatalError(PRG_NAME, ForesterUtil.isWritableFile(file4));
        }
        EasyWriter easyWriter = null;
        try {
            easyWriter = ForesterUtil.createEasyWriter(file4);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "Failed to create [" + file4 + "]: " + iOException.getMessage());
        }
        Phylogeny phylogeny = null;
        Phylogeny phylogeny2 = null;
        try {
            object3 = ParserBasedPhylogenyFactory.getInstance();
            phylogeny2 = object3.create(file, PhyloXmlParser.createPhyloXmlParserXsdValidating())[0];
        }
        catch (IOException iOException) {
            gsdi.fatalError("error", "failed to read gene tree from [" + file + "]: " + iOException.getMessage(), easyWriter);
        }
        try {
            phylogeny = SDIutil.parseSpeciesTree(phylogeny2, file2, true, true, NHXParser.TAXONOMY_EXTRACTION.NO);
        }
        catch (PhyloXmlDataFormatException phyloXmlDataFormatException) {
            gsdi.fatalError("user error", "failed to transfer general node name, in [" + file2 + "]: " + phyloXmlDataFormatException.getMessage(), easyWriter);
        }
        catch (SDIException sDIException) {
            gsdi.fatalError("user error", sDIException.getMessage(), easyWriter);
        }
        catch (IOException iOException) {
            gsdi.fatalError("error", "Failed to read species tree from [" + file2 + "]: " + iOException.getMessage(), easyWriter);
        }
        phylogeny2.setRooted(true);
        phylogeny.setRooted(true);
        if (!phylogeny2.isCompletelyBinary()) {
            gsdi.fatalError("user error", "gene tree [" + file + "] is not completely binary", easyWriter);
        }
        if (aLGORITHM == SDIutil.ALGORITHM.SDI && !phylogeny.isCompletelyBinary()) {
            gsdi.fatalError("user error", "species tree is not completely binary, use GSDI or GSDIR instead", easyWriter);
        }
        easyWriter.println("gsdi - general speciation duplication inference");
        easyWriter.println("  version         : 1.102");
        easyWriter.println("  date            : 180508");
        easyWriter.println("  forester version: 1.050");
        easyWriter.println();
        easyWriter.println("Start time                               : " + new SimpleDateFormat("yyyyMMdd HH:mm:ss").format(new Date()));
        System.out.println("Start time                               : " + new SimpleDateFormat("yyyyMMdd HH:mm:ss").format(new Date()));
        easyWriter.println("Gene tree file                           : " + file.getCanonicalPath());
        System.out.println("Gene tree file                           : " + file.getCanonicalPath());
        easyWriter.println("Gene tree name                           : " + (ForesterUtil.isEmpty(phylogeny2.getName()) ? "" : phylogeny2.getName()));
        System.out.println("Gene tree name                           : " + (ForesterUtil.isEmpty(phylogeny2.getName()) ? "" : phylogeny2.getName()));
        easyWriter.println("Species tree file                        : " + file2.getCanonicalPath());
        System.out.println("Species tree file                        : " + file2.getCanonicalPath());
        easyWriter.println("Species tree name                        : " + (ForesterUtil.isEmpty(phylogeny.getName()) ? "" : phylogeny2.getName()));
        System.out.println("Species tree name                        : " + (ForesterUtil.isEmpty(phylogeny.getName()) ? "" : phylogeny2.getName()));
        System.out.println("Transfer taxonomy                        : " + bl3);
        object3 = null;
        long l = new Date().getTime();
        try {
            if (aLGORITHM == SDIutil.ALGORITHM.GSDI) {
                System.out.println("Algorithm                                : GSDI");
                easyWriter.println("Algorithm                                : GSDI");
            } else if (aLGORITHM == SDIutil.ALGORITHM.GSDIR) {
                System.out.println("Algorithm                                : GSDIR");
                easyWriter.println("Algorithm                                : GSDIR");
            }
            if (aLGORITHM == SDIutil.ALGORITHM.GSDI) {
                System.out.println("Use most parsimonous duplication model   : " + bl);
            }
            System.out.println("Allow stripping of gene tree nodes       : " + bl2);
            if (aLGORITHM == SDIutil.ALGORITHM.GSDI) {
                easyWriter.println("Use most parsimonous duplication model   : " + bl);
            }
            easyWriter.println("Allow stripping of gene tree nodes       : " + bl2);
            easyWriter.flush();
            if (aLGORITHM == SDIutil.ALGORITHM.GSDI) {
                object3 = new GSDI(phylogeny2, phylogeny, bl, bl2, true, bl3);
            } else if (aLGORITHM == SDIutil.ALGORITHM.GSDIR) {
                object3 = new GSDIR(phylogeny2, phylogeny, bl2, true, bl3);
            }
        }
        catch (SDIException sDIException) {
            gsdi.fatalError("user error", sDIException.getLocalizedMessage(), easyWriter);
        }
        catch (IOException iOException) {
            gsdi.fatalError("error", iOException.toString(), easyWriter);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            ForesterUtil.outOfMemoryError(outOfMemoryError);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            gsdi.fatalError("unexpected error", exception.toString(), easyWriter);
        }
        System.out.println("Running time (excluding I/O)             : " + (new Date().getTime() - l) + "ms");
        easyWriter.println("Running time (excluding I/O)             : " + (new Date().getTime() - l) + "ms");
        System.out.println("Mapping based on                         : " + (Object)((Object)object3.getTaxCompBase()));
        easyWriter.println("Mapping based on                         : " + (Object)((Object)object3.getTaxCompBase()));
        try {
            object2 = new PhylogenyWriter();
            if (aLGORITHM == SDIutil.ALGORITHM.GSDIR) {
                object = ((GSDIR)object3).getMinDuplicationsSumGeneTree();
                ((Phylogeny)object).setRerootable(false);
                ((PhylogenyWriter)object2).toPhyloXML(file3, (Phylogeny)object, 0);
            } else {
                phylogeny2.setRerootable(false);
                ((PhylogenyWriter)object2).toPhyloXML(file3, phylogeny2, 0);
            }
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "Failed to write to [" + file3.getCanonicalPath() + "]: " + iOException.getMessage());
        }
        System.out.println("Wrote resulting gene tree to             : " + file3.getCanonicalPath());
        easyWriter.println("Wrote resulting gene tree to             : " + file3.getCanonicalPath());
        object2 = new File(ForesterUtil.removeSuffix(file3.toString()) + SUFFIX_FOR_SPECIES_TREE_USED);
        try {
            object = new PhylogenyWriter();
            ((PhylogenyWriter)object).toPhyloXML((File)object2, phylogeny, 0);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "Failed to write to [" + ((File)object2).getCanonicalPath() + "]: " + iOException.getMessage());
        }
        System.out.println("Wrote (stripped) species tree to         : " + ((File)object2).getCanonicalPath());
        easyWriter.println("Wrote (stripped) species tree to         : " + ((File)object2).getCanonicalPath());
        if (object3.getReMappedScientificNamesFromGeneTree() != null && !object3.getReMappedScientificNamesFromGeneTree().isEmpty()) {
            System.out.println("Number of gene tree species remapped     : " + object3.getReMappedScientificNamesFromGeneTree().size());
            easyWriter.println("Number of gene tree species remapped     : " + object3.getReMappedScientificNamesFromGeneTree().size());
            gsdi.writeToRemappedFile(file3, object3.getReMappedScientificNamesFromGeneTree(), easyWriter);
        }
        System.out.println("Number of external nodes in gene tree    : " + phylogeny2.getNumberOfExternalNodes());
        easyWriter.println("Number of external nodes in gene tree    : " + phylogeny2.getNumberOfExternalNodes());
        System.out.println("Number of external nodes in species tree : " + phylogeny.getNumberOfExternalNodes());
        easyWriter.println("Number of external nodes in species tree : " + phylogeny.getNumberOfExternalNodes());
        int n = PhylogenyMethods.countNumberOfPolytomies(phylogeny);
        System.out.println("Number of polytomies in species tree     : " + n);
        easyWriter.println("Number of polytomies in species tree     : " + n);
        System.out.println("External nodes stripped from gene tree   : " + object3.getStrippedExternalGeneTreeNodes().size());
        easyWriter.println("External nodes stripped from gene tree   : " + object3.getStrippedExternalGeneTreeNodes().size());
        System.out.println("External nodes stripped from species tree: " + object3.getStrippedSpeciesTreeNodes().size());
        easyWriter.println("External nodes stripped from species tree: " + object3.getStrippedSpeciesTreeNodes().size());
        System.out.println();
        System.out.println("Number of speciations                    : " + object3.getSpeciationsSum());
        easyWriter.println("Number of speciations                    : " + object3.getSpeciationsSum());
        if (aLGORITHM == SDIutil.ALGORITHM.GSDIR) {
            GSDIR gSDIR = (GSDIR)object3;
            System.out.println("Minimal number of duplications           : " + gSDIR.getMinDuplicationsSum());
            easyWriter.println("Minimal number of duplications           : " + gSDIR.getMinDuplicationsSum());
        } else if (aLGORITHM == SDIutil.ALGORITHM.GSDI) {
            GSDI gSDI = (GSDI)object3;
            System.out.println("Number of duplications                   : " + gSDI.getDuplicationsSum());
            easyWriter.println("Number of duplications                   : " + gSDI.getDuplicationsSum());
            if (!bl) {
                int n2 = gSDI.getSpeciationOrDuplicationEventsSum();
                System.out.println("Number of potential duplications         : " + n2);
                easyWriter.println("Number of potential duplications         : " + n2);
            }
        }
        easyWriter.println();
        gsdi.printMappedNodesToLog(easyWriter, (GSDII)object3);
        easyWriter.println();
        gsdi.printStrippedGeneTreeNodesToLog(easyWriter, (GSDII)object3);
        System.out.println();
        System.out.println("Wrote log to                             : " + file4.getCanonicalPath());
        System.out.println();
        easyWriter.close();
    }

    private static final void fatalError(String string, String string2, EasyWriter easyWriter) {
        try {
            easyWriter.flush();
            easyWriter.println();
            easyWriter.print(string.toUpperCase() + ": ");
            easyWriter.println(string2);
            easyWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        ForesterUtil.fatalError(PRG_NAME, string2);
    }

    private static final void print_help() {
        System.out.println("Usage: gsdi [-options] <gene tree file, or gene trees in-directory> <species tree> <outfile, or out-directory>");
        System.out.println();
        System.out.println("Options:");
        System.out.println(" -g         : to allow stripping of gene tree nodes without a matching species");
        System.out.println(" -m         : use most parimonious duplication model for GSDI: ");
        System.out.println("              assign nodes as speciations which would otherwise be assiged");
        System.out.println("              as potential duplications due to polytomies in the species tree");
        System.out.println(" -q         : to allow species tree in other formats than phyloXML (i.e. Newick, NHX, Nexus)");
        System.out.println(" -r         : to use GSDIR algorithm instead of GSDI algorithm (re-rooting)");
        System.out.println(" -t         : to transfer taxonomic data from species tree to gene tree");
        System.out.println(" -s=<suffix>: suffix for gene trees for analyzing entire directory of trees");
        System.out.println(" -R         : to randomly remove external nodes from gene trees from same species (only with GSDIR)");
        System.out.println();
        System.out.println();
        System.out.println("Gene tree(s):");
        System.out.println(" in phyloXM format, with taxonomy and sequence data in appropriate fields");
        System.out.println();
        System.out.println("Species tree:");
        System.out.println(" in phyloXML format (unless option -q is used)");
        System.out.println();
        System.out.println("Examples: gsdi -g gene_tree.xml tree_of_life.xml out.xml");
        System.out.println("          gsdi -g -s=.xml gene_tree_dir tree_of_life.xml out_dir");
        System.out.println("          gsdi -g -m -r -t -s=.xml gene_tree_dir tree_of_life.xml out_dir");
        System.out.println();
    }

    private static final void printMappedNodesToLog(EasyWriter easyWriter, GSDII gSDII) throws IOException {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (PhylogenyNode object : gSDII.getMappedExternalSpeciesTreeNodes()) {
            treeSet.add(object.toString());
        }
        easyWriter.println("The following " + treeSet.size() + " species were used: ");
        for (String string : treeSet) {
            easyWriter.println("  " + string);
        }
    }

    private static final void printStrippedGeneTreeNodesToLog(EasyWriter easyWriter, GSDII gSDII) throws IOException {
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        for (PhylogenyNode object : gSDII.getStrippedExternalGeneTreeNodes()) {
            String string = object.toString();
            if (treeMap.containsKey(string)) {
                treeMap.put(string, (Integer)treeMap.get(string) + 1);
                continue;
            }
            treeMap.put(string, 1);
        }
        easyWriter.println("The following " + treeMap.size() + " nodes were stripped from the gene tree: ");
        for (String string : treeMap.keySet()) {
            int n = (Integer)treeMap.get(string);
            if (n == 1) {
                easyWriter.println("  " + string);
                continue;
            }
            easyWriter.println("  " + string + " [" + n + "]");
        }
    }

    private static final void writeToRemappedFile(File file, SortedSet<String> sortedSet, EasyWriter easyWriter) throws IOException {
        File file2 = new File(ForesterUtil.removeSuffix(file.toString()) + REMAPPED_SUFFIX);
        EasyWriter easyWriter2 = ForesterUtil.createEasyWriter(file2);
        for (String string : sortedSet) {
            easyWriter2.println(string);
        }
        easyWriter2.close();
        System.out.println("Wrote remapped gene tree species to      : " + file2.getCanonicalPath());
        easyWriter.println("Wrote remapped gene tree species to      : " + file2.getCanonicalPath());
    }
}

