/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.model.threedimensional;

import com.approximatrix.charting.model.AbstractChartDataModel;
import com.approximatrix.charting.model.ChartDataModelConstraints;
import com.approximatrix.charting.model.IntegratedImageModel;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;

public abstract class AbstractDotPlotDataModel
extends AbstractChartDataModel
implements IntegratedImageModel {
    protected BufferedImage dataImage = null;
    protected double minX = 0.0;
    protected double maxX = 0.0;
    protected double minY = 0.0;
    protected double maxY = 0.0;
    protected ChartDataModelConstraints constraints = null;

    protected AbstractDotPlotDataModel() {
        this.autoscale = true;
    }

    public BufferedImage getImage() {
        return this.dataImage;
    }

    @Override
    public Image getViewableImage() {
        AffineTransformOp op;
        AffineTransform tx;
        if (this.dataImage == null) {
            this.buildImage();
        }
        if (this.autoscale) {
            return this.dataImage;
        }
        boolean flipx = false;
        boolean flipy = false;
        int pminx = this.getXIndex(this.minX);
        int pmaxx = this.getXIndex(this.maxX);
        int pminy = this.getYIndex(this.minY);
        int pmaxy = this.getYIndex(this.maxY);
        try {
            pminx = this.getXIndex(this.getManualMinimumX().doubleValue());
            pmaxx = this.getXIndex(this.getManualMaximumX().doubleValue());
            pminy = this.getYIndex(this.getManualMinimumY().doubleValue());
            pmaxy = this.getYIndex(this.getManualMaximumY().doubleValue());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        ++pminy;
        ++pmaxy;
        if (pmaxx < pminx) {
            flipx = true;
            pminx = this.dataImage.getWidth() - pminx;
            pmaxx = this.dataImage.getWidth() - pmaxx;
        }
        if (pminy < pmaxy) {
            flipy = true;
            pminy = this.dataImage.getHeight() - pminy;
            pmaxy = this.dataImage.getHeight() - pmaxy;
        }
        BufferedImage ret = this.dataImage;
        if (flipx) {
            tx = AffineTransform.getScaleInstance(-1.0, 1.0);
            tx.translate(-ret.getWidth(null), 0.0);
            op = new AffineTransformOp(tx, 1);
            ret = op.filter(ret, null);
        }
        if (flipy) {
            tx = AffineTransform.getScaleInstance(1.0, -1.0);
            tx.translate(0.0, -ret.getHeight(null));
            op = new AffineTransformOp(tx, 1);
            ret = op.filter(ret, null);
        }
        try {
            ret = ret.getSubimage(pminx, pmaxy, Math.abs(pmaxx - pminx), Math.abs(pmaxy - pminy));
        }
        catch (RasterFormatException rfe) {
            int imw = Math.abs(pmaxx - pminx);
            int imh = Math.abs(pmaxy - pminy);
            imw = Math.max(imw, 1);
            imh = Math.max(imh, 1);
            BufferedImage rebuilt = new BufferedImage(imw, imh, this.dataImage.getType());
            Graphics g = rebuilt.getGraphics();
            try {
                int newx = Math.max(0, pminx);
                int newy = Math.max(0, pmaxy);
                int w = Math.abs(newx - Math.min(pmaxx, ret.getWidth()));
                int h = Math.abs(newy - Math.min(pminy, ret.getHeight()));
                BufferedImage sub = ret.getSubimage(newx, newy, w, h);
                g.drawImage(sub, Math.abs(Math.min(pminx, 0)), Math.abs(Math.min(pmaxy, 0)), null);
                ret = rebuilt;
            }
            catch (RasterFormatException rfepossibly) {
                System.err.println("Error in AbstractDotPlotDataModel");
                rfepossibly.printStackTrace();
                ret = null;
            }
        }
        return ret;
    }

    public int getXIndex(double datavalue) {
        double[] values = new double[]{datavalue};
        return this.getXIndices(values)[0];
    }

    public int getYIndex(double datavalue) {
        double[] values = new double[]{datavalue};
        return this.getYIndices(values)[0];
    }

    private int getIndex(double datavalue, double minval, double maxval, int size) {
        double range = maxval - minval;
        if (range == 0.0) {
            return 0;
        }
        return (int)(datavalue / range * (double)size);
    }

    public int[] getXIndices(double[] datavalue) {
        return this.getIndices(datavalue, this.minX, this.maxX, this.dataImage.getWidth());
    }

    public int[] getYIndices(double[] datavalue) {
        return this.getIndices(datavalue, this.maxY, this.minY, this.dataImage.getHeight());
    }

    private int[] getIndices(double[] datavalue, double minval, double maxval, int size) throws NullPointerException {
        if (datavalue == null) {
            throw new NullPointerException();
        }
        double range = maxval - minval;
        if (range == 0.0) {
            return null;
        }
        double multiplier = (double)size / range;
        int[] value = new int[datavalue.length];
        int i = 0;
        while (i < datavalue.length) {
            double val = (datavalue[i] - minval) * multiplier;
            value[i] = val < 0.0 ? (int)Math.ceil(val) : (int)Math.floor(val);
            ++i;
        }
        return value;
    }

    protected void scanRanges(double[] x, double[] y) {
        this.maxX = Double.MIN_VALUE;
        this.minX = Double.MAX_VALUE;
        this.maxY = Double.MIN_VALUE;
        this.minY = Double.MAX_VALUE;
        int i = 0;
        while (i < x.length && i < y.length) {
            this.maxX = Math.max(this.maxX, x[i]);
            this.minX = Math.min(this.minX, x[i]);
            this.maxY = Math.max(this.maxY, y[i]);
            this.minY = Math.min(this.minY, y[i]);
            ++i;
        }
    }

    protected void initializeImage(int w, int h) {
        this.dataImage = new BufferedImage(w, h, 2);
    }

    protected abstract void buildImage();

    @Override
    public void setChartDataModelConstraints(int axis, ChartDataModelConstraints constraints) {
        if (axis == 0) {
            this.constraints = constraints;
        }
    }

    @Override
    public ChartDataModelConstraints getChartDataModelConstraints(int axis) {
        if (axis == 0) {
            return this.constraints;
        }
        return null;
    }

    public double getModelMaximumX() {
        return this.maxX;
    }

    public double getModelMinimumX() {
        return this.minX;
    }

    public double getModelMaximumY() {
        return this.maxY;
    }

    public double getModelMinimumY() {
        return this.minY;
    }

    @Override
    public boolean isColumnNumeric() {
        return true;
    }
}

