/*
 * Decompiled with CFR 0.152.
 */
package com.pomodorotechnique.server.api;

import com.pomodorotechnique.server.InterruptionType;
import com.pomodorotechnique.server.MessageType;
import com.pomodorotechnique.server.Messages;
import com.pomodorotechnique.server.PlanType;
import com.pomodorotechnique.server.Plans;
import com.pomodorotechnique.server.PomodoroType;
import com.pomodorotechnique.server.StatusType;
import com.pomodorotechnique.server.UserType;
import com.pomodorotechnique.server.Users;
import com.pomodorotechnique.server.WorkitemType;
import com.pomodorotechnique.server.api.AlreadyExistsException;
import com.pomodorotechnique.server.api.InvalidStateException;
import com.pomodorotechnique.server.api.LoginException;
import com.pomodorotechnique.server.api.NoPomodorosLeftException;
import com.pomodorotechnique.server.api.NotFoundException;
import com.pomodorotechnique.server.api.Server;
import com.sun.org.apache.xerces.internal.jaxp.datatype.XMLGregorianCalendarImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import javax.xml.bind.JAXB;
import javax.xml.datatype.XMLGregorianCalendar;

public class RestfulServerImpl
implements Server {
    private final UserType user;
    private final Users users;

    public RestfulServerImpl(String userid, String password) throws IOException, LoginException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("users.xml");
        try {
            this.users = (Users)JAXB.unmarshal((InputStream)is, Users.class);
            for (UserType u : this.users.getUser()) {
                if (!u.getId().equals(userid) || !u.getPassword().equals(password)) continue;
                this.user = u;
                return;
            }
            throw new LoginException();
        }
        finally {
            is.close();
        }
    }

    public void logout() {
    }

    public Users getAllUsers() {
        return this.users;
    }

    public PomodoroType addPomodoro(WorkitemType wi) {
        PomodoroType p = new PomodoroType();
        p.setPlanned(false);
        p.setStatus(StatusType.NEW);
        wi.getPomodoro().add(p);
        return p;
    }

    public WorkitemType addWorkItem(String workItemTitle, int pomodoros) throws NotFoundException {
        WorkitemType wi = new WorkitemType();
        wi.setSection(this.getPlan().getStatus().equals((Object)StatusType.NEW) ? "planned" : "unplanned");
        wi.setStatus(StatusType.NEW);
        wi.setTitle(workItemTitle);
        for (int i = 0; i < pomodoros; ++i) {
            PomodoroType pomodoroType = new PomodoroType();
            pomodoroType.setPlanned(false);
            pomodoroType.setStatus(StatusType.NEW);
            wi.getPomodoro().add(pomodoroType);
        }
        this.getPlan().getWorkitem().add(wi);
        return wi;
    }

    public void completeWorkItem(WorkitemType wi) {
        wi.setStatus(StatusType.COMPLETED);
    }

    public UserType getUser() {
        return this.user;
    }

    public PlanType getPlan(Calendar date) throws NotFoundException {
        for (PlanType p : this.user.getPlan()) {
            if (!p.getDate().equals(XMLGregorianCalendarImpl.createDate(date.get(1), date.get(2) + 1, date.get(5), Integer.MIN_VALUE))) continue;
            return p;
        }
        throw new NotFoundException("Plan for given date (" + date + ") not found.");
    }

    public void registerInterruption(WorkitemType workItem, InterruptionType interruption) {
        for (PomodoroType p : workItem.getPomodoro()) {
            if (!p.getStatus().equals((Object)StatusType.STARTED)) continue;
            p.getInterruption().add(interruption);
        }
    }

    public PomodoroType startNextPomodoro(WorkitemType wi) throws NotFoundException, NoPomodorosLeftException {
        Calendar date = this.getToday();
        XMLGregorianCalendar now = XMLGregorianCalendarImpl.createDate(date.get(1), date.get(2) + 1, date.get(5), Integer.MIN_VALUE);
        for (PomodoroType p : wi.getPomodoro()) {
            if (!p.getStatus().equals((Object)StatusType.NEW)) continue;
            p.setStart(now);
            p.setStatus(StatusType.STARTED);
            this.getPlan().setStatus(StatusType.STARTED);
            wi.setStatus(StatusType.STARTED);
            return p;
        }
        throw new NoPomodorosLeftException();
    }

    public void voidPomodoro(WorkitemType workItem) {
        for (PomodoroType p : workItem.getPomodoro()) {
            if (!p.getStatus().equals((Object)StatusType.STARTED)) continue;
            p.setStatus(StatusType.FAILED);
            return;
        }
    }

    public void completePomodoro(WorkitemType workItem) throws InvalidStateException {
        for (PomodoroType p : workItem.getPomodoro()) {
            if (!p.getStatus().equals((Object)StatusType.STARTED)) continue;
            p.setStatus(StatusType.COMPLETED);
            return;
        }
    }

    private Calendar getToday() {
        Calendar date = Calendar.getInstance();
        date.set(1, 2001);
        date.set(2, 3);
        date.set(5, 2);
        return date;
    }

    public PlanType getPlan() throws NotFoundException {
        return this.getPlan(this.getToday());
    }

    public PlanType createPlan() throws AlreadyExistsException {
        PlanType res = new PlanType();
        Calendar date = this.getToday();
        res.setStatus(StatusType.NEW);
        res.setDate(XMLGregorianCalendarImpl.createDate(date.get(1), date.get(2) + 1, date.get(5), Integer.MIN_VALUE));
        this.user.getPlan().add(res);
        return res;
    }

    public Plans getPlans() {
        Plans plans = new Plans();
        plans.getPlan().addAll(this.user.getPlan());
        return plans;
    }

    public Messages getMessages(WorkitemType workItem) {
        for (PomodoroType p : workItem.getPomodoro()) {
            if (!p.getStatus().equals((Object)StatusType.STARTED)) continue;
        }
        Messages m = new Messages();
        MessageType mm = new MessageType();
        mm.setFrom("kos");
        mm.setText("test message text\nmultiline");
        Calendar date = Calendar.getInstance();
        date.setTime(new Date());
        XMLGregorianCalendar now = XMLGregorianCalendarImpl.createDate(date.get(1), date.get(2) + 1, date.get(5), Integer.MIN_VALUE);
        mm.setWhen(now);
        m.getMessage().add(mm);
        return m;
    }

    public void sendMessage(String userId, String message) throws InvalidStateException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void deletePlan(PlanType plan) {
        this.user.getPlan().remove(plan);
    }
}

