/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.gui.CategoryNode;
import org.languagetool.gui.CheckBoxTreeCellRenderer;
import org.languagetool.gui.Configuration;
import org.languagetool.gui.RuleNode;
import org.languagetool.gui.SavablePanel;
import org.languagetool.gui.Tools;
import org.languagetool.gui.TreeListener;
import org.languagetool.languagemodel.LuceneLanguageModel;
import org.languagetool.rules.Rule;

public class ConfigurationDialog
implements ActionListener {
    private static final String NO_MOTHER_TONGUE = "---";
    private static final String ACTION_COMMAND_OK = "OK";
    private static final String ACTION_COMMAND_CANCEL = "CANCEL";
    private static final int MAX_PORT = 65536;
    private final ResourceBundle messages;
    private final Configuration original;
    private final Configuration config;
    private final Frame owner;
    private final boolean insideOffice;
    private JDialog dialog;
    private JCheckBox serverCheckbox;
    private JTextField serverPortField;
    private JTree configTree;
    private JCheckBox serverSettingsCheckbox;
    private final List<JPanel> extraPanels = new ArrayList<JPanel>();

    public ConfigurationDialog(Frame owner, boolean insideOffice, Configuration config) {
        this.owner = owner;
        this.insideOffice = insideOffice;
        this.original = config;
        this.config = this.original.copy(this.original);
        this.messages = JLanguageTool.getMessageBundle();
    }

    void addExtraPanel(JPanel panel) {
        this.extraPanels.add(panel);
    }

    private DefaultMutableTreeNode createTree(List<Rule> rules) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Rules");
        String lastRuleId = null;
        TreeMap<String, CategoryNode> parents = new TreeMap<String, CategoryNode>();
        for (Rule rule : rules) {
            if (!parents.containsKey(rule.getCategory().getName())) {
                boolean enabled = true;
                if (this.config.getDisabledCategoryNames() != null && this.config.getDisabledCategoryNames().contains(rule.getCategory().getName())) {
                    enabled = false;
                }
                if (rule.getCategory().isDefaultOff()) {
                    enabled = false;
                }
                CategoryNode categoryNode = new CategoryNode(rule.getCategory(), enabled);
                root.add(categoryNode);
                parents.put(rule.getCategory().getName(), categoryNode);
            }
            if (!rule.getId().equals(lastRuleId)) {
                RuleNode ruleNode = new RuleNode(rule, this.getEnabledState(rule));
                ((DefaultMutableTreeNode)parents.get(rule.getCategory().getName())).add(ruleNode);
            }
            lastRuleId = rule.getId();
        }
        return root;
    }

    private boolean getEnabledState(Rule rule) {
        boolean ret = true;
        if (this.config.getDisabledRuleIds().contains(rule.getId())) {
            ret = false;
        }
        if (this.config.getDisabledCategoryNames().contains(rule.getCategory().getName())) {
            ret = false;
        }
        if ((rule.isDefaultOff() || rule.getCategory().isDefaultOff()) && !this.config.getEnabledRuleIds().contains(rule.getId())) {
            ret = false;
        }
        if (rule.isDefaultOff() && rule.getCategory().isDefaultOff() && this.config.getEnabledRuleIds().contains(rule.getId())) {
            this.config.getDisabledCategoryNames().remove(rule.getCategory().getName());
        }
        return ret;
    }

    public void show(List<Rule> rules) {
        if (this.original != null) {
            this.config.restoreState(this.original);
        }
        this.dialog = new JDialog(this.owner, true);
        this.dialog.setTitle(this.messages.getString("guiConfigWindowTitle"));
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationDialog.this.dialog.setVisible(false);
            }
        };
        JRootPane rootPane = this.dialog.getRootPane();
        rootPane.registerKeyboardAction(actionListener, stroke, 2);
        JPanel checkBoxPanel = new JPanel();
        checkBoxPanel.setLayout(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints();
        cons.anchor = 18;
        cons.gridx = 0;
        cons.weightx = 1.0;
        cons.weighty = 1.0;
        cons.fill = 1;
        Collections.sort(rules, new CategoryComparator());
        DefaultMutableTreeNode rootNode = this.createTree(rules);
        this.configTree = new JTree(this.getTreeModel(rootNode));
        Language lang = this.config.getLanguage();
        if (lang == null) {
            lang = Languages.getLanguageForLocale((Locale)Locale.getDefault());
        }
        this.configTree.applyComponentOrientation(ComponentOrientation.getOrientation(lang.getLocale()));
        this.configTree.setRootVisible(false);
        this.configTree.setEditable(false);
        this.configTree.setCellRenderer(new CheckBoxTreeCellRenderer());
        TreeListener.install(this.configTree);
        checkBoxPanel.add((Component)this.configTree, cons);
        this.configTree.addMouseListener(this.getMouseAdapter());
        JPanel portPanel = new JPanel();
        portPanel.setLayout(new GridBagLayout());
        cons = new GridBagConstraints();
        cons.insets = new Insets(0, 4, 0, 0);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.anchor = 17;
        cons.fill = 0;
        cons.weightx = 0.0;
        if (!this.insideOffice) {
            this.createNonOfficeElements(cons, portPanel);
        }
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        JButton okButton = new JButton(Tools.getLabel(this.messages.getString("guiOKButton")));
        okButton.setMnemonic(Tools.getMnemonic(this.messages.getString("guiOKButton")));
        okButton.setActionCommand(ACTION_COMMAND_OK);
        okButton.addActionListener(this);
        JButton cancelButton = new JButton(Tools.getLabel(this.messages.getString("guiCancelButton")));
        cancelButton.setMnemonic(Tools.getMnemonic(this.messages.getString("guiCancelButton")));
        cancelButton.setActionCommand(ACTION_COMMAND_CANCEL);
        cancelButton.addActionListener(this);
        cons = new GridBagConstraints();
        cons.insets = new Insets(0, 4, 0, 0);
        buttonPanel.add((Component)okButton, cons);
        buttonPanel.add((Component)cancelButton, cons);
        Container contentPane = this.dialog.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        cons = new GridBagConstraints();
        cons.insets = new Insets(4, 4, 4, 4);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 10.0;
        cons.weighty = 10.0;
        cons.fill = 1;
        contentPane.add((Component)new JScrollPane(checkBoxPanel), cons);
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        cons.gridx = 0;
        ++cons.gridy;
        cons.fill = 0;
        cons.anchor = 22;
        contentPane.add((Component)this.getTreeButtonPanel(), cons);
        ++cons.gridy;
        cons.anchor = 17;
        contentPane.add((Component)this.getMotherTonguePanel(cons), cons);
        ++cons.gridy;
        cons.anchor = 17;
        contentPane.add((Component)this.getNgramPanel(cons), cons);
        ++cons.gridy;
        cons.anchor = 17;
        contentPane.add((Component)portPanel, cons);
        cons.fill = 2;
        cons.anchor = 17;
        for (JPanel extra : this.extraPanels) {
            ++cons.gridy;
            contentPane.add((Component)extra, cons);
        }
        cons.fill = 0;
        ++cons.gridy;
        cons.anchor = 13;
        contentPane.add((Component)buttonPanel, cons);
        this.dialog.pack();
        this.dialog.setSize(500, 500);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.dialog.getSize();
        this.dialog.setLocation(screenSize.width / 2 - frameSize.width / 2, screenSize.height / 2 - frameSize.height / 2);
        this.dialog.setLocationByPlatform(true);
        for (JPanel extra : this.extraPanels) {
            if (!(extra instanceof SavablePanel)) continue;
            ((SavablePanel)((Object)extra)).componentShowing();
        }
        this.dialog.setVisible(true);
    }

    private void createNonOfficeElements(GridBagConstraints cons, JPanel portPanel) {
        this.serverCheckbox = new JCheckBox(Tools.getLabel(this.messages.getString("guiRunOnPort")));
        this.serverCheckbox.setMnemonic(Tools.getMnemonic(this.messages.getString("guiRunOnPort")));
        this.serverCheckbox.setSelected(this.config.getRunServer());
        portPanel.add((Component)this.serverCheckbox, cons);
        this.serverCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigurationDialog.this.serverPortField.setEnabled(ConfigurationDialog.this.serverCheckbox.isSelected());
                ConfigurationDialog.this.serverSettingsCheckbox.setEnabled(ConfigurationDialog.this.serverCheckbox.isSelected());
            }
        });
        this.serverCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ConfigurationDialog.this.config.setRunServer(ConfigurationDialog.this.serverCheckbox.isSelected());
            }
        });
        this.serverPortField = new JTextField(Integer.toString(this.config.getServerPort()));
        this.serverPortField.setEnabled(this.serverCheckbox.isSelected());
        this.serverSettingsCheckbox = new JCheckBox(Tools.getLabel(this.messages.getString("useGUIConfig")));
        this.serverPortField.setMinimumSize(new Dimension(100, 25));
        cons.gridx = 1;
        portPanel.add((Component)this.serverPortField, cons);
        this.serverPortField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                try {
                    int serverPort = Integer.parseInt(ConfigurationDialog.this.serverPortField.getText());
                    if (serverPort > -1 && serverPort < 65536) {
                        ConfigurationDialog.this.serverPortField.setForeground(null);
                        ConfigurationDialog.this.config.setServerPort(serverPort);
                    } else {
                        ConfigurationDialog.this.serverPortField.setForeground(Color.RED);
                    }
                }
                catch (NumberFormatException ex) {
                    ConfigurationDialog.this.serverPortField.setForeground(Color.RED);
                }
            }
        });
        cons.gridx = 0;
        cons.gridy = 10;
        this.serverSettingsCheckbox.setMnemonic(Tools.getMnemonic(this.messages.getString("useGUIConfig")));
        this.serverSettingsCheckbox.setSelected(this.config.getUseGUIConfig());
        this.serverSettingsCheckbox.setEnabled(this.config.getRunServer());
        this.serverSettingsCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ConfigurationDialog.this.config.setUseGUIConfig(ConfigurationDialog.this.serverSettingsCheckbox.isSelected());
            }
        });
        portPanel.add((Component)this.serverSettingsCheckbox, cons);
    }

    @NotNull
    private DefaultTreeModel getTreeModel(DefaultMutableTreeNode rootNode) {
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        treeModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                DefaultMutableTreeNode o;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getTreePath().getLastPathComponent();
                int index = e.getChildIndices()[0];
                if ((node = (DefaultMutableTreeNode)node.getChildAt(index)) instanceof RuleNode) {
                    o = (RuleNode)node;
                    if (((RuleNode)o).getRule().isDefaultOff()) {
                        if (((RuleNode)o).isEnabled()) {
                            ConfigurationDialog.this.config.getEnabledRuleIds().add(((RuleNode)o).getRule().getId());
                        } else {
                            ConfigurationDialog.this.config.getEnabledRuleIds().remove(((RuleNode)o).getRule().getId());
                        }
                    } else if (((RuleNode)o).isEnabled()) {
                        ConfigurationDialog.this.config.getDisabledRuleIds().remove(((RuleNode)o).getRule().getId());
                    } else {
                        ConfigurationDialog.this.config.getDisabledRuleIds().add(((RuleNode)o).getRule().getId());
                    }
                }
                if (node instanceof CategoryNode) {
                    o = (CategoryNode)node;
                    if (((CategoryNode)o).isEnabled()) {
                        ConfigurationDialog.this.config.getDisabledCategoryNames().remove(((CategoryNode)o).getCategory().getName());
                    } else {
                        ConfigurationDialog.this.config.getDisabledCategoryNames().add(((CategoryNode)o).getCategory().getName());
                    }
                }
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
            }
        });
        return treeModel;
    }

    @NotNull
    private MouseAdapter getMouseAdapter() {
        return new MouseAdapter(){

            private void handlePopupEvent(MouseEvent e) {
                final JTree tree = (JTree)e.getSource();
                TreePath path = tree.getPathForLocation(e.getX(), e.getY());
                if (path == null) {
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                TreePath[] paths = tree.getSelectionPaths();
                boolean isSelected = false;
                if (paths != null) {
                    for (TreePath selectionPath : paths) {
                        if (!selectionPath.equals(path)) continue;
                        isSelected = true;
                    }
                }
                if (!isSelected) {
                    tree.setSelectionPath(path);
                }
                if (node.isLeaf()) {
                    JPopupMenu popup = new JPopupMenu();
                    JMenuItem aboutRuleMenuItem = new JMenuItem(ConfigurationDialog.this.messages.getString("guiAboutRuleMenu"));
                    aboutRuleMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            RuleNode node = (RuleNode)tree.getSelectionPath().getLastPathComponent();
                            Rule rule = node.getRule();
                            Language lang = ConfigurationDialog.this.config.getLanguage();
                            if (lang == null) {
                                lang = Languages.getLanguageForLocale((Locale)Locale.getDefault());
                            }
                            Tools.showRuleInfoDialog(tree, ConfigurationDialog.this.messages.getString("guiAboutRuleTitle"), rule.getDescription(), rule, ConfigurationDialog.this.messages, lang.getShortNameWithCountryAndVariant());
                        }
                    });
                    popup.add(aboutRuleMenuItem);
                    popup.show(tree, e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.handlePopupEvent(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.handlePopupEvent(e);
                }
            }
        };
    }

    @NotNull
    private JPanel getTreeButtonPanel() {
        JPanel treeButtonPanel = new JPanel();
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        JButton expandAllButton = new JButton(this.messages.getString("guiExpandAll"));
        treeButtonPanel.add((Component)expandAllButton, cons);
        expandAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeNode root = (TreeNode)ConfigurationDialog.this.configTree.getModel().getRoot();
                TreePath parent = new TreePath(root);
                Enumeration<? extends TreeNode> cat = root.children();
                while (cat.hasMoreElements()) {
                    TreeNode n = cat.nextElement();
                    TreePath child = parent.pathByAddingChild(n);
                    ConfigurationDialog.this.configTree.expandPath(child);
                }
            }
        });
        cons.gridx = 1;
        cons.gridy = 0;
        JButton collapseAllButton = new JButton(this.messages.getString("guiCollapseAll"));
        treeButtonPanel.add((Component)collapseAllButton, cons);
        collapseAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeNode root = (TreeNode)ConfigurationDialog.this.configTree.getModel().getRoot();
                TreePath parent = new TreePath(root);
                Enumeration<? extends TreeNode> categ = root.children();
                while (categ.hasMoreElements()) {
                    TreeNode n = categ.nextElement();
                    TreePath child = parent.pathByAddingChild(n);
                    ConfigurationDialog.this.configTree.collapsePath(child);
                }
            }
        });
        return treeButtonPanel;
    }

    @NotNull
    private JPanel getMotherTonguePanel(GridBagConstraints cons) {
        JPanel motherTonguePanel = new JPanel();
        motherTonguePanel.add((Component)new JLabel(this.messages.getString("guiMotherTongue")), cons);
        final JComboBox<String> motherTongueBox = new JComboBox<String>(this.getPossibleMotherTongues());
        if (this.config.getMotherTongue() != null) {
            motherTongueBox.setSelectedItem(this.config.getMotherTongue().getTranslatedName(this.messages));
        }
        motherTongueBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Language motherTongue = motherTongueBox.getSelectedItem() instanceof String ? ConfigurationDialog.this.getLanguageForLocalizedName(motherTongueBox.getSelectedItem().toString()) : (Language)motherTongueBox.getSelectedItem();
                    ConfigurationDialog.this.config.setMotherTongue(motherTongue);
                }
            }
        });
        motherTonguePanel.add(motherTongueBox, cons);
        return motherTonguePanel;
    }

    private JPanel getNgramPanel(GridBagConstraints cons) {
        JPanel panel = new JPanel();
        panel.add((Component)new JLabel(this.messages.getString("guiNgramDir")), cons);
        final File dir = this.config.getNgramDirectory();
        final int maxDirDisplayLength = 45;
        String buttonText = dir != null ? StringUtils.abbreviate((String)dir.getAbsolutePath(), (int)maxDirDisplayLength) : this.messages.getString("guiNgramDirSelect");
        final JButton ngramDirButton = new JButton(buttonText);
        ngramDirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File newDir = Tools.openDirectoryDialog(ConfigurationDialog.this.owner, dir);
                if (newDir != null) {
                    try {
                        if (ConfigurationDialog.this.config.getLanguage() != null) {
                            File checkDir = new File(newDir, ConfigurationDialog.this.config.getLanguage().getShortName());
                            LuceneLanguageModel.validateDirectory((File)checkDir);
                        }
                        ConfigurationDialog.this.config.setNgramDirectory(newDir);
                        ngramDirButton.setText(StringUtils.abbreviate((String)newDir.getAbsolutePath(), (int)maxDirDisplayLength));
                    }
                    catch (Exception ex) {
                        Tools.showErrorMessage(ex);
                    }
                } else {
                    ConfigurationDialog.this.config.setNgramDirectory(null);
                    ngramDirButton.setText(StringUtils.abbreviate((String)ConfigurationDialog.this.messages.getString("guiNgramDirSelect"), (int)maxDirDisplayLength));
                }
            }
        });
        panel.add((Component)ngramDirButton, cons);
        JButton helpButton = new JButton(this.messages.getString("guiNgramHelp"));
        helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(new URL("http://wiki.languagetool.org/finding-errors-using-n-gram-data").toURI());
                    }
                    catch (Exception ex) {
                        Tools.showError(ex);
                    }
                }
            }
        });
        panel.add((Component)helpButton, cons);
        return panel;
    }

    private String[] getPossibleMotherTongues() {
        ArrayList<String> motherTongues = new ArrayList<String>();
        motherTongues.add(NO_MOTHER_TONGUE);
        for (Language lang : Languages.get()) {
            motherTongues.add(lang.getTranslatedName(this.messages));
        }
        return motherTongues.toArray(new String[motherTongues.size()]);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (ACTION_COMMAND_OK.equals(e.getActionCommand())) {
            if (this.original != null) {
                this.original.restoreState(this.config);
            }
            for (JPanel extra : this.extraPanels) {
                if (!(extra instanceof SavablePanel)) continue;
                ((SavablePanel)((Object)extra)).save();
            }
            this.dialog.setVisible(false);
        } else if (ACTION_COMMAND_CANCEL.equals(e.getActionCommand())) {
            this.dialog.setVisible(false);
        }
    }

    @Nullable
    private Language getLanguageForLocalizedName(String languageName) {
        for (Language element : Languages.get()) {
            if (!languageName.equals(element.getTranslatedName(this.messages))) continue;
            return element;
        }
        return null;
    }

    static class CategoryComparator
    implements Comparator<Rule> {
        CategoryComparator() {
        }

        @Override
        public int compare(Rule r1, Rule r2) {
            boolean hasCat;
            boolean bl = hasCat = r1.getCategory() != null && r2.getCategory() != null;
            if (hasCat) {
                int res = r1.getCategory().getName().compareTo(r2.getCategory().getName());
                if (res == 0) {
                    return r1.getDescription().compareToIgnoreCase(r2.getDescription());
                }
                return res;
            }
            return r1.getDescription().compareToIgnoreCase(r2.getDescription());
        }
    }
}

