/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.prg.generator;

import java.util.List;
import java.util.Random;
import org.encog.ml.prg.EncogProgram;
import org.encog.ml.prg.EncogProgramContext;
import org.encog.ml.prg.ProgramNode;
import org.encog.ml.prg.expvalue.ValueType;
import org.encog.ml.prg.generator.AbstractPrgGenerator;
import org.encog.ml.prg.generator.PrgFullGenerator;
import org.encog.ml.prg.generator.PrgGrowGenerator;

public class RampedHalfAndHalf
extends AbstractPrgGenerator {
    private final int minDepth;
    private final PrgFullGenerator fullGenerator;
    private final PrgGrowGenerator growGenerator;

    public RampedHalfAndHalf(EncogProgramContext theContext, int theMinDepth, int theMaxDepth) {
        super(theContext, theMaxDepth);
        this.minDepth = theMinDepth;
        this.fullGenerator = new PrgFullGenerator(theContext, theMaxDepth);
        this.growGenerator = new PrgGrowGenerator(theContext, theMaxDepth);
    }

    @Override
    public ProgramNode createNode(Random rnd, EncogProgram program, int depthRemaining, List<ValueType> types) {
        int actualDepthRemaining = depthRemaining;
        if (rnd.nextBoolean()) {
            return this.fullGenerator.createNode(rnd, program, actualDepthRemaining, types);
        }
        return this.growGenerator.createNode(rnd, program, actualDepthRemaining, types);
    }

    @Override
    public int determineMaxDepth(Random rnd) {
        int range = this.getMaxDepth() - this.minDepth;
        return rnd.nextInt(range) + this.minDepth;
    }

    public int getMinDepth() {
        return this.minDepth;
    }
}

