/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm;

import edu.berkeley.nlp.lm.WordIndexer;
import edu.berkeley.nlp.lm.collections.Indexer;

public class StringWordIndexer
implements WordIndexer<String> {
    private static final long serialVersionUID = 1L;
    private final Indexer<String> sparseIndexer = new Indexer();
    private String startSymbol;
    private String endSymbol;
    private String unkSymbol;
    private int unkIndex = -1;

    @Override
    public int getOrAddIndex(String word) {
        return this.sparseIndexer.getIndex(word);
    }

    @Override
    public String getWord(int index) {
        return this.sparseIndexer.getObject(index);
    }

    @Override
    public int numWords() {
        return this.sparseIndexer.size();
    }

    @Override
    public String getStartSymbol() {
        return this.startSymbol;
    }

    @Override
    public String getEndSymbol() {
        return this.endSymbol;
    }

    @Override
    public String getUnkSymbol() {
        return this.unkSymbol;
    }

    @Override
    public int getOrAddIndexFromString(String word) {
        return this.getOrAddIndex(word);
    }

    @Override
    public void setStartSymbol(String sym) {
        this.startSymbol = sym;
        this.sparseIndexer.add(sym);
    }

    @Override
    public void setEndSymbol(String sym) {
        this.endSymbol = sym;
        this.sparseIndexer.add(sym);
    }

    @Override
    public void setUnkSymbol(String sym) {
        this.unkSymbol = sym;
        this.unkIndex = this.sparseIndexer.getIndex(sym);
    }

    @Override
    public void trimAndLock() {
        this.sparseIndexer.trim();
        this.sparseIndexer.lock();
    }

    @Override
    public int getIndexPossiblyUnk(String word) {
        int id = this.sparseIndexer.indexOf(word);
        return id < 0 ? this.unkIndex : id;
    }
}

