/*
 * Decompiled with CFR 0.152.
 */
package org.sciplore.formatter;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.javabean.JavaBeanConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.sciplore.annotation.SciBeanImplicitValue;
import org.sciplore.formatter.Bean;
import org.sciplore.formatter.SimpleTypeElementBean;

public class BeanJSONConverter
extends JavaBeanConverter {
    private XStream context;

    public BeanJSONConverter(Mapper mapper, XStream xContext) {
        super(mapper);
        this.context = xContext;
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        if (object instanceof Bean) {
            Bean bean = (Bean)object;
            Map<String, Method> methods = this.getGetterMethods(object);
            DecimalFormat escape = new DecimalFormat();
            escape.applyPattern("\\u0000");
            for (String activeElements : bean.getActiveElements()) {
                try {
                    Object value;
                    Method method = methods.get(activeElements.toLowerCase());
                    if (method == null) continue;
                    if (method.getReturnType() == String.class) {
                        value = method.invoke(object, new Object[0]);
                        if (activeElements.equalsIgnoreCase("value") && object instanceof SimpleTypeElementBean) {
                            if (object.getClass().isAnnotationPresent(SciBeanImplicitValue.class) && object.getClass().getAnnotation(SciBeanImplicitValue.class).value().equals(activeElements)) {
                                writer.setValue(this.unicodeEscape(value.toString()));
                                continue;
                            }
                            writer.startNode("text");
                        } else {
                            writer.startNode(activeElements.toLowerCase());
                        }
                        if (value != null) {
                            writer.setValue(this.unicodeEscape(value.toString()));
                        } else {
                            writer.setValue("");
                        }
                        if (activeElements.equalsIgnoreCase("value") && object instanceof SimpleTypeElementBean) {
                            writer.endNode();
                            continue;
                        }
                        writer.endNode();
                        continue;
                    }
                    if (this.canConvert(method.getReturnType())) {
                        value = method.invoke(object, new Object[0]);
                        if (value == null) {
                            writer.startNode(activeElements.toLowerCase());
                            writer.endNode();
                            continue;
                        }
                        writer.startNode(activeElements.toLowerCase());
                        this.marshal(value, writer, context);
                        if (context.get("list") != null) {
                            ObjectOutputStream oos = this.context.createObjectOutputStream(writer, activeElements.toLowerCase());
                            oos.writeObject(context.get("list"));
                            oos.flush();
                            context.put("list", null);
                        }
                        writer.endNode();
                        continue;
                    }
                    if (!this.contains(method.getReturnType().getInterfaces(), "java.util.Collection") || (value = method.invoke(object, new Object[0])) == null) continue;
                    Collection values = (Collection)value;
                    context.put("list", values);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String unicodeEscape(String text) {
        StringBuffer sb = new StringBuffer();
        char[] buffer = text.toCharArray();
        int i = 0;
        while (i < buffer.length) {
            if (buffer[i] < '\uffff' && (buffer[i] < ' ' || buffer[i] > 'z')) {
                String hex = Integer.toHexString(buffer[i]);
                switch (hex.length()) {
                    case 1: {
                        sb.append("\\u000");
                        break;
                    }
                    case 2: {
                        sb.append("\\u00");
                        break;
                    }
                    case 3: {
                        sb.append("\\u0");
                        break;
                    }
                    case 4: {
                        sb.append("\\u");
                        break;
                    }
                    default: {
                        throw new RuntimeException(String.valueOf(hex) + " is tool long to be a Character");
                    }
                }
                sb.append(hex);
            } else {
                sb.append(buffer[i]);
            }
            ++i;
        }
        return sb.toString();
    }

    private Map<String, Method> getGetterMethods(Object object) {
        HashMap<String, Method> result = new HashMap<String, Method>();
        Class<?> clazz = object.getClass();
        while (clazz != null && clazz != Object.class && clazz != Bean.class) {
            Method[] methodArray = clazz.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (m.getName().startsWith("get")) {
                    String name = m.getName().toLowerCase().substring(3);
                    result.put(name, m);
                }
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    private boolean contains(Class<?>[] classes, String s) {
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            if (c.getName().equals(s)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader arg0, UnmarshallingContext arg1) {
        return null;
    }

    @Override
    public boolean canConvert(Class clazz) {
        while (clazz != null && clazz != Object.class) {
            if (clazz == Bean.class) {
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }
}

