/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.sql.importer;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.sf.jabref.sql.DBStrings;
import net.sf.jabref.sql.SQLUtil;
import net.sf.jabref.sql.importer.DBImporter;

public class MySQLImporter
extends DBImporter {
    private static MySQLImporter instance = null;

    private MySQLImporter() {
    }

    public static MySQLImporter getInstance() {
        if (instance == null) {
            instance = new MySQLImporter();
        }
        return instance;
    }

    @Override
    protected ResultSet readColumnNames(Connection conn) throws SQLException {
        Statement statement = (Statement)SQLUtil.processQueryWithResults(conn, "SHOW columns FROM entries;");
        ResultSet rs = statement.getResultSet();
        return rs;
    }

    @Override
    protected Connection connectToDB(DBStrings dbstrings) throws Exception {
        String url = SQLUtil.createJDBCurl(dbstrings, true);
        String drv = "com.mysql.jdbc.Driver";
        Class.forName(drv).newInstance();
        Connection conn = DriverManager.getConnection(url, dbstrings.getUsername(), dbstrings.getPassword());
        return conn;
    }
}

