/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.specialfields;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;
import net.sf.jabref.specialfields.SpecialFieldValue;

public abstract class SpecialField {
    public String TEXT_DONE_PATTERN;
    private List<SpecialFieldValue> values;
    private List<String> keywords;
    private HashMap<String, SpecialFieldValue> map;

    protected void setValues(List<SpecialFieldValue> values) {
        this.values = values;
        this.keywords = new ArrayList<String>();
        this.map = new HashMap();
        for (SpecialFieldValue v : values) {
            if (v.getKeyword() != null) {
                this.keywords.add(v.getKeyword());
            }
            if (v.getFieldValue() == null) continue;
            this.map.put(v.getFieldValue(), v);
        }
    }

    public List<SpecialFieldValue> getValues() {
        return this.values;
    }

    public List<String> getKeyWords() {
        return this.keywords;
    }

    public SpecialFieldValue parse(String s) {
        return this.map.get(s);
    }

    public abstract String getFieldName();

    public abstract ImageIcon getRepresentingIcon();

    public abstract String getMenuString();

    public abstract String getToolTip();

    public boolean isSingleValueField() {
        return false;
    }
}

