/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.label;

import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.label.DefaultLabelRule;

public class ArticleLabelRule
extends DefaultLabelRule {
    @Override
    public String applyRule(BibtexEntry oldEntry) {
        String oldLabel = oldEntry.getField("bibtexkey");
        String newLabel = "";
        String author = "";
        try {
            author = oldEntry.getField("author");
            String[] tokens = author.split("\\band\\b");
            if (tokens.length > 0) {
                if (tokens[0].indexOf(",") > 0) {
                    tokens[0] = AuthorList.fixAuthor_firstNameFirst(tokens[0]);
                }
                String[] firstAuthor = tokens[0].replaceAll("\\s+", " ").split(" ");
                newLabel = newLabel + firstAuthor[firstAuthor.length - 1];
            }
        }
        catch (Throwable t) {
            System.out.println("error getting author: " + t);
        }
        try {
            if (!newLabel.equals("")) {
                if (oldEntry.getField("year") != null) {
                    newLabel = newLabel + String.valueOf(oldEntry.getField("year"));
                }
            } else {
                newLabel = oldLabel;
            }
        }
        catch (Throwable t) {
            System.out.println("error getting year: " + t);
        }
        return newLabel;
    }
}

