/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.groups.ExplicitGroup;
import net.sf.jabref.groups.GroupTreeNode;

public class UndoableChangeAssignment
extends AbstractUndoableEdit {
    private final Set<BibtexEntry> m_previousAssignmentBackup;
    private final Set<BibtexEntry> m_newAssignmentBackup;
    private int[] m_pathToNode = null;
    private GroupTreeNode m_groupsRootHandle = null;

    public UndoableChangeAssignment(Set<BibtexEntry> previousAssignment, Set<BibtexEntry> currentAssignment) {
        this.m_previousAssignmentBackup = new HashSet<BibtexEntry>(previousAssignment);
        this.m_newAssignmentBackup = new HashSet<BibtexEntry>(currentAssignment);
    }

    public UndoableChangeAssignment(Set<BibtexEntry> previousAssignment, Set<BibtexEntry> currentAssignment, GroupTreeNode node) {
        this(previousAssignment, currentAssignment);
        this.setEditedNode(node);
    }

    public void setEditedNode(GroupTreeNode node) {
        this.m_groupsRootHandle = (GroupTreeNode)node.getRoot();
        this.m_pathToNode = node.getIndexedPath();
    }

    @Override
    public String getUndoPresentationName() {
        return Globals.lang("Undo") + ": " + Globals.lang("change assignment of entries");
    }

    @Override
    public String getRedoPresentationName() {
        return Globals.lang("Redo") + ": " + Globals.lang("change assignment of entries");
    }

    @Override
    public void undo() {
        super.undo();
        ExplicitGroup group = (ExplicitGroup)this.m_groupsRootHandle.getChildAt(this.m_pathToNode).getGroup();
        group.clearAssignments();
        Iterator<BibtexEntry> it = this.m_previousAssignmentBackup.iterator();
        while (it.hasNext()) {
            group.addEntry(it.next());
        }
    }

    @Override
    public void redo() {
        super.redo();
        ExplicitGroup group = (ExplicitGroup)this.m_groupsRootHandle.getChildAt(this.m_pathToNode).getGroup();
        group.clearAssignments();
        Iterator<BibtexEntry> it = this.m_newAssignmentBackup.iterator();
        while (it.hasNext()) {
            group.addEntry(it.next());
        }
    }
}

