/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.PrefsTab;
import net.sf.jabref.help.HelpDialog;
import net.sf.jabref.labelPattern.LabelPattern;
import net.sf.jabref.labelPattern.LabelPatternPanel;
import net.sf.jabref.labelPattern.LabelPatternUtil;

public class TabLabelPattern
extends LabelPatternPanel
implements PrefsTab {
    private JabRefPreferences _prefs;
    private JCheckBox dontOverwrite = new JCheckBox(Globals.lang("Do not overwrite existing keys"));
    private JCheckBox warnBeforeOverwriting = new JCheckBox(Globals.lang("Warn before overwriting existing keys"));
    private JCheckBox generateOnSave = new JCheckBox(Globals.lang("Generate keys before saving (for entries without a key)"));
    private JCheckBox autoGenerateOnImport = new JCheckBox(Globals.lang("Generate keys for imported entries"));
    private JRadioButton letterStartA = new JRadioButton(Globals.lang("Ensure unique keys using letters (a, b, ...)"));
    private JRadioButton letterStartB = new JRadioButton(Globals.lang("Ensure unique keys using letters (b, c, ...)"));
    private JRadioButton alwaysAddLetter = new JRadioButton(Globals.lang("Always add letter (a, b, ...) to generated keys"));
    private JTextField KeyPatternRegex = new JTextField(20);
    private JTextField KeyPatternReplacement = new JTextField(20);

    public TabLabelPattern(JabRefPreferences prefs, HelpDialog helpDiag) {
        super(helpDiag);
        this._prefs = prefs;
        this.appendKeyGeneratorSettings();
    }

    @Override
    public void storeSettings() {
        Globals.prefs.put("defaultLabelPattern", this.defaultPat.getText());
        Globals.prefs.putBoolean("warnBeforeOverwritingKey", this.warnBeforeOverwriting.isSelected());
        Globals.prefs.putBoolean("avoidOverwritingKey", this.dontOverwrite.isSelected());
        Globals.prefs.put("KeyPatternRegex", this.KeyPatternRegex.getText());
        Globals.prefs.put("KeyPatternReplacement", this.KeyPatternReplacement.getText());
        Globals.prefs.putBoolean("generateKeysAfterInspection", this.autoGenerateOnImport.isSelected());
        Globals.prefs.putBoolean("generateKeysBeforeSaving", this.generateOnSave.isSelected());
        if (this.alwaysAddLetter.isSelected()) {
            Globals.prefs.putBoolean("keyGenAlwaysAddLetter", true);
        } else if (this.letterStartA.isSelected()) {
            Globals.prefs.putBoolean("keyGenFirstLetterA", true);
            Globals.prefs.putBoolean("keyGenAlwaysAddLetter", false);
        } else {
            Globals.prefs.putBoolean("keyGenFirstLetterA", false);
            Globals.prefs.putBoolean("keyGenAlwaysAddLetter", false);
        }
        LabelPatternUtil.updateDefaultPattern();
        LabelPattern defKeyPattern = this._prefs.getKeyPattern().getParent();
        LabelPattern keypatterns = this.getLabelPattern();
        keypatterns.setParent(defKeyPattern);
        this._prefs.putKeyPattern(keypatterns);
    }

    private void appendKeyGeneratorSettings() {
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.letterStartA);
        bg.add(this.letterStartB);
        bg.add(this.alwaysAddLetter);
        FormLayout layout = new FormLayout("1dlu, 8dlu, left:pref, 8dlu, left:pref", "");
        JPanel pan = new JPanel();
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.appendSeparator(Globals.lang("Key generator settings"));
        builder.nextLine();
        builder.append(pan);
        builder.append(this.autoGenerateOnImport);
        builder.append(this.letterStartA);
        builder.nextLine();
        builder.append(pan);
        builder.append(this.warnBeforeOverwriting);
        builder.append(this.letterStartB);
        builder.nextLine();
        builder.append(pan);
        builder.append(this.dontOverwrite);
        builder.append(this.alwaysAddLetter);
        builder.nextLine();
        builder.append(pan);
        builder.append(this.generateOnSave);
        builder.nextLine();
        builder.append(pan);
        builder.append(Globals.lang("Replace (regular expression)") + ":");
        builder.append(Globals.lang("by") + ":");
        builder.nextLine();
        builder.append(pan);
        builder.append(this.KeyPatternRegex);
        builder.append(this.KeyPatternReplacement);
        builder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.con.gridx = 1;
        this.con.gridy = 3;
        this.con.gridwidth = 0;
        this.con.weightx = 1.0;
        this.con.fill = 1;
        this.gbl.setConstraints(builder.getPanel(), this.con);
        this.add(builder.getPanel());
        this.dontOverwrite.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                TabLabelPattern.this.warnBeforeOverwriting.setEnabled(!TabLabelPattern.this.dontOverwrite.isSelected());
            }
        });
    }

    @Override
    public boolean readyToClose() {
        return true;
    }

    @Override
    public void setValues() {
        super.setValues(this._prefs.getKeyPattern());
        this.defaultPat.setText(Globals.prefs.get("defaultLabelPattern"));
        this.dontOverwrite.setSelected(Globals.prefs.getBoolean("avoidOverwritingKey"));
        this.generateOnSave.setSelected(Globals.prefs.getBoolean("generateKeysBeforeSaving"));
        this.autoGenerateOnImport.setSelected(Globals.prefs.getBoolean("generateKeysAfterInspection"));
        this.warnBeforeOverwriting.setSelected(Globals.prefs.getBoolean("warnBeforeOverwritingKey"));
        boolean alwaysAddLetter = Globals.prefs.getBoolean("keyGenAlwaysAddLetter");
        boolean firstLetterA = Globals.prefs.getBoolean("keyGenFirstLetterA");
        if (alwaysAddLetter) {
            this.alwaysAddLetter.setSelected(true);
        } else if (firstLetterA) {
            this.letterStartA.setSelected(true);
        } else {
            this.letterStartB.setSelected(true);
        }
        this.warnBeforeOverwriting.setEnabled(!this.dontOverwrite.isSelected());
        this.KeyPatternRegex.setText(Globals.prefs.get("KeyPatternRegex"));
        this.KeyPatternReplacement.setText(Globals.prefs.get("KeyPatternReplacement"));
    }

    @Override
    public String getTabName() {
        return Globals.lang("BibTeX key generator");
    }
}

