/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.AdvancedTab;
import net.sf.jabref.AppearancePrefsTab;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.EntryEditorPrefsTab;
import net.sf.jabref.ExternalTab;
import net.sf.jabref.FileTab;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.GeneralTab;
import net.sf.jabref.Globals;
import net.sf.jabref.ImportSettingsTab;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.NameFormatterTab;
import net.sf.jabref.PrefsTab;
import net.sf.jabref.PreviewPrefsTab;
import net.sf.jabref.TabLabelPattern;
import net.sf.jabref.TableColumnsTab;
import net.sf.jabref.TablePrefsTab;
import net.sf.jabref.Util;
import net.sf.jabref.XmpPrefsTab;
import net.sf.jabref.export.ExportFormats;
import net.sf.jabref.groups.GroupsPrefsTab;
import net.sf.jabref.gui.FileDialogs;
import net.sf.jabref.gui.MainTable;

public class PrefsDialog3
extends JDialog {
    JPanel main;
    JabRefFrame frame;

    public PrefsDialog3(JabRefFrame parent) {
        super(parent, Globals.lang("JabRef preferences"), false);
        final JabRefPreferences prefs = JabRefPreferences.getInstance();
        this.frame = parent;
        JButton importPrefs = new JButton(Globals.lang("Import preferences"));
        JButton exportPrefs = new JButton(Globals.lang("Export preferences"));
        this.main = new JPanel();
        JPanel upper = new JPanel();
        JPanel lower = new JPanel();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)upper, "Center");
        this.getContentPane().add((Component)lower, "South");
        final CardLayout cardLayout = new CardLayout();
        this.main.setLayout(cardLayout);
        ArrayList<JPanel> tabs = new ArrayList<JPanel>();
        tabs.add(new GeneralTab(this.frame, prefs));
        tabs.add(new FileTab(this.frame, prefs));
        tabs.add(new EntryEditorPrefsTab(this.frame, prefs));
        tabs.add(new GroupsPrefsTab(prefs));
        tabs.add(new AppearancePrefsTab(prefs));
        tabs.add(new ExternalTab(this.frame, this, prefs, parent.helpDiag));
        tabs.add(new TablePrefsTab(prefs, parent));
        tabs.add(new TableColumnsTab(prefs, parent));
        tabs.add(new TabLabelPattern(prefs, parent.helpDiag));
        tabs.add(new PreviewPrefsTab(prefs));
        tabs.add(new NameFormatterTab(parent.helpDiag));
        tabs.add(new ImportSettingsTab());
        tabs.add(new XmpPrefsTab());
        tabs.add(new AdvancedTab(prefs, parent.helpDiag));
        Iterator it = tabs.iterator();
        String[] names = new String[tabs.size()];
        int i = 0;
        while (it.hasNext()) {
            PrefsTab tab = (PrefsTab)it.next();
            names[i++] = tab.getTabName();
            this.main.add((Component)((Object)tab), tab.getTabName());
        }
        upper.setBorder(BorderFactory.createEtchedBorder());
        final JList<String> chooser = new JList<String>(names);
        chooser.setBorder(BorderFactory.createEtchedBorder());
        chooser.setPrototypeCellValue("This should be wide enough");
        chooser.setSelectedIndex(0);
        chooser.setSelectionMode(0);
        chooser.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                String o = (String)chooser.getSelectedValue();
                cardLayout.show(PrefsDialog3.this.main, o);
            }
        });
        JPanel one = new JPanel();
        JPanel two = new JPanel();
        one.setLayout(new BorderLayout());
        two.setLayout(new BorderLayout());
        one.add(chooser, "Center");
        one.add((Component)importPrefs, "South");
        two.add((Component)one, "Center");
        two.add((Component)exportPrefs, "South");
        upper.setLayout(new BorderLayout());
        upper.add((Component)two, "West");
        upper.add((Component)this.main, "Center");
        JButton ok = new JButton(Globals.lang("Ok"));
        JButton cancel = new JButton(Globals.lang("Cancel"));
        ok.addActionListener(new OkAction());
        CancelAction cancelAction = new CancelAction();
        cancel.addActionListener(cancelAction);
        lower.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        ButtonBarBuilder bb = new ButtonBarBuilder(lower);
        bb.addGlue();
        bb.addButton((JComponent)ok);
        bb.addButton((JComponent)cancel);
        bb.addGlue();
        Util.bindCloseDialogKeyToCancelAction(this.getRootPane(), cancelAction);
        exportPrefs.setToolTipText(Globals.lang("Export preferences to file"));
        importPrefs.setToolTipText(Globals.lang("Import preferences from file"));
        exportPrefs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String filename = FileDialogs.getNewFile(PrefsDialog3.this.frame, new File(System.getProperty("user.home")), ".xml", 1, false);
                if (filename == null) {
                    return;
                }
                File file = new File(filename);
                if (!file.exists() || JOptionPane.showConfirmDialog(PrefsDialog3.this, "'" + file.getName() + "' " + Globals.lang("exists. Overwrite file?"), Globals.lang("Export preferences"), 2) == 0) {
                    try {
                        prefs.exportPreferences(filename);
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(PrefsDialog3.this, Globals.lang("Could not export preferences") + ": " + ex.getMessage(), Globals.lang("Export preferences"), 0);
                    }
                }
            }
        });
        importPrefs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String filename = FileDialogs.getNewFile(PrefsDialog3.this.frame, new File(System.getProperty("user.home")), ".xml", 0, false);
                if (filename == null) {
                    return;
                }
                try {
                    prefs.importPreferences(filename);
                    PrefsDialog3.this.setValues();
                    BibtexEntryType.loadCustomEntryTypes(prefs);
                    ExportFormats.initAllExports();
                    PrefsDialog3.this.frame.removeCachedEntryEditors();
                    Globals.prefs.updateEntryEditorTabList();
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(PrefsDialog3.this, Globals.lang("Could not import preferences") + ": " + ex.getMessage(), Globals.lang("Import preferences"), 0);
                }
            }
        });
        this.setValues();
        this.pack();
    }

    public void setValues() {
        int count = this.main.getComponentCount();
        Component[] comps = this.main.getComponents();
        for (int i = 0; i < count; ++i) {
            ((PrefsTab)((Object)comps[i])).setValues();
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PrefsDialog3.this.setVisible(false);
        }
    }

    class OkAction
    extends AbstractAction {
        public OkAction() {
            super("Ok");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractWorker worker = new AbstractWorker(){
                boolean ready = true;

                @Override
                public void run() {
                    int i;
                    int count = PrefsDialog3.this.main.getComponentCount();
                    Component[] comps = PrefsDialog3.this.main.getComponents();
                    for (i = 0; i < count; ++i) {
                        if (((PrefsTab)((Object)comps[i])).readyToClose()) continue;
                        this.ready = false;
                        return;
                    }
                    for (i = 0; i < count; ++i) {
                        ((PrefsTab)((Object)comps[i])).storeSettings();
                    }
                    Globals.prefs.flush();
                }

                @Override
                public void update() {
                    if (!this.ready) {
                        return;
                    }
                    PrefsDialog3.this.setVisible(false);
                    MainTable.updateRenderers();
                    GUIGlobals.updateEntryEditorColors();
                    PrefsDialog3.this.frame.setupAllTables();
                    PrefsDialog3.this.frame.groupSelector.revalidateGroups();
                    PrefsDialog3.this.frame.output(Globals.lang("Preferences recorded."));
                }
            };
            worker.getWorker().run();
            worker.getCallBack().update();
        }
    }
}

