/*
 * Decompiled with CFR 0.152.
 */
package gnu.dtools.ritopt;

import gnu.dtools.ritopt.Option;
import gnu.dtools.ritopt.OptionProcessingException;
import gnu.dtools.ritopt.OptionRegistrar;
import gnu.dtools.ritopt.OptionRegistrationException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;

public class OptionModule
implements OptionRegistrar {
    private HashMap<String, Option> options = new HashMap();
    private String name;
    private boolean deprecated;
    public static final char DEFAULT_SHORT_OPTION = '\u0000';
    public static final String DEFAULT_LONG_OPTION = null;
    public static final String DEFAULT_DESCRIPTION = "No description given";
    public static final boolean DEFAULT_DEPRECATED = false;
    public static final String DEFAULT_MODULE_NAME = "Special";

    public OptionModule() {
        this(DEFAULT_MODULE_NAME);
    }

    public OptionModule(String name) {
        this.name = name;
        this.deprecated = false;
    }

    @Override
    public void register(String longOption, Option option) {
        this.register(longOption, '\u0000', option);
    }

    @Override
    public void register(char shortOption, Option option) {
        this.register(DEFAULT_LONG_OPTION, shortOption, option);
    }

    @Override
    public void register(String longOption, char shortOption, Option option) {
        this.register(longOption, shortOption, DEFAULT_DESCRIPTION, option);
    }

    @Override
    public void register(String longOption, char shortOption, String description, Option option) {
        this.register(longOption, shortOption, description, option, false);
    }

    @Override
    public void register(String longOption, char shortOption, String description, Option option, boolean deprecated) {
        if (this.optionExists(option)) {
            throw new OptionRegistrationException("Option Already Registered", option);
        }
        option.setLongOption(longOption);
        option.setShortOption(shortOption);
        option.setDeprecated(deprecated);
        option.setDescription(description);
        this.options.put(option.getHashKey(), option);
    }

    public boolean optionExists(Option option) {
        return this.optionExists(option.getShortOption()) || this.optionExists(option.getLongOption());
    }

    public boolean optionExists(char shortOption) {
        for (Option next : this.options.values()) {
            char c = next.getShortOption();
            if (c == '\u0000' || c != shortOption) continue;
            return true;
        }
        return false;
    }

    public boolean optionExists(String longOption) {
        for (Option next : this.options.values()) {
            String s = next.getLongOption();
            if (s == null || !s.equals(longOption)) continue;
            return true;
        }
        return false;
    }

    public Iterator<Option> getOptionIterator() {
        return this.options.values().iterator();
    }

    public Option getOption(char shortOption) {
        Option retval = null;
        for (Option next : this.options.values()) {
            char c = next.getShortOption();
            if (c == '\u0000' || c != shortOption) continue;
            retval = next;
        }
        return retval;
    }

    public Option getOption(String longOption) {
        Option retval = null;
        for (Option next : this.options.values()) {
            String s = next.getLongOption();
            if (s == null || !s.equals(longOption)) continue;
            retval = next;
        }
        return retval;
    }

    public String getHelp() {
        String retval = "";
        for (Option next : this.options.values()) {
            retval = retval + next.getHelp() + "\n";
        }
        return retval;
    }

    public void writeFileToPrintStream(PrintStream ps) {
        ps.println(":" + this.name + ":");
        for (Option next : this.options.values()) {
            ps.println(next.getOptionFileLine());
        }
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public void action(char shortOption, char text) {
        this.action(shortOption, "" + text);
    }

    public void action(String longOption, char text) {
        this.action(longOption, "" + text);
    }

    public void action(char shortOption, String text) {
        Option op = this.getOption(shortOption);
        if (op == null) {
            throw new OptionProcessingException("Option -" + shortOption + " does not" + " exist in module '" + this.name + "'.");
        }
        op.setInvoked(true);
        op.action();
        op.modify(text);
    }

    public void action(String longOption, String text) {
        Option op = this.getOption(longOption);
        if (op == null) {
            throw new OptionProcessingException("Option --" + longOption + " does not" + " exist in module '" + this.name + "'.");
        }
        op.setInvoked(true);
        op.action();
        op.modify(text);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }
}

