/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.net.InetAddress;
import java.util.Enumeration;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.event.LocalCollisionEvent;
import javax.media.rtp.event.RemoteCollisionEvent;
import net.sf.fmj.media.rtp.GenerateSSRCCause;
import net.sf.fmj.media.rtp.OverallStats;
import net.sf.fmj.media.rtp.OverallTransStats;
import net.sf.fmj.media.rtp.PassiveSSRCInfo;
import net.sf.fmj.media.rtp.RTPEventHandler;
import net.sf.fmj.media.rtp.RTPSessionMgr;
import net.sf.fmj.media.rtp.RTPSourceInfoCache;
import net.sf.fmj.media.rtp.RecvSSRCInfo;
import net.sf.fmj.media.rtp.SSRCInfo;
import net.sf.fmj.media.rtp.SendSSRCInfo;
import net.sf.fmj.media.rtp.TrueRandom;
import net.sf.fmj.media.rtp.util.SSRCTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSRCCache {
    public final SSRCTable<SSRCInfo> cache = new SSRCTable();
    RTPSourceInfoCache sourceInfoCache;
    private OverallStats stats;
    private OverallTransStats transstats;
    RTPEventHandler eventhandler;
    int[] clockrate = new int[128];
    static final int DATA = 1;
    static final int CONTROL = 2;
    static final int SRCDATA = 3;
    static final int RTCP_MIN_TIME = 5000;
    static final int BYE_THRESHOLD = 50;
    int sendercount;
    double rtcp_bw_fraction = 0.0;
    double rtcp_sender_bw_fraction = 0.0;
    private int rtcp_min_time = 5000;
    private static final int NOTIFYPERIOD = 500;
    int sessionbandwidth = 0;
    boolean initial = true;
    boolean byestate = false;
    boolean rtcpsent = false;
    private int avgrtcpsize = 128;
    SSRCInfo ourssrc;
    public final RTPSessionMgr sm;
    public boolean audio = true;

    SSRCCache(RTPSessionMgr sm) {
        this.stats = sm.defaultstats;
        this.transstats = sm.transstats;
        this.sourceInfoCache = new RTPSourceInfoCache();
        this.sourceInfoCache.setMainCache(this.sourceInfoCache);
        this.sourceInfoCache.setSSRCCache(this);
        this.sm = sm;
        this.eventhandler = new RTPEventHandler(sm);
        this.setclockrates();
    }

    SSRCCache(RTPSessionMgr sm, RTPSourceInfoCache sic) {
        this.stats = sm.defaultstats;
        this.transstats = sm.transstats;
        this.sourceInfoCache = sic;
        sic.setSSRCCache(this);
        this.sm = sm;
        this.eventhandler = new RTPEventHandler(sm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int aliveCount() {
        int tot = 0;
        SSRCTable<SSRCInfo> sSRCTable = this.cache;
        synchronized (sSRCTable) {
            Enumeration<SSRCInfo> e = this.cache.elements();
            while (e.hasMoreElements()) {
                SSRCInfo s = e.nextElement();
                if (!s.alive) continue;
                ++tot;
            }
        }
        return tot;
    }

    double calcReportInterval(boolean sender, boolean recvfromothers) {
        if (this.audio) {
            this.rtcp_min_time = 5000;
            double rtcp_bw = this.rtcp_bw_fraction;
            if (this.initial) {
                this.rtcp_min_time /= 2;
            }
            int n = this.aliveCount();
            if (this.sendercount > 0 && (double)this.sendercount < (double)n * this.rtcp_sender_bw_fraction) {
                if (sender) {
                    rtcp_bw *= this.rtcp_sender_bw_fraction;
                    n = this.sendercount;
                } else {
                    rtcp_bw *= 1.0 - this.rtcp_sender_bw_fraction;
                    n -= this.sendercount;
                }
            }
            if (recvfromothers && rtcp_bw == 0.0) {
                rtcp_bw = 0.05;
                if (this.sendercount > 0 && (double)this.sendercount < (double)n * 0.25) {
                    if (sender) {
                        rtcp_bw *= 0.25;
                        n = this.sendercount;
                    } else {
                        rtcp_bw *= 0.75;
                        n -= this.sendercount;
                    }
                }
            }
            double time = 0.0;
            if (rtcp_bw != 0.0 && (time = (double)(this.avgrtcpsize * n) / rtcp_bw) < (double)this.rtcp_min_time) {
                time = this.rtcp_min_time;
            }
            if (recvfromothers) {
                return time;
            }
            return time * (Math.random() + 0.5);
        }
        return 1000.0;
    }

    private void changessrc(SSRCInfo info) {
        info.setOurs(true);
        if (this.ourssrc != null) {
            info.sourceInfo = this.sourceInfoCache.get(this.ourssrc.sourceInfo.getCNAME(), info.ours);
            info.sourceInfo.addSSRC(info);
        }
        info.reporter.releasessrc("Local Collision Detected");
        this.ourssrc = info;
        info.reporter.restart = true;
    }

    synchronized void destroy() {
        this.cache.removeAll();
        if (this.eventhandler != null) {
            this.eventhandler.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SSRCInfo get(int ssrc, InetAddress address, int port) {
        SSRCCache sSRCCache = this;
        synchronized (sSRCCache) {
            return this.lookup(ssrc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SSRCInfo get(int ssrc, InetAddress address, int port, int mode) {
        SSRCInfo info;
        boolean localcollision = false;
        SSRCCache sSRCCache = this;
        synchronized (sSRCCache) {
            if (this.ourssrc != null && this.ourssrc.ssrc == ssrc && this.ourssrc.address != null && !this.ourssrc.address.equals(address)) {
                localcollision = true;
                this.localCollision(ssrc);
            }
            if ((info = this.lookup(ssrc)) != null) {
                SSRCInfo sSRCInfo = info;
                synchronized (sSRCInfo) {
                    if (info.address == null || !info.alive) {
                        info.address = address;
                        info.port = port;
                    } else if (!info.address.equals(address)) {
                        if (info.probation > 0) {
                            info.probation = 2;
                            info.address = address;
                            info.port = port;
                        } else {
                            this.stats.update(4, 1);
                            ++this.transstats.remote_coll;
                            RemoteCollisionEvent evt = new RemoteCollisionEvent(this.sm, info.ssrc);
                            this.eventhandler.postEvent(evt);
                            return null;
                        }
                    }
                }
                if (mode == 1) {
                    if (info.ours) {
                        return null;
                    }
                    if (!(info instanceof RecvSSRCInfo)) {
                        info = new RecvSSRCInfo(info);
                        this.cache.put(ssrc, info);
                    }
                } else if (mode == 2 && info.ours) {
                    return null;
                }
            }
            if (info == null) {
                if (mode == 3) {
                    if (this.ourssrc != null && this.ourssrc.ssrc == ssrc) {
                        return this.ourssrc;
                    }
                    info = new SendSSRCInfo(this, ssrc);
                    info.initsource(TrueRandom.nextInt());
                }
                if (mode == 1) {
                    info = new RecvSSRCInfo(this, ssrc);
                }
                if (mode == 2) {
                    info = new PassiveSSRCInfo(this, ssrc);
                }
                if (info == null) {
                    return null;
                }
                info.address = address;
                info.port = port;
                this.cache.put(ssrc, info);
            }
            if (info.address == null && info.port == 0) {
                info.address = address;
                info.port = port;
            }
            if (localcollision) {
                LocalCollisionEvent levt = null;
                levt = info instanceof RecvSSRCInfo ? new LocalCollisionEvent(this.sm, (ReceiveStream)((Object)info), this.ourssrc.ssrc) : new LocalCollisionEvent(this.sm, null, this.ourssrc.ssrc);
                this.eventhandler.postEvent(levt);
            }
        }
        return info;
    }

    SSRCTable<SSRCInfo> getMainCache() {
        return this.cache;
    }

    RTPSourceInfoCache getRTPSICache() {
        return this.sourceInfoCache;
    }

    int getSessionBandwidth() {
        if (this.sessionbandwidth == 0) {
            throw new IllegalArgumentException("Session Bandwidth not set");
        }
        return this.sessionbandwidth;
    }

    private void localCollision(int ssrc) {
        int newSSRC = 0;
        while (this.lookup(newSSRC = (int)this.sm.generateSSRC(GenerateSSRCCause.LOCAL_COLLISION)) != null) {
        }
        PassiveSSRCInfo newinfo = new PassiveSSRCInfo(this.ourssrc);
        newinfo.ssrc = newSSRC;
        this.cache.put(newSSRC, newinfo);
        this.changessrc(newinfo);
        this.ourssrc = newinfo;
        this.stats.update(3, 1);
        ++this.transstats.local_coll;
    }

    SSRCInfo lookup(int ssrc) {
        return this.cache.get(ssrc);
    }

    void remove(int ssrc) {
        SSRCInfo info = this.cache.remove(ssrc);
        if (info != null) {
            info.delete();
        }
    }

    public void reset(int size) {
        this.initial = true;
        this.sendercount = 0;
        this.avgrtcpsize = size;
    }

    void setclockrates() {
        int i;
        for (i = 0; i < 16; ++i) {
            this.clockrate[i] = 8000;
        }
        this.clockrate[6] = 16000;
        this.clockrate[10] = 44100;
        this.clockrate[11] = 44100;
        this.clockrate[14] = 90000;
        this.clockrate[16] = 11025;
        this.clockrate[17] = 22050;
        this.clockrate[18] = 44100;
        for (i = 24; i < 34; ++i) {
            this.clockrate[i] = 90000;
        }
        for (i = 96; i < 128; ++i) {
            Format fmt = this.sm.formatinfo.get(i);
            this.clockrate[i] = fmt != null && fmt instanceof AudioFormat ? (int)((AudioFormat)fmt).getSampleRate() : 90000;
        }
    }

    synchronized void updateavgrtcpsize(int size) {
        this.avgrtcpsize = (int)(0.0625 * (double)size + 0.9375 * (double)this.avgrtcpsize);
    }
}

