/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.impl;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import net.sf.jml.MsnConnection;
import net.sf.jml.MsnFileTransfer;
import net.sf.jml.MsnMessageChain;
import net.sf.jml.impl.AbstractMessenger;
import net.sf.jml.impl.AbstractSwitchboard;
import net.sf.jml.impl.BasicMessenger;
import net.sf.jml.impl.MsnConnectionImpl;
import net.sf.jml.message.MsnMimeMessage;
import net.sf.jml.net.Message;
import net.sf.jml.net.Session;
import net.sf.jml.net.SessionAdapter;
import net.sf.jml.net.SessionListener;
import net.sf.jml.protocol.MsnOutgoingMessage;
import net.sf.jml.protocol.MsnSession;
import net.sf.jml.protocol.outgoing.OutgoingANS;
import net.sf.jml.protocol.outgoing.OutgoingMSG;
import net.sf.jml.protocol.outgoing.OutgoingUSRAuthSB;

public abstract class BasicSwitchboard
extends AbstractSwitchboard {
    private final MsnSession session;
    private final MsnConnectionImpl connection = new MsnConnectionImpl();
    private final boolean createdByOwner;
    private String authStr;
    private int sessionId;
    private final int SESSION_ACTIVITY_TIMEOUT = 300000;
    private long lastActivityUpdate = 0L;
    private boolean closeOnIdle = true;
    public static final String CLOSE_ON_IDLE_PROP = "net.sf.jml.impl.CLOSE_ON_IDLE_PROP";

    public BasicSwitchboard(BasicMessenger messenger, boolean createdByOwner, String ip, int port) {
        super(messenger);
        this.createdByOwner = createdByOwner;
        this.connection.setRemoteIP(ip);
        this.connection.setRemotePort(port);
        this.connection.setConnectionType(messenger.getConnection().getConnectionType());
        this.session = new MsnSession(this, (SocketAddress)new InetSocketAddress(ip, port));
        this.session.addSessionListener(new SBSessionListener());
        String closeOnIdleProp = System.getProperty(CLOSE_ON_IDLE_PROP);
        if (closeOnIdleProp != null && !Boolean.parseBoolean(closeOnIdleProp)) {
            this.closeOnIdle = false;
        }
    }

    public MsnConnection getConnection() {
        return this.connection;
    }

    public synchronized void close() {
        MsnFileTransfer[] trans;
        for (MsnFileTransfer tran : trans = this.getActiveFileTransfers()) {
            tran.cancel();
        }
        this.session.close();
    }

    public MsnMessageChain getIncomingMessageChain() {
        if (this.session == null) {
            return null;
        }
        return this.session.getIncomingMessageChain();
    }

    public MsnMessageChain getOutgoingMessageChain() {
        if (this.session == null) {
            return null;
        }
        return this.session.getOutgoingMessageChain();
    }

    public boolean sendMessage(MsnMimeMessage message, boolean block) {
        OutgoingMSG[] outgoing;
        if (message != null && (outgoing = message.toOutgoingMsg(this.getMessenger().getActualMsnProtocol())) != null) {
            for (OutgoingMSG anOutgoing : outgoing) {
                if (this.send(anOutgoing, block) || !block) continue;
                return false;
            }
            if (block) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(MsnOutgoingMessage message, boolean block) {
        if (this.closeOnIdle) {
            BasicSwitchboard basicSwitchboard = this;
            synchronized (basicSwitchboard) {
                this.lastActivityUpdate = System.currentTimeMillis();
                this.session.setSessionTimeout(300000);
            }
        }
        if (block) {
            return this.session.sendSynchronousMessage(message);
        }
        this.session.sendAsynchronousMessage(message);
        return false;
    }

    public String toString() {
        return "MsnSwitchboard: " + this.getMessenger().getOwner().getEmail();
    }

    public void setAuthStr(String authStr) {
        this.authStr = authStr;
    }

    public void setSessionId(int sessionId) {
        this.sessionId = sessionId;
    }

    public synchronized void start() {
        this.session.start();
    }

    public void addSessionListener(SessionListener listener) {
        this.session.addSessionListener(listener);
    }

    public void removeSessionListener(SessionListener listener) {
        this.session.removeSessionListener(listener);
    }

    private class SBSessionListener
    extends SessionAdapter {
        private SBSessionListener() {
        }

        public void sessionEstablished(Session session) {
            if (BasicSwitchboard.this.createdByOwner) {
                OutgoingUSRAuthSB message = new OutgoingUSRAuthSB(BasicSwitchboard.this.getMessenger().getActualMsnProtocol());
                message.setEmail(BasicSwitchboard.this.getMessenger().getOwner().getEmail());
                message.setAuthStr(BasicSwitchboard.this.authStr);
                BasicSwitchboard.this.send(message, false);
            } else {
                OutgoingANS message = new OutgoingANS(BasicSwitchboard.this.getMessenger().getActualMsnProtocol());
                message.setEmail(BasicSwitchboard.this.getMessenger().getOwner().getEmail());
                message.setAuthStr(BasicSwitchboard.this.authStr);
                message.setSessionId(BasicSwitchboard.this.sessionId);
                BasicSwitchboard.this.send(message, false);
            }
            BasicSwitchboard.this.connection.setInternalIP(BasicSwitchboard.this.session.getLocalAddress());
            BasicSwitchboard.this.connection.setInternalPort(BasicSwitchboard.this.session.getLocalPort());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sessionTimeout(Session session) {
            if (BasicSwitchboard.this.closeOnIdle) {
                SBSessionListener sBSessionListener = this;
                synchronized (sBSessionListener) {
                    if (System.currentTimeMillis() - BasicSwitchboard.this.lastActivityUpdate >= 300000L) {
                        session.close();
                    }
                }
            }
        }

        public void sessionClosed(Session session) {
            ((AbstractMessenger)BasicSwitchboard.this.getMessenger()).fireSwitchboardClosed(BasicSwitchboard.this);
        }

        public void messageReceived(Session session, Message message) throws Exception {
            if (BasicSwitchboard.this.closeOnIdle) {
                BasicSwitchboard.this.closeOnIdle = BasicSwitchboard.this.getAllContacts().length <= 1;
            }
        }

        public void messageSent(Session session, Message message) throws Exception {
            if (BasicSwitchboard.this.closeOnIdle) {
                BasicSwitchboard.this.closeOnIdle = BasicSwitchboard.this.getAllContacts().length <= 1;
            }
        }
    }
}

