/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.widgets.plaf;

import com.explodingpixels.painter.Painter;
import com.explodingpixels.widgets.WindowUtils;
import com.explodingpixels.widgets.plaf.ScrollBarOrientation;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScrollThumbImagePainter
implements Painter<Component> {
    private final ScrollBarOrientation fOrientation;
    private final ImageSet fDisabledImageSet;
    private final ImageSet fInactiveImageSet;
    private final ImageSet fActiveImageSet;

    private ScrollThumbImagePainter(ScrollBarOrientation orientation, Image disabledLowerBound, Image disabledMiddle, Image disabledUpperBound, Image inactiveLowerBound, Image inactiveMiddle, Image inactiveUpperBound, Image activeLowerBound, Image activeMiddle, Image activeUpperBound) {
        this.fOrientation = orientation;
        this.fDisabledImageSet = new ImageSet(disabledLowerBound, disabledMiddle, disabledUpperBound);
        this.fInactiveImageSet = new ImageSet(inactiveLowerBound, inactiveMiddle, inactiveUpperBound);
        this.fActiveImageSet = new ImageSet(activeLowerBound, activeMiddle, activeUpperBound);
    }

    public static ScrollThumbImagePainter createVerticalScrollThumbImagePainter(Image disabledLowerBound, Image disabledMiddle, Image disabledUpperBound, Image inactiveLowerBound, Image inactiveMiddle, Image inactiveUpperBound, Image activeLowerBound, Image activeMiddle, Image activeUpperBound) {
        return new ScrollThumbImagePainter(ScrollBarOrientation.VERTICAL, disabledLowerBound, disabledMiddle, disabledUpperBound, inactiveLowerBound, inactiveMiddle, inactiveUpperBound, activeLowerBound, activeMiddle, activeUpperBound);
    }

    public static ScrollThumbImagePainter createHorizontalScrollThumbImagePainter(Image disabledLowerBound, Image disabledMiddle, Image disabledUpperBound, Image inactiveLowerBound, Image inactiveMiddle, Image inactiveUpperBound, Image activeLowerBound, Image activeMiddle, Image activeUpperBound) {
        return new ScrollThumbImagePainter(ScrollBarOrientation.HORIZONTAL, disabledLowerBound, disabledMiddle, disabledUpperBound, inactiveLowerBound, inactiveMiddle, inactiveUpperBound, activeLowerBound, activeMiddle, activeUpperBound);
    }

    private ImageSet getImageSet(Component objectToPaint) {
        ImageSet retVal = !objectToPaint.isEnabled() ? this.fDisabledImageSet : (WindowUtils.isParentWindowFocused(objectToPaint) ? this.fActiveImageSet : this.fInactiveImageSet);
        return retVal;
    }

    @Override
    public void paint(Graphics2D graphics, Component objectToPaint, int width, int height) {
        ImageSet imageSet = this.getImageSet(objectToPaint);
        Dimension scrollerSize = new Dimension(width, height);
        int scrollerLength = this.fOrientation.getLength(scrollerSize);
        int scrollerThickness = this.fOrientation.getThickness(imageSet.getLowerBoundImageSize());
        int lowerPosition = 0;
        Point lowerPoint = this.fOrientation.createCenteredBounds(objectToPaint, lowerPosition, scrollerThickness, -1).getLocation();
        graphics.drawImage(imageSet.getLowerBoundImage(), lowerPoint.x, lowerPoint.y, null);
        int upperLength = this.fOrientation.getLength(imageSet.getUpperBoundImageSize());
        int middleStartPosition = this.fOrientation.getLength(imageSet.getLowerBoundImageSize());
        int middleEndPosition = scrollerLength - upperLength;
        int middleLength = middleEndPosition - middleStartPosition;
        Rectangle middleBounds = this.fOrientation.createCenteredBounds(objectToPaint, middleStartPosition, scrollerThickness, middleLength);
        Image middleImage = imageSet.getMiddleImage();
        graphics.drawImage(middleImage, middleBounds.x, middleBounds.y, middleBounds.x + middleBounds.width, middleBounds.y + middleBounds.height, 0, 0, middleImage.getWidth(null), middleImage.getHeight(null), null);
        int upperPosition = scrollerLength - upperLength;
        Point upperPoint = this.fOrientation.createCenteredBounds(objectToPaint, upperPosition, scrollerThickness, -1).getLocation();
        graphics.drawImage(imageSet.getUpperBoundImage(), upperPoint.x, upperPoint.y, null);
    }

    private static class ImageSet {
        private final Image fLowerBoundImage;
        private final Image fMiddleImage;
        private final Image fUpperBoundImage;
        private Dimension fLowerBoundImageSize;
        private Dimension fMiddleBoundImageSize;
        private Dimension fUppoerBoundImageSize;

        private ImageSet(Image lowerBoundImage, Image middleImage, Image upperBoundImage) {
            this.fLowerBoundImage = lowerBoundImage;
            this.fMiddleImage = middleImage;
            this.fUpperBoundImage = upperBoundImage;
            this.fLowerBoundImageSize = ImageSet.createImageSize(this.fLowerBoundImage);
            this.fMiddleBoundImageSize = ImageSet.createImageSize(this.fMiddleImage);
            this.fUppoerBoundImageSize = ImageSet.createImageSize(this.fUpperBoundImage);
        }

        public Image getLowerBoundImage() {
            return this.fLowerBoundImage;
        }

        public Image getMiddleImage() {
            return this.fMiddleImage;
        }

        public Image getUpperBoundImage() {
            return this.fUpperBoundImage;
        }

        public Dimension getLowerBoundImageSize() {
            return this.fLowerBoundImageSize;
        }

        public Dimension getMiddleBoundImageSize() {
            return this.fMiddleBoundImageSize;
        }

        public Dimension getUpperBoundImageSize() {
            return this.fUppoerBoundImageSize;
        }

        private static Dimension createImageSize(Image image) {
            return new Dimension(image.getWidth(null), image.getHeight(null));
        }
    }
}

