/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.flapcmd.SnacPacket;

public abstract class AbstractIcbm
extends SnacCommand {
    public static final int CHANNEL_IM = 1;
    public static final int CHANNEL_RV = 2;
    public static final int CHANNEL_CHAT = 3;
    public static final int CHANNEL_OLDTYPE = 4;
    private final long messageId;
    private final int channel;
    private final ByteBlock channelData;

    public static int getIcbmChannel(SnacPacket packet) {
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ByteBlock block = packet.getData();
        return BinaryTools.getUShort((ByteBlock)block, (int)8);
    }

    protected AbstractIcbm(int family, int command, SnacPacket packet) {
        super(family, command);
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ByteBlock snacData = packet.getData();
        this.messageId = BinaryTools.getLong((ByteBlock)snacData, (int)0);
        this.channel = BinaryTools.getUShort((ByteBlock)snacData, (int)8);
        this.channelData = snacData.subBlock(10);
    }

    protected AbstractIcbm(int family, int command, long messageId, int channel) {
        super(family, command);
        DefensiveTools.checkRange((int)channel, (String)"channel", (int)0);
        this.messageId = messageId;
        this.channel = channel;
        this.channelData = null;
    }

    public final long getIcbmMessageId() {
        return this.messageId;
    }

    public final int getChannel() {
        return this.channel;
    }

    protected final ByteBlock getChannelData() {
        return this.channelData;
    }

    public void writeData(OutputStream out) throws IOException {
        BinaryTools.writeLong((OutputStream)out, (long)this.messageId);
        BinaryTools.writeUShort((OutputStream)out, (int)this.channel);
        this.writeChannelData(out);
    }

    protected abstract void writeChannelData(OutputStream var1) throws IOException;

    public String toString() {
        return MiscTools.getClassName(this) + ": channel=" + this.channel + ", messageId=" + this.getIcbmMessageId();
    }
}

