/*
 * Decompiled with CFR 0.152.
 */
package ymsg.network;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import ymsg.network.Util;

class DebugInputStream
extends FilterInputStream {
    ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);

    public DebugInputStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        this.baos.write(n);
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n = super.read(byArray);
        if (n > 0) {
            this.baos.write(byArray, 0, n);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 > 0) {
            this.baos.write(byArray, n, n3);
        }
        return n3;
    }

    public void debugDump() {
        Util.dump(this.baos.toByteArray(), "\n--INPUT--");
        this.baos.reset();
    }

    public void debugReset() {
        this.baos.reset();
    }
}

