/*
 * Decompiled with CFR 0.152.
 */
package mork;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mork.Alias;
import mork.Aliases;
import mork.Dict;
import mork.ScopeTypes;
import mork.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Row {
    private String rowId;
    private String scopeName;
    private Aliases aliases;

    public Row(String content, List<Dict> dicts) {
        content = StringUtils.removeCommentLines(content);
        content = StringUtils.removeNewlines(content);
        Pattern pattern = Pattern.compile("\\s*\\[\\s*(\\w*):(\\^?\\w*)\\s*(.*)\\s*\\]");
        Matcher matcher = pattern.matcher(content);
        if (!matcher.matches()) {
            Pattern pattern3 = Pattern.compile("\\[\\-([0-9A-F]*)\\]");
            Matcher matcher3 = pattern3.matcher(content);
            if (matcher3.matches()) {
                this.rowId = matcher3.group(1);
                this.aliases = new Aliases();
            } else {
                Pattern pattern2 = Pattern.compile("\\s*\\[\\s*(-?\\w*)\\s*(.*)\\s*\\]");
                Matcher matcher2 = pattern2.matcher(content);
                if (!matcher2.matches()) {
                    throw new RuntimeException("Row does not match RegEx: " + content);
                }
                this.rowId = matcher2.group(1);
                String cells = matcher2.group(2);
                this.aliases = new Aliases(cells, dicts);
            }
        } else {
            this.rowId = matcher.group(1);
            String scopeValue = matcher.group(2);
            this.scopeName = scopeValue.startsWith("^") ? Dict.dereference(scopeValue, dicts, ScopeTypes.COLUMN_SCOPE) : scopeValue;
            String cells = matcher.group(3);
            this.aliases = new Aliases(cells, dicts);
        }
    }

    public Row(String content) {
        this(content, Dict.EMPTY_LIST);
    }

    public String getRowId() {
        return this.rowId;
    }

    public String getScopeName() {
        return this.scopeName;
    }

    public String getValue(String id) {
        return this.aliases.getValue(id);
    }

    public Map<String, Alias> getAliases() {
        return this.aliases.getAliases();
    }

    public Set<String> getKeySet() {
        return this.aliases.getKeySet();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[\r\n");
        for (Map.Entry<String, Alias> e : this.aliases.getAliases().entrySet()) {
            if ("".equals(e.getValue().getValue())) continue;
            sb.append("\t{");
            sb.append(e.getKey());
            sb.append('=');
            sb.append(e.getValue().getValue());
            sb.append("},\r\n");
        }
        sb.append("]\r\n");
        return sb.toString();
    }
}

