/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.mgmt.transport.grizzly.grizzly1_9;

import com.sun.enterprise.mgmt.transport.ArrayUtils;
import com.sun.enterprise.mgmt.transport.buffers.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Arrays;

public final class ByteBuffersBuffer
implements Buffer {
    private ByteOrder byteOrder = ByteOrder.nativeOrder();
    private int position;
    private int limit;
    private int capacity;
    private int[] bufferBounds;
    private ByteBuffer[] buffers;
    private int buffersSize;
    private int lastSegmentIndex;
    private int lowerBound;
    private int upperBound;
    private int activeBufferLowerBound;
    private ByteBuffer activeBuffer;

    public ByteBuffersBuffer() {
        this((ByteBuffer[])null);
    }

    public ByteBuffersBuffer(ByteBuffer[] buffers) {
        this.set(buffers);
    }

    public ByteBuffersBuffer(ByteBuffersBuffer that) {
        this.copy(that);
    }

    private void set(ByteBuffer[] buffers) {
        if (buffers != null || this.buffers == null) {
            this.initBuffers(buffers, this.buffersSize);
            this.calcCapacity();
            this.limit = this.capacity;
        }
    }

    private void initBuffers(ByteBuffer[] buffers, int bufferSize) {
        this.buffers = buffers != null ? buffers : new ByteBuffer[4];
        this.buffersSize = bufferSize;
        this.bufferBounds = new int[this.buffers.length];
    }

    private ByteBuffersBuffer copy(ByteBuffersBuffer that) {
        this.initBuffers(Arrays.copyOf(that.buffers, that.buffers.length), that.buffersSize);
        System.arraycopy(that.bufferBounds, 0, this.bufferBounds, 0, that.buffersSize);
        this.position = that.position;
        this.limit = that.limit;
        this.capacity = that.capacity;
        return this;
    }

    @Override
    public Buffer duplicate() {
        return new ByteBuffersBuffer(this);
    }

    @Override
    public void dispose() {
        this.removeBuffers();
    }

    public ByteBuffersBuffer append(ByteBuffer buffer) {
        this.ensureBuffersCapacity(1);
        this.capacity += buffer.remaining();
        this.bufferBounds[this.buffersSize] = this.capacity;
        this.buffers[this.buffersSize++] = buffer;
        this.limit = this.capacity;
        return this;
    }

    public ByteBuffersBuffer prepend(ByteBuffer buffer) {
        this.ensureBuffersCapacity(1);
        System.arraycopy(this.buffers, 0, this.buffers, 1, this.buffersSize);
        this.buffers[0] = buffer;
        ++this.buffersSize;
        this.calcCapacity();
        this.limit = this.capacity;
        this.resetLastLocation();
        return this;
    }

    private void ensureBuffersCapacity(int newElementsNum) {
        int newSize = this.buffersSize + newElementsNum;
        if (newSize > this.buffers.length) {
            int newCapacity = Math.max(newSize, this.buffers.length * 3 / 2 + 1);
            this.buffers = Arrays.copyOf(this.buffers, newCapacity);
            this.bufferBounds = Arrays.copyOf(this.bufferBounds, newCapacity);
        }
    }

    public ByteBuffer[] underlying() {
        return this.buffers;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public ByteBuffersBuffer position(int newPosition) {
        if (newPosition > this.limit) {
            throw new IllegalArgumentException("Position exceeds a limit: " + newPosition + ">" + this.limit);
        }
        this.position = newPosition;
        return this;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public ByteBuffersBuffer limit(int newLimit) {
        this.limit = newLimit;
        if (this.position > this.limit) {
            this.position = this.limit;
        }
        return this;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public ByteBuffersBuffer mark() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ByteBuffersBuffer reset() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ByteBuffersBuffer clear() {
        this.calcCapacity();
        this.setPosLim(0, this.capacity);
        return this;
    }

    @Override
    public ByteBuffersBuffer flip() {
        this.setPosLim(0, this.position);
        return this;
    }

    @Override
    public ByteBuffersBuffer rewind() {
        this.setPosLim(0, this.limit);
        return this;
    }

    @Override
    public int remaining() {
        return this.limit - this.position;
    }

    @Override
    public boolean hasRemaining() {
        return this.limit > this.position;
    }

    @Override
    public void shrink() {
        int i;
        if (this.position == this.limit) {
            if (this.buffersSize > 0) {
                ByteBuffer releasedBuffer = this.buffers[0];
                releasedBuffer.clear();
            } else {
                Object releasedBuffer = null;
            }
            this.removeBuffers();
            return;
        }
        this.checkIndex(this.position);
        int posBufferIndex = this.lastSegmentIndex;
        this.checkIndex(this.limit - 1);
        int limitBufferIndex = this.lastSegmentIndex;
        int rightTrim = this.buffersSize - limitBufferIndex - 1;
        int shift = 0;
        for (i = 0; i < posBufferIndex; ++i) {
            ByteBuffer buffer = this.buffers[i];
            shift += buffer.remaining();
        }
        this.setPosLim(this.position - shift, this.limit - shift);
        for (i = 0; i < rightTrim; ++i) {
            int idx = this.buffersSize - i - 1;
            this.buffers[idx] = null;
        }
        this.buffersSize -= posBufferIndex + rightTrim;
        if (posBufferIndex > 0) {
            System.arraycopy(this.buffers, posBufferIndex, this.buffers, 0, this.buffersSize);
            Arrays.fill(this.buffers, this.buffersSize, this.buffersSize + posBufferIndex, null);
        }
        this.calcCapacity();
        this.resetLastLocation();
    }

    @Override
    public byte get() {
        return this.get(this.position++);
    }

    @Override
    public ByteBuffersBuffer put(byte b) {
        return this.put(this.position++, b);
    }

    @Override
    public byte get(int index) {
        this.checkIndex(index);
        return this.activeBuffer.get(this.toActiveBufferPos(index));
    }

    @Override
    public ByteBuffersBuffer put(int index, byte b) {
        this.checkIndex(index);
        this.activeBuffer.put(this.toActiveBufferPos(index), b);
        return this;
    }

    private void checkIndex(int index) {
        if (index >= this.lowerBound & index < this.upperBound) {
            return;
        }
        this.recalcIndex(index);
    }

    private void recalcIndex(int index) {
        int idx = ArrayUtils.binarySearch(this.bufferBounds, 0, this.buffersSize - 1, index + 1);
        this.activeBuffer = this.buffers[idx];
        this.upperBound = this.bufferBounds[idx];
        this.lowerBound = this.upperBound - this.activeBuffer.remaining();
        this.lastSegmentIndex = idx;
        this.activeBufferLowerBound = this.lowerBound - this.activeBuffer.position();
    }

    private int toActiveBufferPos(int index) {
        return index - this.activeBufferLowerBound;
    }

    @Override
    public ByteBuffersBuffer get(byte[] dst) {
        return this.get(dst, 0, dst.length);
    }

    @Override
    public ByteBuffersBuffer get(byte[] dst, int offset, int length) {
        if (length == 0) {
            return this;
        }
        if (this.remaining() < length) {
            throw new BufferUnderflowException();
        }
        this.checkIndex(this.position);
        int bufferIdx = this.lastSegmentIndex;
        ByteBuffer buffer = this.activeBuffer;
        int bufferPosition = this.toActiveBufferPos(this.position);
        while (true) {
            int oldPos = buffer.position();
            buffer.position(bufferPosition);
            int bytesToCopy = Math.min(buffer.remaining(), length);
            buffer.get(dst, offset, bytesToCopy);
            buffer.position(oldPos);
            offset += bytesToCopy;
            this.position += bytesToCopy;
            if ((length -= bytesToCopy) == 0) break;
            buffer = this.buffers[++bufferIdx];
            bufferPosition = buffer.position();
        }
        return this;
    }

    @Override
    public ByteBuffersBuffer put(byte[] src) {
        return this.put(src, 0, src.length);
    }

    @Override
    public ByteBuffersBuffer put(byte[] src, int offset, int length) {
        if (this.remaining() < length) {
            throw new BufferOverflowException();
        }
        this.checkIndex(this.position);
        int bufferIdx = this.lastSegmentIndex;
        ByteBuffer buffer = this.activeBuffer;
        int bufferPosition = this.toActiveBufferPos(this.position);
        while (true) {
            int oldPos = buffer.position();
            buffer.position(bufferPosition);
            int bytesToCopy = Math.min(buffer.remaining(), length);
            buffer.put(src, offset, bytesToCopy);
            buffer.position(oldPos);
            bufferPosition += bytesToCopy - 1;
            offset += bytesToCopy;
            this.position += bytesToCopy;
            if ((length -= bytesToCopy) == 0) break;
            buffer = this.buffers[++bufferIdx];
            bufferPosition = buffer.position();
        }
        return this;
    }

    @Override
    public char getChar() {
        char value = this.getChar(this.position);
        this.position += 2;
        return value;
    }

    @Override
    public ByteBuffersBuffer putChar(char value) {
        this.putChar(this.position, value);
        this.position += 2;
        return this;
    }

    @Override
    public char getChar(int index) {
        this.checkIndex(index);
        if (this.upperBound - index >= 2) {
            return this.activeBuffer.getChar(this.toActiveBufferPos(index));
        }
        int ch1 = this.activeBuffer.get(this.toActiveBufferPos(index)) & 0xFF;
        this.checkIndex(++index);
        int ch2 = this.activeBuffer.get(this.toActiveBufferPos(index)) & 0xFF;
        return (char)((ch1 << 8) + ch2);
    }

    @Override
    public ByteBuffersBuffer putChar(int index, char value) {
        this.checkIndex(index);
        if (this.upperBound - index >= 2) {
            this.activeBuffer.putChar(this.toActiveBufferPos(index), value);
        } else {
            this.activeBuffer.put(this.toActiveBufferPos(index), (byte)(value >>> 8));
            this.checkIndex(++index);
            this.activeBuffer.put(this.toActiveBufferPos(index), (byte)(value & 0xFF));
        }
        return this;
    }

    @Override
    public short getShort() {
        short value = this.getShort(this.position);
        this.position += 2;
        return value;
    }

    @Override
    public ByteBuffersBuffer putShort(short value) {
        this.putShort(this.position, value);
        this.position += 2;
        return this;
    }

    @Override
    public short getShort(int index) {
        this.checkIndex(index);
        if (this.upperBound - index >= 2) {
            return this.activeBuffer.getShort(this.toActiveBufferPos(index));
        }
        int ch1 = this.activeBuffer.get(this.toActiveBufferPos(index)) & 0xFF;
        this.checkIndex(++index);
        int ch2 = this.activeBuffer.get(this.toActiveBufferPos(index)) & 0xFF;
        return (short)((ch1 << 8) + ch2);
    }

    @Override
    public ByteBuffersBuffer putShort(int index, short value) {
        this.checkIndex(index);
        if (this.upperBound - index >= 2) {
            this.activeBuffer.putShort(this.toActiveBufferPos(index), value);
        } else {
            this.activeBuffer.put(this.toActiveBufferPos(index), (byte)(value >>> 8));
            this.checkIndex(++index);
            this.activeBuffer.put(this.toActiveBufferPos(index), (byte)(value & 0xFF));
        }
        return this;
    }

    @Override
    public int getInt() {
        int value = this.getInt(this.position);
        this.position += 4;
        return value;
    }

    @Override
    public ByteBuffersBuffer putInt(int value) {
        this.putInt(this.position, value);
        this.position += 4;
        return this;
    }

    @Override
    public int getInt(int index) {
        this.checkIndex(index);
        if (this.upperBound - index >= 4) {
            return this.activeBuffer.getInt(this.toActiveBufferPos(index));
        }
        int ch1 = this.activeBuffer.get(this.toActiveBufferPos(index)) & 0xFF;
        this.checkIndex(++index);
        int ch2 = this.activeBuffer.get(this.toActiveBufferPos(index)) & 0xFF;
        this.checkIndex(++index);
        int ch3 = this.activeBuffer.get(this.toActiveBufferPos(index)) & 0xFF;
        this.checkIndex(++index);
        int ch4 = this.activeBuffer.get(this.toActiveBufferPos(index)) & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    @Override
    public ByteBuffersBuffer putInt(int index, int value) {
        this.checkIndex(index);
        if (this.upperBound - index >= 4) {
            this.activeBuffer.putInt(this.toActiveBufferPos(index), value);
        } else {
            this.activeBuffer.put(this.toActiveBufferPos(index), (byte)(value >>> 24 & 0xFF));
            this.checkIndex(++index);
            this.activeBuffer.put(this.toActiveBufferPos(index), (byte)(value >>> 16 & 0xFF));
            this.checkIndex(++index);
            this.activeBuffer.put(this.toActiveBufferPos(index), (byte)(value >>> 8 & 0xFF));
            this.checkIndex(++index);
            this.activeBuffer.put(this.toActiveBufferPos(index), (byte)(value & 0xFF));
        }
        return this;
    }

    @Override
    public long getLong() {
        long value = this.getLong(this.position);
        this.position += 8;
        return value;
    }

    @Override
    public ByteBuffersBuffer putLong(long value) {
        this.putLong(this.position, value);
        this.position += 8;
        return this;
    }

    @Override
    public long getLong(int index) {
        this.checkIndex(index);
        if (this.upperBound - index >= 8) {
            return this.activeBuffer.getLong(this.toActiveBufferPos(index));
        }
        int ch1 = this.activeBuffer.get(this.toActiveBufferPos(index)) & 0xFF;
        this.checkIndex(++index);
        int ch2 = this.activeBuffer.get(this.toActiveBufferPos(index)) & 0xFF;
        this.checkIndex(++index);
        int ch3 = this.activeBuffer.get(this.toActiveBufferPos(index)) & 0xFF;
        this.checkIndex(++index);
        int ch4 = this.activeBuffer.get(this.toActiveBufferPos(index)) & 0xFF;
        this.checkIndex(++index);
        int ch5 = this.activeBuffer.get(this.toActiveBufferPos(index)) & 0xFF;
        this.checkIndex(++index);
        int ch6 = this.activeBuffer.get(this.toActiveBufferPos(index)) & 0xFF;
        this.checkIndex(++index);
        int ch7 = this.activeBuffer.get(this.toActiveBufferPos(index)) & 0xFF;
        this.checkIndex(++index);
        int ch8 = this.activeBuffer.get(this.toActiveBufferPos(index)) & 0xFF;
        return ((long)ch1 << 56) + ((long)ch2 << 48) + ((long)ch3 << 40) + ((long)ch4 << 32) + ((long)ch5 << 24) + (long)(ch6 << 16) + (long)(ch7 << 8) + (long)ch8;
    }

    @Override
    public ByteBuffersBuffer putLong(int index, long value) {
        this.checkIndex(index);
        if (this.upperBound - index >= 8) {
            this.activeBuffer.putLong(this.toActiveBufferPos(index), value);
        } else {
            this.activeBuffer.put(this.toActiveBufferPos(index), (byte)(value >>> 56 & 0xFFL));
            this.checkIndex(++index);
            this.activeBuffer.put(this.toActiveBufferPos(index), (byte)(value >>> 48 & 0xFFL));
            this.checkIndex(++index);
            this.activeBuffer.put(this.toActiveBufferPos(index), (byte)(value >>> 40 & 0xFFL));
            this.checkIndex(++index);
            this.activeBuffer.put(this.toActiveBufferPos(index), (byte)(value >>> 32 & 0xFFL));
            this.checkIndex(++index);
            this.activeBuffer.put(this.toActiveBufferPos(index), (byte)(value >>> 24 & 0xFFL));
            this.checkIndex(++index);
            this.activeBuffer.put(this.toActiveBufferPos(index), (byte)(value >>> 16 & 0xFFL));
            this.checkIndex(++index);
            this.activeBuffer.put(this.toActiveBufferPos(index), (byte)(value >>> 8 & 0xFFL));
            this.checkIndex(++index);
            this.activeBuffer.put(this.toActiveBufferPos(index), (byte)(value & 0xFFL));
        }
        return this;
    }

    @Override
    public float getFloat() {
        return Float.intBitsToFloat(this.getInt());
    }

    @Override
    public ByteBuffersBuffer putFloat(float value) {
        return this.putInt(Float.floatToIntBits(value));
    }

    @Override
    public float getFloat(int index) {
        return Float.intBitsToFloat(this.getInt(index));
    }

    @Override
    public ByteBuffersBuffer putFloat(int index, float value) {
        return this.putInt(index, Float.floatToIntBits(value));
    }

    @Override
    public double getDouble() {
        return Double.longBitsToDouble(this.getLong());
    }

    @Override
    public ByteBuffersBuffer putDouble(double value) {
        return this.putLong(Double.doubleToLongBits(value));
    }

    @Override
    public double getDouble(int index) {
        return Double.longBitsToDouble(this.getLong(index));
    }

    @Override
    public ByteBuffersBuffer putDouble(int index, double value) {
        return this.putLong(index, Double.doubleToLongBits(value));
    }

    @Override
    public int compareTo(Buffer that) {
        int n = this.position() + Math.min(this.remaining(), that.remaining());
        int i = this.position();
        int j = that.position();
        while (i < n) {
            byte v2;
            byte v1 = this.get(i);
            if (v1 != (v2 = that.get(j))) {
                if (v1 < v2) {
                    return -1;
                }
                return 1;
            }
            ++i;
            ++j;
        }
        return this.remaining() - that.remaining();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BuffersBuffer (" + System.identityHashCode(this) + ") [");
        sb.append("pos=").append(this.position);
        sb.append(" lim=").append(this.limit);
        sb.append(" cap=").append(this.capacity);
        sb.append(" bufferSize=").append(this.buffersSize);
        sb.append(" buffers=").append(Arrays.toString(this.buffers));
        sb.append(']');
        return sb.toString();
    }

    @Override
    public String toStringContent() {
        return this.toStringContent(null, this.position, this.limit);
    }

    @Override
    public String toStringContent(Charset charset) {
        return this.toStringContent(charset, this.position, this.limit);
    }

    @Override
    public String toStringContent(Charset charset, int position, int limit) {
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        byte[] tmpBuffer = new byte[limit - position];
        int oldPosition = this.position;
        int oldLimit = this.limit;
        this.setPosLim(position, limit);
        this.get(tmpBuffer);
        this.setPosLim(oldPosition, oldLimit);
        return new String(tmpBuffer, charset);
    }

    private void removeBuffers() {
        this.position = 0;
        this.limit = 0;
        this.capacity = 0;
        Arrays.fill(this.buffers, 0, this.buffersSize, null);
        this.buffersSize = 0;
        this.resetLastLocation();
    }

    private void setPosLim(int position, int limit) {
        if (position > limit) {
            throw new IllegalArgumentException("Position exceeds a limit: " + position + ">" + limit);
        }
        this.position = position;
        this.limit = limit;
    }

    public void calcCapacity() {
        int currentCapacity = 0;
        for (int i = 0; i < this.buffersSize; ++i) {
            this.bufferBounds[i] = currentCapacity += this.buffers[i].remaining();
        }
        this.capacity = currentCapacity;
    }

    private void resetLastLocation() {
        this.lowerBound = 0;
        this.upperBound = 0;
        this.activeBuffer = null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Buffer) {
            Buffer that = (Buffer)obj;
            if (this.remaining() != that.remaining()) {
                return false;
            }
            int p = this.position();
            int i = this.limit() - 1;
            int j = that.limit() - 1;
            while (i >= p) {
                byte v2;
                byte v1 = this.get(i);
                if (v1 != (v2 = that.get(j))) {
                    return false;
                }
                --i;
                --j;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        int p = this.position();
        for (int i = this.limit() - 1; i >= p; --i) {
            h = 31 * h + this.get(i);
        }
        return h;
    }
}

