/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beans;

import java.beans.PropertyChangeEvent;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.netbeans.modules.schema2beans.BaseAttribute;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.BeanProp;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.DDFactory;
import org.netbeans.modules.schema2beans.DDLogFlags;
import org.netbeans.modules.schema2beans.JavaBeansUtil;
import org.netbeans.modules.schema2beans.NodeFactory;
import org.netbeans.modules.schema2beans.QName;
import org.netbeans.modules.schema2beans.Schema2BeansRuntimeException;
import org.netbeans.modules.schema2beans.TraceLogger;
import org.netbeans.modules.schema2beans.Wrapper;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMBinding {
    int id = DDFactory.getUniqueId();
    Node node;
    int pos;
    int posDOM;
    private static final Class charArrayClass = Array.newInstance(Character.TYPE, 0).getClass();
    private BeanProperty prop;

    public DOMBinding() {
    }

    public DOMBinding(Node node) {
        this();
        this.node = node;
    }

    void setNode(Node node) {
        this.node = node;
    }

    void moveBefore(BeanProp beanProp, Node node) {
        Node node2 = beanProp.getParentNode();
        node2.removeChild(this.node);
        node2.insertBefore(this.node, node);
    }

    public int getId() {
        return this.id;
    }

    String idToString() {
        return Integer.toHexString(this.id);
    }

    Node getNode() {
        return this.node;
    }

    void register(BeanProp beanProp, Object object) {
        BeanProperty beanProperty = new BeanProperty(beanProp);
        if (Common.isBean(beanProp.type)) {
            ((BaseBean)object).setDomBinding(this);
        }
        this.prop = beanProperty;
        if (DDLogFlags.debug) {
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 13, "property " + beanProp.getDtdName() + " bound to B(" + this.hashCode() + ")");
        }
        if (this.node != null) {
            NamedNodeMap namedNodeMap = this.node.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node = namedNodeMap.item(i);
                beanProp.createTransientAttribute(node.getNodeName());
            }
        }
    }

    private BeanProperty getBeanProperty(BeanProp beanProp) {
        if (this.prop != null && this.prop.beanProp == beanProp) {
            return this.prop;
        }
        return null;
    }

    BeanProp getBeanProp(BaseBean baseBean) {
        if (this.prop != null && this.prop.value == baseBean) {
            return this.prop.beanProp;
        }
        return null;
    }

    void setLastKnownIndex(BeanProp beanProp, int n) {
        BeanProperty beanProperty = this.getBeanProperty(beanProp);
        if (beanProperty != null) {
            beanProperty.lastIndex = n;
        }
    }

    int getLastKnownIndex(BeanProp beanProp) {
        BeanProperty beanProperty = this.getBeanProperty(beanProp);
        if (beanProperty != null) {
            return beanProperty.lastIndex;
        }
        return -1;
    }

    Object getBean(BeanProp beanProp) {
        BeanProperty beanProperty = this.getBeanProperty(beanProp);
        if (beanProperty != null) {
            return beanProperty.value;
        }
        return null;
    }

    String getAttributeValue(BeanProp beanProp, String string) {
        CacheAttr cacheAttr;
        if (this.node != null) {
            Attr attr = ((Element)this.node).getAttributeNode(string);
            if (attr != null) {
                return attr.getValue();
            }
            return null;
        }
        BeanProperty beanProperty = this.getBeanProperty(beanProp);
        if (beanProperty != null && beanProperty.attributes != null && (cacheAttr = this.findCacheAttr(beanProperty, string)) != null) {
            return cacheAttr.value;
        }
        return null;
    }

    private CacheAttr findCacheAttr(BeanProperty beanProperty, String string) {
        for (int i = 0; i < beanProperty.attributes.size(); ++i) {
            CacheAttr cacheAttr = (CacheAttr)beanProperty.attributes.get(i);
            if (!cacheAttr.name.equals(string)) continue;
            return cacheAttr;
        }
        return null;
    }

    void setAttributeValue(BeanProp beanProp, String string, String string2) {
        if (this.node != null) {
            if (string2 != null) {
                ((Element)this.node).setAttribute(string, string2);
            } else {
                String string3 = ((Element)this.node).getAttribute(string);
                if (string3 != null) {
                    try {
                        ((Element)this.node).removeAttribute(string);
                    }
                    catch (DOMException dOMException) {}
                }
            }
        } else {
            CacheAttr cacheAttr;
            BeanProperty beanProperty = this.getBeanProperty(beanProp);
            if (beanProperty.attributes == null) {
                beanProperty.attributes = new ArrayList();
            }
            if ((cacheAttr = this.findCacheAttr(beanProperty, string)) == null) {
                cacheAttr = new CacheAttr(string, string2);
                beanProperty.attributes.add(cacheAttr);
            } else {
                cacheAttr.value = string2;
            }
        }
    }

    void setDefaultAttributeValues(BeanProp beanProp) {
        BeanProperty beanProperty = this.getBeanProperty(beanProp);
        if (beanProperty != null) {
            BaseAttribute[] baseAttributeArray = beanProp.getAttributes();
            for (int i = 0; i < baseAttributeArray.length; ++i) {
                String string = baseAttributeArray[i].getDefaultValue();
                if (string == null) continue;
                this.setAttributeValue(beanProp, baseAttributeArray[i].getDtdName(), string);
            }
        }
    }

    public String getDomValue(Node node) {
        StringBuffer stringBuffer = new StringBuffer();
        this.nodeToString(stringBuffer, node, true);
        return stringBuffer.toString();
    }

    private void nodeToString(StringBuffer stringBuffer, Node node, boolean bl) {
        if (bl) {
            this.nodeChildrenToString(stringBuffer, node);
        } else {
            while (node != null) {
                this.nodeChildrenToString(stringBuffer, node);
                node = node.getNextSibling();
            }
        }
    }

    private void nodeChildrenToString(StringBuffer stringBuffer, Node node) {
        String string = node.getNodeValue();
        short s = node.getNodeType();
        if ((s == 3 || s == 4) && string != null) {
            stringBuffer.append(string);
        }
        if (node.getFirstChild() != null) {
            this.nodeToString(stringBuffer, node.getFirstChild(), false);
        }
    }

    Object getValue(BeanProp beanProp) {
        String string = null;
        switch (beanProp.getType() & 0xFF00) {
            case 256: {
                Class clazz = beanProp.getPropClass();
                string = this.node != null ? this.getDomValue(this.node) : (String)this.getBean(beanProp);
                if (!String.class.isAssignableFrom(clazz) && string != null) {
                    String string2 = clazz.getName().intern();
                    try {
                        if (Wrapper.class.isAssignableFrom(clazz)) {
                            Wrapper wrapper = (Wrapper)clazz.newInstance();
                            wrapper.setWrapperValue(string);
                            return wrapper;
                        }
                        if (Character.class.isAssignableFrom(clazz)) {
                            String string3 = string.trim();
                            char c = '\u0000';
                            if (string3.length() == 0) {
                                if (string.length() != 0) {
                                    c = string.charAt(0);
                                }
                            } else {
                                c = string3.charAt(0);
                            }
                            return new Character(c);
                        }
                        if (charArrayClass.isAssignableFrom(clazz)) {
                            return string.toCharArray();
                        }
                        if (string2 == "org.netbeans.modules.schema2beans.QName" || string2 == "javax.xml.namespace.QName") {
                            String string4 = "";
                            String string5 = null;
                            String string6 = "";
                            int n = string.indexOf(58);
                            if (n < 0) {
                                string5 = string;
                            } else {
                                string6 = string.substring(0, n);
                                string5 = string.substring(n + 1, string.length());
                                string4 = this.findNamespace(string6);
                            }
                            if (string2 == "org.netbeans.modules.schema2beans.QName") {
                                return new QName(string4, string5, string6);
                            }
                            Constructor constructor = clazz.getDeclaredConstructor(String.class, String.class, String.class);
                            return constructor.newInstance(string4, string5, string6);
                        }
                        return JavaBeansUtil.convertValue(clazz, string.trim());
                    }
                    catch (Exception exception) {
                        throw new Schema2BeansRuntimeException(MessageFormat.format(Common.getMessage("CantInstantiatePropertyClass_msg"), clazz.getName(), beanProp.getName(), string, exception.getLocalizedMessage()), exception);
                    }
                }
                return string;
            }
            case 512: {
                return this.getBean(beanProp);
            }
            case 768: {
                return this.nodeToBoolean(beanProp);
            }
        }
        throw new Schema2BeansRuntimeException(Common.getMessage("TypeNotSupported_msg", beanProp.getPropClass(), new Integer(beanProp.getType())));
    }

    protected Boolean nodeToBoolean(BeanProp beanProp) {
        if (this.node == null) {
            Object object = this.getBean(beanProp);
            if (object == null) {
                return Boolean.FALSE;
            }
            return (Boolean)object;
        }
        String string = this.getDomValue(this.node);
        if (string == null) {
            return Boolean.TRUE;
        }
        if ((string = string.toLowerCase().intern()) == "false" || string == "0") {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected String findNamespace(String string) {
        String string2 = "xmlns:" + string;
        for (Node node = this.node; node != null; node = node.getParentNode()) {
            Attr attr;
            NamedNodeMap namedNodeMap = node.getAttributes();
            if (namedNodeMap == null || (attr = (Attr)namedNodeMap.getNamedItem(string2)) == null) continue;
            return attr.getValue();
        }
        return "";
    }

    private String getWrapperValue(Object object) {
        if (object.getClass().isInstance(Wrapper.class)) {
            return ((Wrapper)object).getWrapperValue();
        }
        if (object.getClass().isAssignableFrom(charArrayClass)) {
            return new String((char[])object);
        }
        if (object instanceof Calendar) {
            return DOMBinding.calendarToString((Calendar)object);
        }
        if (object instanceof QName) {
            QName qName = (QName)object;
            if ("".equals(qName.getPrefix())) {
                return qName.getLocalPart();
            }
            return qName.getPrefix() + ":" + qName.getLocalPart();
        }
        Class<?> clazz = object.getClass();
        String string = clazz.getName();
        if (string.equals("javax.xml.namespace.QName")) {
            try {
                Method method = clazz.getDeclaredMethod("getPrefix", new Class[0]);
                String string2 = (String)method.invoke(object, new Object[0]);
                Method method2 = clazz.getDeclaredMethod("getLocalPart", new Class[0]);
                String string3 = (String)method2.invoke(object, new Object[0]);
                if ("".equals(string2)) {
                    return string3;
                }
                return string2 + ":" + string3;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException(noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
        }
        return object.toString();
    }

    public static String calendarToString(Calendar calendar) {
        Date date = calendar.getTime();
        SimpleDateFormat simpleDateFormat = calendar.get(10) == 0 && calendar.get(12) == 0 && calendar.get(13) == 0 ? new SimpleDateFormat("yyyy-MM-dd") : (calendar.get(14) == 0 ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss") : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S"));
        String string = simpleDateFormat.format(date);
        if (TimeZone.getDefault().hasSameRules(calendar.getTimeZone())) {
            return string;
        }
        TimeZone timeZone = calendar.getTimeZone();
        int n = DOMBinding.timeZoneOffset(timeZone, 0L);
        if (n == 0) {
            return string + "Z";
        }
        int n2 = n / 1000;
        if (n2 > 0) {
            string = string + "+";
        } else {
            n2 = -1 * n2;
            string = string + "-";
        }
        int n3 = n2 / 3600;
        if (n3 < 10) {
            string = string + "0";
        }
        string = string + n3 + ":";
        int n4 = n2 / 60 % 60;
        if (n4 < 10) {
            string = string + "0";
        }
        string = string + n4;
        return string;
    }

    Object setValue(BeanProp beanProp, Object object) {
        Object object2 = null;
        BeanProperty beanProperty = this.getBeanProperty(beanProp);
        if (beanProperty != null) {
            object2 = beanProperty.value;
            if (object2 == null && this.node != null) {
                object2 = this.getValue(beanProp);
            }
            if (Common.isBean(beanProp.type)) {
                beanProperty.value = object;
            } else if (Common.isString(beanProp.type) && object != null) {
                if (object instanceof QName) {
                    QName qName = (QName)object;
                    String string = qName.getPrefix();
                    String string2 = "";
                    if ("".equals(string)) {
                        string = beanProp.getDtdName() + "_ns__";
                        qName = new QName(qName.getNamespaceURI(), qName.getLocalPart(), string);
                    } else {
                        string2 = this.findNamespace(string);
                    }
                    if ("".equals(string2)) {
                        ((Element)this.node).setAttribute("xmlns:" + string, qName.getNamespaceURI());
                        beanProp.createTransientAttribute("xmlns:" + string);
                    }
                } else {
                    Class<?> clazz = object.getClass();
                    String string = clazz.getName();
                    if (string.equals("javax.xml.namespace.QName")) {
                        try {
                            Method method = clazz.getDeclaredMethod("getPrefix", new Class[0]);
                            String string3 = (String)method.invoke(object, new Object[0]);
                            Method method2 = clazz.getDeclaredMethod("getNamespaceURI", new Class[0]);
                            String string4 = (String)method2.invoke(object, new Object[0]);
                            String string5 = "";
                            if ("".equals(string3)) {
                                Method method3 = clazz.getDeclaredMethod("getLocalPart", new Class[0]);
                                String string6 = (String)method3.invoke(object, new Object[0]);
                                Constructor<?> constructor = clazz.getDeclaredConstructor(String.class, String.class, String.class);
                                string3 = beanProp.getDtdName() + "_ns__";
                                object = constructor.newInstance(string4, string6, string3);
                            } else {
                                string5 = this.findNamespace(string3);
                            }
                            if ("".equals(string5)) {
                                ((Element)this.node).setAttribute("xmlns:" + string3, string4);
                                beanProp.createTransientAttribute("xmlns:" + string3);
                            }
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            throw new RuntimeException(noSuchMethodException);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            throw new RuntimeException(illegalAccessException);
                        }
                        catch (InstantiationException instantiationException) {
                            throw new RuntimeException(instantiationException);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            throw new RuntimeException(invocationTargetException);
                        }
                    }
                }
                beanProperty.value = this.getWrapperValue(object);
            } else {
                beanProperty.value = object;
            }
        }
        return object2;
    }

    private static int timeZoneOffset(TimeZone timeZone, long l) {
        if (timeZone.inDaylightTime(new Date(l))) {
            return timeZone.getRawOffset() + (timeZone.useDaylightTime() ? 3600000 : 0);
        }
        return timeZone.getRawOffset();
    }

    void remove(BeanProp beanProp) {
    }

    void removeProp(BeanProp beanProp) {
        if (this.prop != null && this.prop.beanProp == beanProp) {
            this.prop = null;
        }
    }

    void removeNode(BeanProp beanProp) {
        if (this.node != null) {
            Node node = beanProp.getParentNode();
            if (DDLogFlags.debug) {
                TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 20, this.node.getNodeName() + " from " + node.getNodeName());
            }
            DOMBinding.removeSurroundingSpace(node, this.node);
            node.removeChild(this.node);
            this.node = null;
        }
    }

    private static void removeSurroundingSpace(Node node, Node node2) {
        String string;
        Node node3 = node2.getNextSibling();
        if (node3 != null && node3.getNodeType() == 3 && (string = node3.getNodeValue()).trim().length() == 0) {
            int n = string.indexOf(10);
            if (n == -1) {
                node.removeChild(node3);
            } else {
                string = string.substring(n);
                Node node4 = node2.getPreviousSibling();
                if (node4 != null && node4.getNodeType() == 3) {
                    String string2 = node4.getNodeValue();
                    if (node4.getPreviousSibling() != null) {
                        if (string2.trim().length() == 0) {
                            n = string2.lastIndexOf(10);
                            if (n > 0) {
                                string = string2.substring(0, n) + string;
                            } else {
                                node.removeChild(node4);
                            }
                        }
                    } else {
                        node.removeChild(node4);
                    }
                }
                node3.setNodeValue(string);
            }
        }
    }

    void notifyBeansForChange(Object object, Object object2, String string) {
        if (this.prop != null) {
            PropertyChangeEvent propertyChangeEvent = this.prop.beanProp.prepareForChangeEvent(this, object, object2, string);
            this.prop.beanProp.notifyInternal(propertyChangeEvent, true);
        }
    }

    void syncNodes(BeanProp beanProp, BeanProp.Action action) {
        BeanProperty beanProperty = this.getBeanProperty(beanProp);
        if (DDLogFlags.debug) {
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 17, action.toString() + " " + beanProp.getDtdName() + (beanProperty == null ? " - unknown prop!" : ""));
        }
        if (beanProperty == null) {
            return;
        }
        if (action.action == 2) {
            int n = beanProp.idToIndex(this.id);
            if (n != -1) {
                beanProperty.lastIndex = n;
            }
            PropertyChangeEvent propertyChangeEvent = beanProp.prepareForChangeEvent(this, beanProperty.value, null, null);
            if (Common.isBean(beanProp.type)) {
                BaseBean baseBean = (BaseBean)beanProperty.value;
                baseBean.syncNodes(action);
            }
            if (this.prop != null && this.prop.beanProp == beanProp && this.node != null && (beanProp.getType() & 0xFF00) == 256) {
                beanProperty.value = this.getDomValue(this.node);
            }
            this.removeNode(beanProp);
            beanProp.notifyInternal(propertyChangeEvent, false);
        } else if (action.action == 1) {
            Object object;
            Object object2;
            Object object3;
            if (Common.isBean(beanProp.type)) {
                NodeFactory nodeFactory = beanProp.getNodeFactory();
                if (this.node != null) {
                    System.out.println("Removing from old graph.");
                    object3 = new BeanProp.Action(2);
                    this.syncNodes(this.prop.beanProp, (BeanProp.Action)object3);
                }
                object3 = beanProp.getParentNode();
                this.node = nodeFactory.createElement(beanProp);
                if (DDLogFlags.debug) {
                    TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 19, "adding new child " + this.node.getNodeName() + " to node " + object3.getNodeName());
                }
                object2 = beanProp.getFollowingSibling(this);
                object3.insertBefore(this.node, (Node)object2);
                object = (BaseBean)beanProperty.value;
                ((BaseBean)object).setGraphManager(beanProp.bean.graphManager());
                ((BaseBean)object).syncNodes(action);
            } else if (Common.isBoolean(beanProp.type)) {
                boolean bl = false;
                if (beanProperty.value != null) {
                    bl = (Boolean)beanProperty.value;
                }
                if (Common.shouldNotBeEmpty(beanProp.type) || this.node == null || this.nodeToBoolean(beanProp) != bl) {
                    if (DDLogFlags.debug) {
                        TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 19, (bl ? "adding new" : "removing") + " tag " + beanProp.getDtdName());
                    }
                    object3 = beanProp.getParentNode();
                    if (bl || Common.shouldNotBeEmpty(beanProp.type)) {
                        object2 = beanProp.getNodeFactory();
                        if (this.node == null) {
                            this.node = ((NodeFactory)object2).createElement(beanProp);
                            object = beanProp.getFollowingSibling(this);
                            object3.insertBefore(this.node, (Node)object);
                        }
                        if (Common.shouldNotBeEmpty(beanProp.type)) {
                            object = (CharacterData)this.node.getFirstChild();
                            if (object == null) {
                                object = (CharacterData)((NodeFactory)object2).createText();
                                this.node.appendChild((Node)object);
                                if (DDLogFlags.debug) {
                                    TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 19, "adding new text node " + object.getNodeName() + " to node " + this.node.getNodeName());
                                }
                            }
                            object.setData("" + bl);
                        }
                    } else if (this.node != null) {
                        object3.removeChild(this.node);
                        this.node = null;
                    }
                } else if (DDLogFlags.debug) {
                    TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 19, "keeping same boolean value");
                }
            } else {
                NodeFactory nodeFactory = beanProp.getNodeFactory();
                if (this.node == null) {
                    object3 = beanProp.getParentNode();
                    this.node = nodeFactory.createElement(beanProp);
                    if (DDLogFlags.debug) {
                        TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 19, "adding new child " + this.node.getNodeName() + " to node " + object3.getNodeName());
                    }
                    object2 = beanProp.getFollowingSibling(this);
                    object3.insertBefore(this.node, (Node)object2);
                }
                if ((object3 = (CharacterData)this.node.getFirstChild()) == null) {
                    object3 = (CharacterData)nodeFactory.createText();
                    this.node.appendChild((Node)object3);
                    if (DDLogFlags.debug) {
                        TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 19, "adding new text node " + object3.getNodeName() + " to node " + this.node.getNodeName());
                    }
                }
                object3.setData(beanProperty.value.toString());
            }
            if (this.node != null && beanProperty.attributes != null) {
                for (int i = 0; i < beanProperty.attributes.size(); ++i) {
                    object3 = (CacheAttr)beanProperty.attributes.get(i);
                    if (((CacheAttr)object3).value == null) continue;
                    ((Element)this.node).setAttribute(((CacheAttr)object3).name, ((CacheAttr)object3).value);
                }
                beanProperty.attributes = null;
            }
        } else {
            throw new IllegalArgumentException(Common.getMessage("UnknownAction_msg", new Integer(action.action)));
        }
    }

    boolean hasDomNode() {
        return this.node != null;
    }

    class BeanProperty {
        BeanProp beanProp;
        Object value;
        int lastIndex;
        ArrayList attributes;

        BeanProperty(BeanProp beanProp) {
            this.beanProp = beanProp;
            this.value = null;
            this.lastIndex = -1;
            this.attributes = null;
        }
    }

    class CacheAttr {
        String name;
        String value;

        CacheAttr(String string, String string2) {
            this.name = string;
            this.value = string2;
        }
    }
}

