/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.servlet.FilterRegistration;
import org.apache.catalina.core.FilterRegistrationImpl;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.deploy.FilterDef;
import org.glassfish.logging.annotation.LogMessageInfo;

public class DynamicFilterRegistrationImpl
extends FilterRegistrationImpl
implements FilterRegistration.Dynamic {
    private static final ResourceBundle rb = StandardServer.log.getResourceBundle();
    @LogMessageInfo(message="Unable to configure {0} for filter {1} of servlet context {2}, because this servlet context has already been initialized", level="WARNING")
    public static final String DYNAMIC_FILTER_REGISTRATION_ALREADY_INIT = "AS-WEB-CORE-00115";

    public DynamicFilterRegistrationImpl(FilterDef filterDef, StandardContext ctx) {
        super(filterDef, ctx);
    }

    @Override
    public void setAsyncSupported(boolean isAsyncSupported) {
        if (this.ctx.isContextInitializedCalled()) {
            String msg = MessageFormat.format(rb.getString(DYNAMIC_FILTER_REGISTRATION_ALREADY_INIT), "async-supported", this.filterDef.getFilterName(), this.ctx.getName());
            throw new IllegalStateException(msg);
        }
        this.filterDef.setIsAsyncSupported(isAsyncSupported);
    }
}

