/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.security;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecureAdmin;
import com.sun.enterprise.security.SecurityServicesUtil;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.MessagePolicy;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.module.ServerAuthModule;
import javax.servlet.RequestDispatcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.Response;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.RestResponse;
import org.glassfish.admingui.common.util.RestUtil;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;

public class AdminConsoleAuthModule
implements ServerAuthModule {
    private CallbackHandler handler = null;
    private String restURL = null;
    private String loginPage = null;
    private String loginErrorPage = null;
    private static final Class[] SUPPORTED_MESSAGE_TYPES = new Class[]{HttpServletRequest.class, HttpServletResponse.class};
    private static final String SAVED_SUBJECT = "Saved_Subject";
    private static final String USER_NAME = "userName";
    private static final String ORIG_REQUEST_PATH = "origRequestPath";
    private static final String RESPONSE_TYPE = "application/json";
    public static final String REST_SERVER_NAME = "serverName";
    public static final String REST_SERVER_PORT = "serverPort";
    public static final String REST_TOKEN = "__rTkn__";
    private static final Logger logger = GuiUtil.getLogger();

    @Override
    public void initialize(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler handler, Map options) throws AuthException {
        this.handler = handler;
        if (options != null) {
            this.loginPage = (String)options.get("loginPage");
            if (this.loginPage == null) {
                throw new AuthException("'loginPage' must be supplied as a property in the provider-config in the domain.xml file!");
            }
            this.loginErrorPage = (String)options.get("loginErrorPage");
            if (this.loginErrorPage == null) {
                throw new AuthException("'loginErrorPage' must be supplied as a property in the provider-config in the domain.xml file!");
            }
            ServiceLocator habitat = SecurityServicesUtil.getInstance().getHabitat();
            Domain domain = (Domain)habitat.getService(Domain.class, new Annotation[0]);
            NetworkListener adminListener = domain.getServerNamed("server").getConfig().getNetworkConfig().getNetworkListener("admin-listener");
            SecureAdmin secureAdmin = (SecureAdmin)habitat.getService(SecureAdmin.class, new Annotation[0]);
            String host = adminListener.getAddress();
            this.restURL = (SecureAdmin.Util.isEnabled((SecureAdmin)secureAdmin) ? "https://" : "http://") + (host.equals("0.0.0.0") ? "localhost" : host) + ":" + adminListener.getPort() + "/management/sessions";
        }
    }

    @Override
    public Class[] getSupportedMessageTypes() {
        return SUPPORTED_MESSAGE_TYPES;
    }

    @Override
    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        HttpServletRequest request = (HttpServletRequest)messageInfo.getRequestMessage();
        HttpServletResponse response = (HttpServletResponse)messageInfo.getResponseMessage();
        if (!this.isMandatory(messageInfo) && !request.getRequestURI().endsWith("/j_security_check")) {
            return AuthStatus.SUCCESS;
        }
        HttpSession session = request.getSession(true);
        if (session == null) {
            return AuthStatus.FAILURE;
        }
        Subject savedClientSubject = (Subject)session.getValue(SAVED_SUBJECT);
        if (savedClientSubject != null) {
            clientSubject.getPrincipals().addAll(savedClientSubject.getPrincipals());
            clientSubject.getPublicCredentials().addAll(savedClientSubject.getPublicCredentials());
            clientSubject.getPrivateCredentials().addAll(savedClientSubject.getPrivateCredentials());
            return AuthStatus.SUCCESS;
        }
        if (session.getValue(REST_SERVER_NAME) == null) {
            URL url = null;
            try {
                url = new URL(this.restURL);
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException("Unable to parse REST URL: (" + this.restURL + ")", ex);
            }
            session.putValue(REST_SERVER_NAME, url.getHost());
            session.putValue(REST_SERVER_PORT, url.getPort());
        }
        String username = request.getParameter("j_username");
        String password = request.getParameter("j_password");
        if (username == null || password == null || !request.getMethod().equalsIgnoreCase("post")) {
            String origPath = request.getRequestURI();
            String qs = request.getQueryString();
            if (qs != null && !qs.isEmpty()) {
                origPath = origPath + "?" + qs;
            }
            session.setAttribute(ORIG_REQUEST_PATH, origPath);
            RequestDispatcher rd = request.getRequestDispatcher(this.loginPage);
            try {
                rd.forward(request, response);
            }
            catch (Exception ex) {
                AuthException ae = new AuthException();
                ae.initCause(ex);
                throw ae;
            }
            return AuthStatus.SEND_CONTINUE;
        }
        Client client2 = RestUtil.initialize(ClientBuilder.newBuilder()).build();
        WebTarget target = client2.target(this.restURL);
        target.register((Object)HttpAuthenticationFeature.basic((String)username, (String)password));
        MultivaluedHashMap payLoad = new MultivaluedHashMap();
        payLoad.putSingle((Object)"remoteHostName", (Object)request.getRemoteHost());
        Response resp = (Response)target.request(new String[]{RESPONSE_TYPE}).post(Entity.entity((Object)payLoad, (String)"application/x-www-form-urlencoded"), Response.class);
        RestResponse restResp = RestResponse.getRestResponse(resp);
        if (restResp.isSuccess()) {
            CallerPrincipalCallback cpCallback = new CallerPrincipalCallback(clientSubject, username);
            try {
                this.handler.handle(new Callback[]{cpCallback});
            }
            catch (Exception ex) {
                AuthException ae = new AuthException();
                ae.initCause(ex);
                throw ae;
            }
            request.changeSessionId();
            Object obj = restResp.getResponse().get("data");
            Map extraProperties = null;
            if (obj != null && obj instanceof Map && (obj = ((Map)obj).get("extraProperties")) != null && obj instanceof Map) {
                extraProperties = (Map)obj;
            }
            if (extraProperties != null) {
                session.putValue(REST_TOKEN, extraProperties.get("token"));
            }
            session.putValue(SAVED_SUBJECT, clientSubject);
            session.putValue(USER_NAME, username);
            try {
                String origRequest = (String)session.getAttribute(ORIG_REQUEST_PATH);
                if (origRequest == null || "/favicon.ico".equals(origRequest)) {
                    origRequest = "/index.jsf";
                }
                logger.log(Level.INFO, "Redirecting to {0}", origRequest);
                response.sendRedirect(response.encodeRedirectURL(origRequest));
            }
            catch (Exception ex) {
                AuthException ae = new AuthException();
                ae.initCause(ex);
                throw ae;
            }
            return AuthStatus.SEND_CONTINUE;
        }
        int status = restResp.getResponseCode();
        if (status == 403) {
            request.setAttribute("errorText", GuiUtil.getMessage("alert.ConfigurationError"));
            request.setAttribute("messageText", GuiUtil.getMessage("alert.EnableSecureAdmin"));
        }
        RequestDispatcher rd = request.getRequestDispatcher(this.loginErrorPage);
        try {
            rd.forward(request, response);
        }
        catch (Exception ex) {
            AuthException ae = new AuthException();
            ae.initCause(ex);
            throw ae;
        }
        return AuthStatus.SEND_FAILURE;
    }

    @Override
    public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
        return AuthStatus.SUCCESS;
    }

    @Override
    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
    }

    private boolean isMandatory(MessageInfo messageInfo) {
        return Boolean.valueOf((String)messageInfo.getMap().get("javax.security.auth.message.MessagePolicy.isMandatory"));
    }
}

