/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.RealmsManager;
import com.sun.enterprise.security.auth.realm.file.FileRealm;
import com.sun.enterprise.security.cli.CLIUtil;
import com.sun.enterprise.security.cli.CreateFileUser;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.types.Property;

@Service(name="list-file-users")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.file.user")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=AuthRealm.class, opType=RestEndpoint.OpType.GET, path="list-users", description="List Users", params={@RestParam(name="authrealmname", value="$parent")})})
public class ListFileUser
implements AdminCommand,
AdminCommandSecurity.Preauthorization {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListFileUser.class);
    @Param(name="authrealmname", optional=true)
    private String authRealmName;
    @Param(name="target", primary=true, optional=true, defaultValue="server")
    private String target;
    @Inject
    @Named(value="default-instance-name")
    private Config config;
    @Inject
    private Domain domain;
    @Inject
    private RealmsManager realmsManager;
    @AccessRequired.To(value={"read"})
    private AuthRealm fileAuthRealm;
    private SecurityService securityService;

    public boolean preAuthorization(AdminCommandContext context) {
        this.config = CLIUtil.chooseConfig(this.domain, this.target, context.getActionReport());
        if (this.config == null) {
            return false;
        }
        this.securityService = this.config.getSecurityService();
        this.fileAuthRealm = CLIUtil.findRealm(this.securityService, this.authRealmName);
        if (this.fileAuthRealm == null) {
            ActionReport report = context.getActionReport();
            report.setMessage(localStrings.getLocalString("list.file.user.filerealmnotfound", "File realm {0} does not exist", new Object[]{this.authRealmName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        this.authRealmName = this.fileAuthRealm.getName();
        return true;
    }

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        String fileRealmClassName = this.fileAuthRealm.getClassname();
        if (fileRealmClassName != null && !fileRealmClassName.equals("com.sun.enterprise.security.auth.realm.file.FileRealm")) {
            report.setMessage(localStrings.getLocalString("list.file.user.realmnotsupported", "Configured file realm {0} is not supported.", new Object[]{fileRealmClassName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        String keyFile = null;
        for (Property fileProp : this.fileAuthRealm.getProperty()) {
            if (!fileProp.getName().equals("file")) continue;
            keyFile = fileProp.getValue();
        }
        if (keyFile == null) {
            report.setMessage(localStrings.getLocalString("list.file.user.keyfilenotfound", "There is no physical file associated with this file realm {0} ", new Object[]{this.authRealmName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        boolean exists = new File(keyFile).exists();
        if (!exists) {
            report.setMessage(localStrings.getLocalString("file.realm.keyfilenonexistent", "The specified physical file {0} associated with the file realm {1} does not exist.", new Object[]{keyFile, this.authRealmName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        FileRealm fr = null;
        try {
            this.realmsManager.createRealms(this.config);
            CreateFileUser.refreshRealm(this.config.getName(), this.authRealmName);
            fr = (FileRealm)this.realmsManager.getFromLoadedRealms(this.config.getName(), this.authRealmName);
            if (fr == null) {
                throw new NoSuchRealmException(this.authRealmName);
            }
        }
        catch (NoSuchRealmException e) {
            report.setMessage(localStrings.getLocalString("list.file.user.realmnotsupported", "Configured file realm {0} is not supported.", new Object[]{this.authRealmName}) + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        try {
            Enumeration<String> users = fr.getUserNames();
            ArrayList userList = new ArrayList();
            while (users.hasMoreElements()) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                String userName = users.nextElement();
                part.setMessage(userName);
                HashMap<String, Object> userMap = new HashMap<String, Object>();
                userMap.put("name", userName);
                try {
                    userMap.put("groups", Collections.list(fr.getGroupNames(userName)));
                }
                catch (NoSuchUserException ex) {
                    // empty catch block
                }
                userList.add(userMap);
            }
            Properties extraProperties = new Properties();
            extraProperties.put("users", userList);
            report.setExtraProperties(extraProperties);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (BadRealmException e) {
            report.setMessage(localStrings.getLocalString("list.file.user.realmcorrupted", "Configured file realm {0} is corrupted.", new Object[]{this.authRealmName}) + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }
}

