/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.util.ArrayList;
import java.util.HashMap;
import ndr.NdrException;
import ndr.NdrObject;
import ndr.NetworkDataRepresentation;
import org.jinterop.dcom.common.JIComVersion;
import org.jinterop.dcom.common.JIRuntimeException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JIDualStringArray;
import org.jinterop.dcom.core.JIInterfacePointer;
import org.jinterop.dcom.core.JIMarshalUnMarshalHelper;
import org.jinterop.dcom.core.JIOrpcThat;
import org.jinterop.dcom.core.JIOrpcThis;
import org.jinterop.dcom.core.JIPointer;
import org.jinterop.dcom.core.JISession;
import rpc.core.UUID;

final class JIRemActivation
extends NdrObject {
    public static final int RPC_C_IMP_LEVEL_IDENTIFY = 2;
    public static final int RPC_C_IMP_LEVEL_IMPERSONATE = 3;
    private int impersonationLevel = 3;
    private int mode = 0;
    private String monikerName = null;
    private UUID clsid = null;
    private boolean activationSuccessful = false;
    private JIOrpcThat orpcthat = null;
    private byte[] oxid = null;
    private JIDualStringArray dualStringArrayForOxid = null;
    private String ipid = null;
    private int authenticationHint = -1;
    private JIComVersion comVersion = null;
    private int hresult = -1;
    private JIInterfacePointer mInterfacePointer = null;
    boolean isDual = false;
    String dispIpid = null;
    byte[] dispOid = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public JIRemActivation(String clsid) {
        this.clsid = new UUID(clsid);
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setClientImpersonationLevel(int implLevel) {
        this.impersonationLevel = implLevel;
    }

    public void setfileMonikerAtServer(String name) {
        if (name != null && !name.equalsIgnoreCase("")) {
            this.monikerName = name;
        }
    }

    public int getOpnum() {
        return 0;
    }

    public void write(NetworkDataRepresentation ndr) {
        JIOrpcThis orpcThis = new JIOrpcThis();
        orpcThis.encode(ndr);
        UUID uuid = new UUID();
        uuid.parse(this.clsid.toString());
        try {
            uuid.encode(ndr, ndr.buf);
        }
        catch (NdrException e) {
            JISystem.getLogger().throwing("JIRemActivation", "write", e);
        }
        if (this.monikerName == null) {
            ndr.writeUnsignedLong(0);
        } else {
            ndr.writeCharacterArray(this.monikerName.toCharArray(), 0, this.monikerName.length());
        }
        ndr.writeUnsignedLong(0);
        ndr.writeUnsignedLong(this.impersonationLevel);
        ndr.writeUnsignedLong(this.mode);
        ndr.writeUnsignedLong(2);
        ndr.writeUnsignedLong(new Object().hashCode());
        ndr.writeUnsignedLong(2);
        uuid.parse("00000000-0000-0000-c000-000000000046");
        try {
            uuid.encode(ndr, ndr.buf);
        }
        catch (NdrException e) {
            JISystem.getLogger().throwing("JIRemActivation", "write", e);
        }
        uuid.parse("00020400-0000-0000-c000-000000000046");
        try {
            uuid.encode(ndr, ndr.buf);
        }
        catch (NdrException e) {
            JISystem.getLogger().throwing("JIRemActivation", "write", e);
        }
        ndr.writeUnsignedLong(1);
        ndr.writeUnsignedLong(1);
        ndr.writeUnsignedShort(7);
        byte[] address = JISession.getLocalhostAddressAsIPbytes();
        ndr.writeUnsignedShort(address[0]);
        ndr.writeUnsignedShort(address[1]);
        ndr.writeUnsignedShort(address[2]);
        ndr.writeUnsignedShort(address[3]);
        ndr.writeUnsignedShort(0);
    }

    public void read(NetworkDataRepresentation ndr) {
        Class<?> clazz;
        this.orpcthat = JIOrpcThat.decode(ndr);
        this.oxid = JIMarshalUnMarshalHelper.readOctetArrayLE(ndr, 8);
        int skipdual = ndr.readUnsignedLong();
        if (skipdual != 0) {
            ndr.readUnsignedLong();
            this.dualStringArrayForOxid = JIDualStringArray.decode(ndr);
        }
        try {
            UUID ipid2 = new UUID();
            ipid2.decode(ndr, ndr.getBuffer());
            this.ipid = ipid2.toString();
        }
        catch (NdrException e) {
            JISystem.getLogger().throwing("JIRemActivation", "read", e);
        }
        this.authenticationHint = ndr.readUnsignedLong();
        this.comVersion = new JIComVersion();
        this.comVersion.setMajorVersion(ndr.readUnsignedShort());
        this.comVersion.setMinorVersion(ndr.readUnsignedShort());
        this.hresult = ndr.readUnsignedLong();
        if (this.hresult != 0) {
            throw new JIRuntimeException(this.hresult);
        }
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.jinterop.dcom.core.JIInterfacePointer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JIArray array = new JIArray(clazz2, null, 1, true);
        ArrayList listOfDefferedPointers = new ArrayList();
        array = (JIArray)JIMarshalUnMarshalHelper.deSerialize(ndr, array, listOfDefferedPointers, 0, new HashMap());
        int x = 0;
        while (x < listOfDefferedPointers.size()) {
            ArrayList newList = new ArrayList();
            JIPointer replacement = (JIPointer)JIMarshalUnMarshalHelper.deSerialize(ndr, (JIPointer)listOfDefferedPointers.get(x), newList, 0, null);
            ((JIPointer)listOfDefferedPointers.get(x)).replaceSelfWithNewPointer(replacement);
            listOfDefferedPointers.addAll(++x, newList);
        }
        JIInterfacePointer[] arrayObjs = (JIInterfacePointer[])array.getArrayInstance();
        this.mInterfacePointer = arrayObjs[0];
        if (arrayObjs[1] != null) {
            this.isDual = true;
            JIInterfacePointer ptr = arrayObjs[1];
            this.dispIpid = ptr.getIPID();
            this.dispOid = ptr.getOID();
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        array = new JIArray(clazz, null, 1, true);
        JIMarshalUnMarshalHelper.deSerialize(ndr, array, null, 0, null);
        this.activationSuccessful = true;
    }

    public boolean isActivationSuccessful() {
        return this.activationSuccessful;
    }

    public JIOrpcThat getORPCThat() {
        return this.orpcthat;
    }

    public byte[] getOxid() {
        return this.oxid;
    }

    public JIDualStringArray getDualStringArrayForOxid() {
        return this.dualStringArrayForOxid;
    }

    public int getAuthenticationHint() {
        return this.authenticationHint;
    }

    public JIComVersion getComVersion() {
        return this.comVersion;
    }

    public int getHresult() {
        return this.hresult;
    }

    public JIInterfacePointer getMInterfacePointer() {
        return this.mInterfacePointer;
    }

    public String getIPID() {
        return this.ipid;
    }
}

