/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.deployment.annotation.handlers;

import com.sun.enterprise.connectors.deployment.annotation.handlers.AdministeredObjectDefinitionHandler;
import com.sun.enterprise.deployment.AdministeredObjectDefinitionDescriptor;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractResourceHandler;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import javax.resource.AdministeredObjectDefinition;
import javax.resource.AdministeredObjectDefinitions;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=AdministeredObjectDefinitions.class)
public class AdministeredObjectDefinitionsHandler
extends AbstractResourceHandler {
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AdministeredObjectDefinitionsHandler.class);

    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        AdministeredObjectDefinitions defns = (AdministeredObjectDefinitions)ainfo.getAnnotation();
        AdministeredObjectDefinition[] values = defns.value();
        HashSet<String> duplicates = new HashSet<String>();
        if (values != null && values.length > 0) {
            for (AdministeredObjectDefinition defn : values) {
                String defnName = AdministeredObjectDefinitionDescriptor.getJavaName((String)defn.name());
                if (duplicates.contains(defnName)) {
                    String localString = localStrings.getLocalString("enterprise.deployment.annotation.handlers.administeredobjectdefinitionsduplicates", "@AdministeredObjectDefinitions cannot have multiple definitions with same name : '{0}'", new Object[]{defnName});
                    throw new IllegalStateException(localString);
                }
                duplicates.add(defnName);
                AdministeredObjectDefinitionHandler handler = new AdministeredObjectDefinitionHandler();
                handler.processAnnotation(defn, ainfo, rcContexts);
            }
            duplicates.clear();
        }
        return this.getDefaultProcessedResult();
    }

    public Class<? extends Annotation>[] getTypeDependencies() {
        return this.getEjbAndWebAnnotationTypes();
    }
}

