/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm.jdbc;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.security.auth.digest.api.DigestAlgorithmParameter;
import com.sun.enterprise.security.auth.digest.api.Password;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.InvalidOperationException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.common.Util;
import com.sun.enterprise.security.ee.auth.realm.DigestRealmBase;
import com.sun.enterprise.universal.GFBase64Encoder;
import com.sun.enterprise.util.Utility;
import java.io.Reader;
import java.nio.charset.CharacterCodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import javax.security.auth.login.LoginException;
import javax.sql.DataSource;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.jvnet.hk2.annotations.Service;

@Service
public final class JDBCRealm
extends DigestRealmBase {
    public static final String AUTH_TYPE = "jdbc";
    public static final String PRE_HASHED = "HASHED";
    public static final String PARAM_DATASOURCE_JNDI = "datasource-jndi";
    public static final String PARAM_DB_USER = "db-user";
    public static final String PARAM_DB_PASSWORD = "db-password";
    public static final String PARAM_DIGEST_ALGORITHM = "digest-algorithm";
    public static final String NONE = "none";
    public static final String PARAM_ENCODING = "encoding";
    public static final String HEX = "hex";
    public static final String BASE64 = "base64";
    public static final String DEFAULT_ENCODING = "hex";
    public static final String PARAM_CHARSET = "charset";
    public static final String PARAM_USER_TABLE = "user-table";
    public static final String PARAM_USER_NAME_COLUMN = "user-name-column";
    public static final String PARAM_PASSWORD_COLUMN = "password-column";
    public static final String PARAM_GROUP_TABLE = "group-table";
    public static final String PARAM_GROUP_NAME_COLUMN = "group-name-column";
    public static final String PARAM_GROUP_TABLE_USER_NAME_COLUMN = "group-table-user-name-column";
    private static final char[] HEXADECIMAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private Map<String, Vector> groupCache;
    private Vector<String> emptyVector;
    private String passwordQuery = null;
    private String groupQuery = null;
    private MessageDigest md = null;
    private ActiveDescriptor<ConnectorRuntime> cr;

    @Override
    public synchronized void init(Properties props) throws BadRealmException, NoSuchRealmException {
        super.init(props);
        String jaasCtx = props.getProperty("jaas-context");
        String dbUser = props.getProperty(PARAM_DB_USER);
        String dbPassword = props.getProperty(PARAM_DB_PASSWORD);
        String dsJndi = props.getProperty(PARAM_DATASOURCE_JNDI);
        String digestAlgorithm = props.getProperty(PARAM_DIGEST_ALGORITHM, this.getDefaultDigestAlgorithm());
        String encoding = props.getProperty(PARAM_ENCODING);
        String charset = props.getProperty(PARAM_CHARSET);
        String userTable = props.getProperty(PARAM_USER_TABLE);
        String userNameColumn = props.getProperty(PARAM_USER_NAME_COLUMN);
        String passwordColumn = props.getProperty(PARAM_PASSWORD_COLUMN);
        String groupTable = props.getProperty(PARAM_GROUP_TABLE);
        String groupNameColumn = props.getProperty(PARAM_GROUP_NAME_COLUMN);
        String groupTableUserNameColumn = props.getProperty(PARAM_GROUP_TABLE_USER_NAME_COLUMN, userNameColumn);
        this.cr = Util.getDefaultHabitat().getBestDescriptor(BuilderHelper.createContractFilter(ConnectorRuntime.class.getName()));
        if (jaasCtx == null) {
            String msg = sm.getString("realm.missingprop", (Object)"jaas-context", (Object)"JDBCRealm");
            throw new BadRealmException(msg);
        }
        if (dsJndi == null) {
            String msg = sm.getString("realm.missingprop", (Object)PARAM_DATASOURCE_JNDI, (Object)"JDBCRealm");
            throw new BadRealmException(msg);
        }
        if (userTable == null) {
            String msg = sm.getString("realm.missingprop", (Object)PARAM_USER_TABLE, (Object)"JDBCRealm");
            throw new BadRealmException(msg);
        }
        if (groupTable == null) {
            String msg = sm.getString("realm.missingprop", (Object)PARAM_GROUP_TABLE, (Object)"JDBCRealm");
            throw new BadRealmException(msg);
        }
        if (userNameColumn == null) {
            String msg = sm.getString("realm.missingprop", (Object)PARAM_USER_NAME_COLUMN, (Object)"JDBCRealm");
            throw new BadRealmException(msg);
        }
        if (passwordColumn == null) {
            String msg = sm.getString("realm.missingprop", (Object)PARAM_PASSWORD_COLUMN, (Object)"JDBCRealm");
            throw new BadRealmException(msg);
        }
        if (groupNameColumn == null) {
            String msg = sm.getString("realm.missingprop", (Object)PARAM_GROUP_NAME_COLUMN, (Object)"JDBCRealm");
            throw new BadRealmException(msg);
        }
        this.passwordQuery = "SELECT " + passwordColumn + " FROM " + userTable + " WHERE " + userNameColumn + " = ?";
        this.groupQuery = "SELECT " + groupNameColumn + " FROM " + groupTable + " WHERE " + groupTableUserNameColumn + " = ? ";
        if (!NONE.equalsIgnoreCase(digestAlgorithm)) {
            try {
                this.md = MessageDigest.getInstance(digestAlgorithm);
            }
            catch (NoSuchAlgorithmException e) {
                String msg = sm.getString("jdbcrealm.notsupportdigestalg", (Object)digestAlgorithm);
                throw new BadRealmException(msg);
            }
        }
        if (this.md != null && encoding == null) {
            encoding = "hex";
        }
        this.setProperty("jaas-context", jaasCtx);
        if (dbUser != null && dbPassword != null) {
            this.setProperty(PARAM_DB_USER, dbUser);
            this.setProperty(PARAM_DB_PASSWORD, dbPassword);
        }
        this.setProperty(PARAM_DATASOURCE_JNDI, dsJndi);
        this.setProperty(PARAM_DIGEST_ALGORITHM, digestAlgorithm);
        if (encoding != null) {
            this.setProperty(PARAM_ENCODING, encoding);
        }
        if (charset != null) {
            this.setProperty(PARAM_CHARSET, charset);
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("JDBCRealm : jaas-context= " + jaasCtx + ", " + PARAM_DATASOURCE_JNDI + " = " + dsJndi + ", " + PARAM_DB_USER + " = " + dbUser + ", " + PARAM_DIGEST_ALGORITHM + " = " + digestAlgorithm + ", " + PARAM_ENCODING + " = " + encoding + ", " + PARAM_CHARSET + " = " + charset);
        }
        this.groupCache = new HashMap<String, Vector>();
        this.emptyVector = new Vector();
    }

    @Override
    public String getAuthType() {
        return AUTH_TYPE;
    }

    @Override
    public Enumeration getGroupNames(String username) throws InvalidOperationException, NoSuchUserException {
        Vector vector = this.groupCache.get(username);
        if (vector == null) {
            String[] grps = this.findGroups(username);
            this.setGroupNames(username, grps);
            vector = this.groupCache.get(username);
        }
        return vector.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setGroupNames(String username, String[] groups) {
        Vector<String> v = null;
        if (groups == null) {
            v = this.emptyVector;
        } else {
            v = new Vector(groups.length + 1);
            for (int i = 0; i < groups.length; ++i) {
                v.add(groups[i]);
            }
        }
        JDBCRealm jDBCRealm = this;
        synchronized (jDBCRealm) {
            this.groupCache.put(username, v);
        }
    }

    public String[] authenticate(String username, char[] password) {
        String[] groups = null;
        if (this.isUserValid(username, password)) {
            groups = this.findGroups(username);
            groups = this.addAssignGroups(groups);
            this.setGroupNames(username, groups);
        }
        return groups;
    }

    @Override
    public boolean validate(String username, DigestAlgorithmParameter[] params) {
        Password pass = this.getPassword(username);
        if (pass == null) {
            return false;
        }
        return this.validate(pass, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Password getPassword(String username) {
        ResultSet rs;
        PreparedStatement statement;
        Connection connection;
        block6: {
            String pwd;
            block7: {
                connection = null;
                statement = null;
                rs = null;
                boolean valid = false;
                connection = this.getConnection();
                statement = connection.prepareStatement(this.passwordQuery);
                statement.setString(1, username);
                rs = statement.executeQuery();
                if (!rs.next()) break block6;
                pwd = rs.getString(1);
                if (PRE_HASHED.equalsIgnoreCase(this.getProperty(PARAM_ENCODING))) break block7;
                Password password = new Password(){

                    @Override
                    public byte[] getValue() {
                        return pwd.getBytes();
                    }

                    @Override
                    public int getType() {
                        return 0;
                    }
                };
                this.close(connection, statement, rs);
                return password;
            }
            try {
                Password password = new Password(){

                    @Override
                    public byte[] getValue() {
                        return pwd.getBytes();
                    }

                    @Override
                    public int getType() {
                        return 1;
                    }
                };
                this.close(connection, statement, rs);
                return password;
            }
            catch (Exception ex) {
                try {
                    _logger.log(Level.SEVERE, "jdbcrealm.invaliduser", username);
                    _logger.log(Level.SEVERE, null, ex);
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "Cannot validate user", ex);
                    }
                    this.close(connection, statement, rs);
                }
                catch (Throwable throwable) {
                    this.close(connection, statement, rs);
                    throw throwable;
                }
            }
        }
        this.close(connection, statement, rs);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean isUserValid(String user, char[] password) {
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        boolean valid = false;
        try {
            char[] hpwd = this.hashPassword(password);
            connection = this.getConnection();
            statement = connection.prepareStatement(this.passwordQuery);
            statement.setString(1, user);
            rs = statement.executeQuery();
            if (rs.next()) {
                char[] pwd;
                Reader reader = rs.getCharacterStream(1);
                int noOfChars = reader.read(pwd = new char[1024]);
                if (noOfChars < 0) {
                    noOfChars = 0;
                }
                char[] passwd = new char[noOfChars];
                System.arraycopy(pwd, 0, passwd, 0, noOfChars);
                if ("hex".equalsIgnoreCase(this.getProperty(PARAM_ENCODING))) {
                    valid = true;
                    for (int i = 0; i < noOfChars; ++i) {
                        if (Character.toLowerCase(passwd[i]) == Character.toLowerCase(hpwd[i])) continue;
                        valid = false;
                        break;
                    }
                } else {
                    valid = Arrays.equals(passwd, hpwd);
                }
            }
            this.close(connection, statement, rs);
        }
        catch (SQLException ex) {
            _logger.log(Level.SEVERE, "jdbcrealm.invaliduserreason", new String[]{user, ex.toString()});
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Cannot validate user", ex);
            }
            this.close(connection, statement, rs);
        }
        catch (Exception ex2) {
            _logger.log(Level.SEVERE, "jdbcrealm.invaliduser", user);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Cannot validate user", ex2);
            }
            this.close(connection, statement, rs);
            {
                catch (Throwable throwable) {
                    this.close(connection, statement, rs);
                    throw throwable;
                }
            }
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private char[] hashPassword(char[] password) throws CharacterCodingException {
        String encoding;
        byte[] bytes = null;
        char[] result = null;
        String charSet = this.getProperty(PARAM_CHARSET);
        bytes = Utility.convertCharArrayToByteArray((char[])password, (String)charSet);
        if (this.md != null) {
            MessageDigest messageDigest = this.md;
            synchronized (messageDigest) {
                this.md.reset();
                bytes = this.md.digest(bytes);
            }
        }
        result = "hex".equalsIgnoreCase(encoding = this.getProperty(PARAM_ENCODING)) ? this.hexEncode(bytes) : (BASE64.equalsIgnoreCase(encoding) ? this.base64Encode(bytes).toCharArray() : Utility.convertByteArrayToCharArray((byte[])bytes, (String)charSet));
        return result;
    }

    private char[] hexEncode(byte[] bytes) {
        StringBuilder sb = new StringBuilder(2 * bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            int low = bytes[i] & 0xF;
            int high = (bytes[i] & 0xF0) >> 4;
            sb.append(HEXADECIMAL[high]);
            sb.append(HEXADECIMAL[low]);
        }
        char[] result = new char[sb.length()];
        sb.getChars(0, sb.length(), result, 0);
        return result;
    }

    private String base64Encode(byte[] bytes) {
        GFBase64Encoder encoder = new GFBase64Encoder();
        return encoder.encode(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] findGroups(String user) {
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement(this.groupQuery);
            statement.setString(1, user);
            rs = statement.executeQuery();
            ArrayList<String> groups = new ArrayList<String>();
            while (rs.next()) {
                groups.add(rs.getString(1));
            }
            String[] groupArray = new String[groups.size()];
            String[] stringArray = groups.toArray(groupArray);
            this.close(connection, statement, rs);
            return stringArray;
        }
        catch (Exception ex) {
            try {
                _logger.log(Level.SEVERE, "jdbcrealm.grouperror", user);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Cannot load group", ex);
                }
                String[] stringArray = null;
                this.close(connection, statement, rs);
                return stringArray;
            }
            catch (Throwable throwable) {
                this.close(connection, statement, rs);
                throw throwable;
            }
        }
    }

    private void close(Connection conn, PreparedStatement stmt, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    private Connection getConnection() throws LoginException {
        String dsJndi = this.getProperty(PARAM_DATASOURCE_JNDI);
        String dbUser = this.getProperty(PARAM_DB_USER);
        String dbPassword = this.getProperty(PARAM_DB_PASSWORD);
        try {
            ConnectorRuntime connectorRuntime = Util.getDefaultHabitat().getServiceHandle(this.cr).getService();
            DataSource dataSource = (DataSource)connectorRuntime.lookupNonTxResource(dsJndi, false);
            Connection connection = null;
            connection = dbUser != null && dbPassword != null ? dataSource.getConnection(dbUser, dbPassword) : dataSource.getConnection();
            return connection;
        }
        catch (Exception ex) {
            String msg = sm.getString("jdbcrealm.cantconnect", (Object)dsJndi, (Object)dbUser);
            LoginException loginEx = new LoginException(msg);
            loginEx.initCause(ex);
            throw loginEx;
        }
    }
}

