/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.config.serverbeans.Domain;
import java.lang.annotation.Annotation;
import org.glassfish.config.support.TargetValidator;
import org.glassfish.hk2.api.ServiceLocator;

public enum CommandTarget implements TargetValidator
{
    DOMAIN{

        @Override
        public boolean isValid(ServiceLocator habitat, String target) {
            return target.equals("domain");
        }

        @Override
        public String getDescription() {
            return "Domain";
        }
    }
    ,
    DAS{

        @Override
        public boolean isValid(ServiceLocator habitat, String target) {
            return target.equals("server");
        }

        @Override
        public String getDescription() {
            return "Default server";
        }
    }
    ,
    CLUSTERED_INSTANCE{

        @Override
        public boolean isValid(ServiceLocator habitat, String target) {
            Domain domain = habitat.getService(Domain.class, new Annotation[0]);
            return domain.getClusterForInstance(target) != null;
        }

        @Override
        public String getDescription() {
            return "Clustered Instance";
        }
    }
    ,
    STANDALONE_INSTANCE{

        @Override
        public boolean isValid(ServiceLocator habitat, String target) {
            Domain domain = habitat.getService(Domain.class, new Annotation[0]);
            return domain.getServerNamed(target) != null;
        }

        @Override
        public String getDescription() {
            return "Stand alone instance";
        }
    }
    ,
    CONFIG{

        @Override
        public boolean isValid(ServiceLocator habitat, String target) {
            Domain domain = habitat.getService(Domain.class, new Annotation[0]);
            return domain.getConfigNamed(target) != null;
        }

        @Override
        public String getDescription() {
            return "Config";
        }
    }
    ,
    CLUSTER{

        @Override
        public boolean isValid(ServiceLocator habitat, String target) {
            Domain domain = habitat.getService(Domain.class, new Annotation[0]);
            return domain.getClusterNamed(target) != null;
        }

        @Override
        public String getDescription() {
            return "Cluster";
        }
    }
    ,
    NODE{

        @Override
        public boolean isValid(ServiceLocator habitat, String target) {
            Domain domain = habitat.getService(Domain.class, new Annotation[0]);
            return domain.getNodeNamed(target) != null;
        }

        @Override
        public String getDescription() {
            return "Node";
        }
    };


    @Override
    public boolean isValid(ServiceLocator habitat, String target) {
        return false;
    }

    @Override
    public String getDescription() {
        return this.name();
    }
}

