/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.undo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.util.NLS;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.reference.NewsReference;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.undo.IUndoOperation;
import org.rssowl.ui.internal.undo.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StickyOperation
implements IUndoOperation {
    private static final int LONG_RUNNING_LIMIT = 50;
    private final Map<Boolean, List<NewsReference>> fOldStickyStates;
    private final boolean fMakeSticky;
    private final int fNewsCount;

    public StickyOperation(Collection<INews> news, boolean makeSticky) {
        this.fOldStickyStates = this.toStickyMap(news);
        this.fMakeSticky = makeSticky;
        this.fNewsCount = news.size();
    }

    private Map<Boolean, List<NewsReference>> toStickyMap(Collection<INews> news) {
        HashMap<Boolean, List<NewsReference>> map = new HashMap<Boolean, List<NewsReference>>();
        for (INews newsitem : news) {
            ArrayList<NewsReference> newsrefs = (ArrayList<NewsReference>)map.get(newsitem.isFlagged());
            if (newsrefs == null) {
                newsrefs = new ArrayList<NewsReference>();
                map.put(newsitem.isFlagged(), newsrefs);
            }
            newsrefs.add(newsitem.toReference());
        }
        return map;
    }

    @Override
    public String getName() {
        return this.fMakeSticky ? NLS.bind((String)Messages.StickyOperation_MARK_N_STICKY, (Object)this.fNewsCount) : NLS.bind((String)Messages.StickyOperation_MARK_N_UNSTICKY, (Object)this.fNewsCount);
    }

    @Override
    public void undo() {
        Set<Map.Entry<Boolean, List<NewsReference>>> entries = this.fOldStickyStates.entrySet();
        for (Map.Entry<Boolean, List<NewsReference>> entry : entries) {
            boolean oldSticky = entry.getKey();
            List<NewsReference> newsRefs = entry.getValue();
            ArrayList<INews> resolvedNews = new ArrayList<INews>(newsRefs.size());
            for (NewsReference newsRef : newsRefs) {
                INews news = newsRef.resolve();
                if (news == null) continue;
                resolvedNews.add(news);
                news.setFlagged(oldSticky);
            }
            Controller.getDefault().getSavedSearchService().forceQuickUpdate();
            DynamicDAO.saveAll(resolvedNews);
        }
    }

    @Override
    public void redo() {
        ArrayList<INews> resolvedNews = new ArrayList<INews>(this.fNewsCount);
        Collection<List<NewsReference>> newsRefLists = this.fOldStickyStates.values();
        for (List<NewsReference> newsRefList : newsRefLists) {
            for (NewsReference newsRef : newsRefList) {
                INews news = newsRef.resolve();
                if (news == null) continue;
                resolvedNews.add(news);
                news.setFlagged(this.fMakeSticky);
            }
        }
        Controller.getDefault().getSavedSearchService().forceQuickUpdate();
        DynamicDAO.saveAll(resolvedNews);
    }

    @Override
    public boolean isLongRunning() {
        return this.fNewsCount > 50;
    }
}

