/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.bookmark;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.ICategoryDAO;
import org.rssowl.core.persist.dao.ILabelDAO;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.util.Pair;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.URIUtils;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.actions.ImportAction;
import org.rssowl.ui.internal.dialogs.bookmark.Messages;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.util.LayoutUtils;

public class FeedDefinitionPage
extends WizardPage {
    private Text fFeedLinkInput;
    private Text fKeywordInput;
    private Button fLoadTitleFromFeedButton;
    private Button fFeedByLinkButton;
    private Button fFeedByKeywordButton;
    private String fInitialLink;
    private IPreferenceScope fGlobalScope = Owl.getPreferenceService().getGlobalScope();
    private boolean fIsAutoCompleteKeywordHooked;
    private Map<String, IBookMark> fExistingFeeds = new HashMap<String, IBookMark>();

    protected FeedDefinitionPage(String pageName, String initialLink) {
        super(pageName, pageName, OwlUI.getImageDescriptor("icons/wizban/bkmrk_wiz.gif"));
        this.setMessage(Messages.FeedDefinitionPage_CREATE_BOOKMARK);
        this.fInitialLink = initialLink;
        Collection bookmarks = DynamicDAO.loadAll(IBookMark.class);
        for (IBookMark bookMark : bookmarks) {
            this.fExistingFeeds.put(bookMark.getFeedLinkReference().getLinkAsText(), bookMark);
        }
    }

    boolean loadTitleFromFeed() {
        return this.fLoadTitleFromFeedButton.getSelection();
    }

    private String loadInitialLinkFromClipboard() {
        TextTransfer transfer;
        String initial = "http://";
        Clipboard cb = new Clipboard(this.getShell().getDisplay());
        String data = (String)cb.getContents((Transfer)(transfer = TextTransfer.getInstance()));
        data = data != null ? data.trim() : null;
        cb.dispose();
        if (URIUtils.looksLikeLink((String)data)) {
            initial = URIUtils.ensureProtocol((String)data);
        }
        return initial;
    }

    String getLink() {
        return this.fFeedByLinkButton.getSelection() ? this.fFeedLinkInput.getText().trim() : null;
    }

    void setLink(String link) {
        this.fFeedLinkInput.setText(link);
        this.onLinkChange();
    }

    String getKeyword() {
        return this.fFeedByKeywordButton.getSelection() ? this.fKeywordInput.getText() : null;
    }

    boolean isKeywordSubscription() {
        return StringUtils.isSet((String)this.getKeyword());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && !this.isKeywordSubscription()) {
            this.fFeedLinkInput.setFocus();
        } else if (visible) {
            this.fKeywordInput.setFocus();
        }
    }

    public boolean isPageComplete() {
        if (this.fFeedByLinkButton.getSelection()) {
            return this.fFeedLinkInput.getText().length() > 0;
        }
        return this.fKeywordInput.getText().length() > 0;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        if (!StringUtils.isSet((String)this.fInitialLink)) {
            this.fInitialLink = this.loadInitialLinkFromClipboard();
        }
        boolean loadTitleFromFeed = this.fGlobalScope.getBoolean(DefaultPreferences.BM_LOAD_TITLE_FROM_FEED);
        this.fFeedByLinkButton = new Button(container, 16);
        this.fFeedByLinkButton.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fFeedByLinkButton.setText(loadTitleFromFeed ? Messages.FeedDefinitionPage_CREATE_FEED : Messages.FeedDefinitionPage_CREATE_FEED_DIRECT);
        this.fFeedByLinkButton.setSelection(true);
        this.fFeedByLinkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeedDefinitionPage.this.fFeedLinkInput.setEnabled(FeedDefinitionPage.this.fFeedByLinkButton.getSelection());
                FeedDefinitionPage.this.fLoadTitleFromFeedButton.setEnabled(FeedDefinitionPage.this.fFeedByLinkButton.getSelection());
                FeedDefinitionPage.this.fFeedLinkInput.setFocus();
                FeedDefinitionPage.this.getContainer().updateButtons();
            }
        });
        Composite textIndent = new Composite(container, 0);
        textIndent.setLayoutData((Object)new GridData(4, 1, true, false));
        textIndent.setLayout((Layout)new GridLayout(1, false));
        ((GridLayout)textIndent.getLayout()).marginLeft = 10;
        ((GridLayout)textIndent.getLayout()).marginBottom = 10;
        this.fFeedLinkInput = new Text(textIndent, 2048);
        this.fFeedLinkInput.setLayoutData((Object)new GridData(4, 1, true, false));
        OwlUI.makeAccessible((Control)this.fFeedLinkInput, (Control)this.fFeedByLinkButton);
        GC gc = new GC((Drawable)this.fFeedLinkInput);
        gc.setFont(JFaceResources.getDialogFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        int entryFieldWidth = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)200);
        gc.dispose();
        ((GridData)this.fFeedLinkInput.getLayoutData()).widthHint = entryFieldWidth;
        this.fFeedLinkInput.setFocus();
        if (StringUtils.isSet((String)this.fInitialLink) && !this.fInitialLink.equals("http://")) {
            this.fFeedLinkInput.setText(this.fInitialLink);
            this.fFeedLinkInput.selectAll();
            this.onLinkChange();
        } else {
            this.fFeedLinkInput.setText("http://");
            this.fFeedLinkInput.setSelection("http://".length());
        }
        this.fFeedLinkInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FeedDefinitionPage.this.getContainer().updateButtons();
                FeedDefinitionPage.this.onLinkChange();
            }
        });
        this.fLoadTitleFromFeedButton = new Button(textIndent, 32);
        this.fLoadTitleFromFeedButton.setText(Messages.FeedDefinitionPage_USE_TITLE_OF_FEED);
        this.fLoadTitleFromFeedButton.setSelection(loadTitleFromFeed);
        this.fLoadTitleFromFeedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeedDefinitionPage.this.getContainer().updateButtons();
            }
        });
        this.fFeedByKeywordButton = new Button(container, 16);
        this.fFeedByKeywordButton.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fFeedByKeywordButton.setText(Messages.FeedDefinitionPage_CREATE_KEYWORD_FEED);
        this.fFeedByKeywordButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeedDefinitionPage.this.fKeywordInput.setEnabled(FeedDefinitionPage.this.fFeedByKeywordButton.getSelection());
                if (FeedDefinitionPage.this.fKeywordInput.isEnabled()) {
                    FeedDefinitionPage.this.hookKeywordAutocomplete();
                }
                FeedDefinitionPage.this.fKeywordInput.setFocus();
                FeedDefinitionPage.this.getContainer().updateButtons();
            }
        });
        textIndent = new Composite(container, 0);
        textIndent.setLayoutData((Object)new GridData(4, 1, true, false));
        textIndent.setLayout((Layout)new GridLayout(1, false));
        ((GridLayout)textIndent.getLayout()).marginLeft = 10;
        this.fKeywordInput = new Text(textIndent, 2048);
        OwlUI.makeAccessible((Control)this.fKeywordInput, (Control)this.fFeedByKeywordButton);
        this.fKeywordInput.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fKeywordInput.setEnabled(false);
        this.fKeywordInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FeedDefinitionPage.this.getContainer().updateButtons();
            }
        });
        Composite infoContainer = new Composite(container, 0);
        infoContainer.setLayoutData((Object)new GridData(4, 4, true, false));
        infoContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 5));
        Label infoImg = new Label(infoContainer, 0);
        infoImg.setImage(OwlUI.getImage((Control)infoImg, "icons/obj16/info.gif"));
        infoImg.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Link infoLink = new Link(infoContainer, 0);
        infoLink.setText(Messages.FeedDefinitionPage_IMPORT_WIZARD_TIP);
        infoLink.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        infoLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new ImportAction().openWizardForKeywordSearch(FeedDefinitionPage.this.getShell());
            }
        });
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
    }

    private void onLinkChange() {
        IBookMark existingBookMark = this.fExistingFeeds.get(this.fFeedLinkInput.getText());
        if (existingBookMark != null) {
            this.setMessage(NLS.bind((String)Messages.FeedDefinitionPage_BOOKMARK_EXISTS, (Object)existingBookMark.getName()), 2);
        } else {
            this.setMessage(Messages.FeedDefinitionPage_CREATE_BOOKMARK);
        }
    }

    private void hookKeywordAutocomplete() {
        if (this.fIsAutoCompleteKeywordHooked) {
            return;
        }
        this.fIsAutoCompleteKeywordHooked = true;
        final Pair<SimpleContentProposalProvider, ContentProposalAdapter> autoComplete = OwlUI.hookAutoComplete(this.fKeywordInput, null, true, false);
        JobRunner.runInBackgroundThread(new Runnable(){

            public void run() {
                if (!FeedDefinitionPage.this.fKeywordInput.isDisposed()) {
                    TreeSet<String> values = new TreeSet<String>(new Comparator<String>(){

                        @Override
                        public int compare(String o1, String o2) {
                            return o1.compareToIgnoreCase(o2);
                        }
                    });
                    values.addAll(((ICategoryDAO)DynamicDAO.getDAO(ICategoryDAO.class)).loadAllNames());
                    Collection labels = ((ILabelDAO)DynamicDAO.getDAO(ILabelDAO.class)).loadAll();
                    for (ILabel label : labels) {
                        values.add(label.getName());
                    }
                    if (!FeedDefinitionPage.this.fKeywordInput.isDisposed()) {
                        OwlUI.applyAutoCompleteProposals(values, (SimpleContentProposalProvider)autoComplete.getFirst(), (ContentProposalAdapter)autoComplete.getSecond(), false);
                    }
                }
            }
        });
    }
}

