/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.Messages;
import org.rssowl.ui.internal.util.LayoutUtils;

public class ArchiveNewsDialog
extends TitleAreaDialog {
    private LocalResourceManager fResources = new LocalResourceManager(JFaceResources.getResources());

    public ArchiveNewsDialog(Shell parentShell) {
        super(parentShell);
    }

    public boolean close() {
        this.fResources.dispose();
        return super.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ArchiveNewsDialog_ARCHIVE_NEWS);
    }

    protected String getTitleImage() {
        return "/icons/wizban/archive_wiz.png";
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite((Composite)super.createDialogArea(parent), 0);
        composite.setLayout((Layout)LayoutUtils.createGridLayout(1, 5, 10));
        composite.setLayoutData((Object)new GridData(4, 1, true, false));
        this.setTitle(Messages.ArchiveNewsDialog_ARCHIVE_NEWS);
        this.setTitleImage(OwlUI.getImage((ResourceManager)this.fResources, this.getTitleImage()));
        this.setMessage(Messages.ArchiveNewsDialog_ARCHIVE_NEWS_MSG);
        Label dialogMessageLabel = new Label(composite, 64);
        dialogMessageLabel.setText(Messages.ArchiveNewsDialog_ARCHIVE_NEWS_DESCRIPTION);
        dialogMessageLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        new Label(composite, 0);
        Composite sepHolder = new Composite(parent, 0);
        sepHolder.setLayoutData((Object)new GridData(4, 1, true, false));
        sepHolder.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0));
        Label separator = new Label(sepHolder, 258);
        separator.setLayoutData((Object)new GridData(768));
        ArchiveNewsDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.getButton(0).setFocus();
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Point bestSize = this.getShell().computeSize(this.convertHorizontalDLUsToPixels(320), -1);
        Point location = this.getInitialLocation(bestSize);
        this.getShell().setBounds(location.x, location.y, bestSize.x, bestSize.y);
    }
}

