/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.internal.PageEventAction;
import org.eclipse.ui.internal.SaveablesList;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;

public class SaveAllAction
extends PageEventAction
implements IPropertyListener {
    private List partsWithListeners = new ArrayList(1);
    private IWorkbenchPart openPart;
    static /* synthetic */ Class class$0;

    public SaveAllAction(IWorkbenchWindow window) {
        super(WorkbenchMessages.SaveAll_text, window);
        this.setToolTipText(WorkbenchMessages.SaveAll_toolTip);
        this.setId("saveAll");
        this.setEnabled(false);
        window.getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.save_all_action_context");
        this.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_ETOOL_SAVEALL_EDIT"));
        this.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_ETOOL_SAVEALL_EDIT_DISABLED"));
        this.setActionDefinitionId("org.eclipse.ui.file.saveAll");
    }

    public void pageActivated(IWorkbenchPage page) {
        super.pageActivated(page);
        this.updateState();
    }

    public void pageClosed(IWorkbenchPage page) {
        super.pageClosed(page);
        this.updateState();
    }

    public void partClosed(IWorkbenchPart part) {
        super.partClosed(part);
        if (part instanceof ISaveablePart) {
            part.removePropertyListener(this);
            this.partsWithListeners.remove(part);
            this.updateState();
        }
    }

    public void partOpened(IWorkbenchPart part) {
        super.partOpened(part);
        if (part instanceof ISaveablePart) {
            part.addPropertyListener(this);
            this.partsWithListeners.add(part);
            this.openPart = part;
            this.updateState();
            this.openPart = null;
        }
    }

    public void propertyChanged(Object source, int propID) {
        if (source instanceof ISaveablePart && propID == 257) {
            this.updateState();
        }
    }

    public void run() {
        if (this.getWorkbenchWindow() == null) {
            return;
        }
        WorkbenchPage page = (WorkbenchPage)this.getActivePage();
        if (page != null) {
            page.saveAllEditors(false, true);
            this.updateState();
        }
    }

    protected void updateState() {
        if (this.openPart != null && this.openPart.getSite().getPage().equals(this.getActivePage()) && ((ISaveablePart)((Object)this.openPart)).isDirty()) {
            this.setEnabled(true);
        } else {
            WorkbenchPage page = (WorkbenchPage)this.getActivePage();
            if (page == null) {
                this.setEnabled(false);
            } else if (page.getDirtyParts().length > 0) {
                this.setEnabled(true);
            } else {
                IWorkbench iWorkbench = page.getWorkbenchWindow().getWorkbench();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.ISaveablesLifecycleListener");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                SaveablesList saveablesList = (SaveablesList)iWorkbench.getService(clazz);
                ISaveablesSource[] nonPartSources = saveablesList.getNonPartSources();
                int i = 0;
                while (i < nonPartSources.length) {
                    Saveable[] saveables = nonPartSources[i].getSaveables();
                    int j = 0;
                    while (j < saveables.length) {
                        if (saveables[j].isDirty()) {
                            this.setEnabled(true);
                            return;
                        }
                        ++j;
                    }
                    ++i;
                }
                this.setEnabled(false);
            }
        }
    }

    public void dispose() {
        super.dispose();
        Iterator it = this.partsWithListeners.iterator();
        while (it.hasNext()) {
            IWorkbenchPart part = (IWorkbenchPart)it.next();
            part.removePropertyListener(this);
        }
        this.partsWithListeners.clear();
    }
}

