/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.persist.reference;

import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.service.PersistenceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelReference {
    private final long fId;
    private final Class<? extends IEntity> fEntityClass;

    protected ModelReference(long id, Class<? extends IEntity> entityClass) {
        this.fId = id;
        this.fEntityClass = entityClass;
    }

    public final Class<? extends IEntity> getEntityClass() {
        return this.fEntityClass;
    }

    public final long getId() {
        return this.fId;
    }

    public IEntity resolve() throws PersistenceException {
        return DynamicDAO.getDAOFromEntity(this.fEntityClass).load(this.fId);
    }

    public boolean references(IEntity entity) {
        Long entityId = entity.getId();
        return entityId == null ? false : this.fId == entityId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ModelReference other = (ModelReference)obj;
        return this.fId == other.fId;
    }

    public int hashCode() {
        return (int)(this.fId ^ this.fId >>> 32);
    }

    public String toString() {
        String name = super.toString();
        int index = name.lastIndexOf(46);
        if (index != -1) {
            name = name.substring(index + 1, name.length());
        }
        return String.valueOf(name) + " (ID = " + this.getId() + ")";
    }
}

