/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.dao;

import com.db4o.ext.Db4oException;
import com.db4o.query.Constraint;
import com.db4o.query.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.LazyList;
import org.rssowl.core.internal.persist.News;
import org.rssowl.core.internal.persist.dao.AbstractEntityDAO;
import org.rssowl.core.internal.persist.search.ModelSearchImpl;
import org.rssowl.core.internal.persist.service.DBHelper;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.dao.INewsDAO;
import org.rssowl.core.persist.event.NewsEvent;
import org.rssowl.core.persist.event.NewsListener;
import org.rssowl.core.persist.reference.FeedLinkReference;
import org.rssowl.core.persist.reference.NewsReference;
import org.rssowl.core.persist.service.PersistenceException;
import org.rssowl.core.util.CoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NewsDAOImpl
extends AbstractEntityDAO<INews, NewsListener, NewsEvent>
implements INewsDAO {
    public NewsDAOImpl() {
        super(News.class, false);
    }

    @Override
    protected final void doSave(INews entity) {
        DBHelper.saveAndCascadeNews(this.fDb, entity, true);
    }

    @Override
    protected void preSaveAll(Collection<INews> objects) {
        for (INews news : objects) {
            DBHelper.putEventTemplate(this.createSaveEventTemplate(news));
            ((News)news).acquireReadLockSpecial();
        }
    }

    @Override
    public Collection<INews> loadAll() {
        return new LazyList<INews>(this.fDb.query(News.class), this.fDb);
    }

    @Override
    protected void postSaveAll(Collection<INews> objects) {
        for (INews news : objects) {
            News n = (News)news;
            n.releaseReadLockSpecial();
            n.clearTransientDescription();
        }
    }

    @Override
    protected final NewsEvent createDeleteEventTemplate(INews entity) {
        return new NewsEvent(null, entity, true);
    }

    @Override
    protected final NewsEvent createSaveEventTemplate(INews entity) {
        INews oldNews = DBHelper.peekPersistedNews(this.fDb, entity);
        return new NewsEvent(oldNews, entity, true);
    }

    @Override
    public void setState(Collection<INews> news, INews.State state, boolean affectEquivalentNews, boolean force) throws PersistenceException {
        if (news.isEmpty()) {
            return;
        }
        this.fWriteLock.lock();
        Set<INews> changedNews = null;
        try {
            try {
                if (affectEquivalentNews) {
                    int capacity = news.size() + news.size() / 4;
                    changedNews = new HashSet<INews>(capacity);
                    for (INews newsItem : news) {
                        List<INews> equivalentNews;
                        if (newsItem.getId() == null) {
                            throw new IllegalArgumentException("newsItem was never saved to the database");
                        }
                        if (changedNews.contains(newsItem) || !newsItem.isVisible() && affectEquivalentNews) continue;
                        if (newsItem.getParentId() != 0L) {
                            equivalentNews = Collections.singletonList(newsItem);
                        } else if (newsItem.getGuid() != null && newsItem.getGuid().isPermaLink()) {
                            equivalentNews = this.getNewsFromGuid(newsItem, true);
                            if (equivalentNews.isEmpty()) {
                                throw this.createIllegalException("No news were found with guid: " + newsItem.getGuid().getValue(), newsItem);
                            }
                        } else if (newsItem.getLinkAsText() != null) {
                            equivalentNews = this.getNewsFromLink(newsItem, true);
                            if (equivalentNews.isEmpty()) {
                                throw this.createIllegalException("No news were found with link: " + newsItem.getLinkAsText(), newsItem);
                            }
                        } else {
                            equivalentNews = Collections.singletonList(newsItem);
                        }
                        changedNews.addAll(this.setState(equivalentNews, state, force));
                    }
                } else {
                    changedNews = this.setState(news, state, force);
                }
                try {
                    this.preSaveAll((Collection<INews>)changedNews);
                    this.save(changedNews);
                    this.preCommit();
                    this.fDb.commit();
                }
                finally {
                    this.postSaveAll((Collection<INews>)changedNews);
                }
            }
            catch (Db4oException e) {
                throw DBHelper.rollbackAndPE(this.fDb, (Exception)((Object)e));
            }
        }
        finally {
            this.fWriteLock.unlock();
        }
        DBHelper.cleanUpAndFireEvents();
    }

    @Override
    private void save(Set<INews> newsList) {
        for (INews news : newsList) {
            this.fDb.ext().set((Object)news, 1);
        }
    }

    private RuntimeException createIllegalException(String message, INews newsItem) {
        News dbNews = (News)DBHelper.peekPersistedNews(this.fDb, newsItem);
        if (dbNews == null) {
            return new IllegalArgumentException("The news has been deleted from the persistence layer: " + newsItem);
        }
        return new IllegalStateException(String.valueOf(message) + ". This news in the db looks like: " + dbNews.toLongString());
    }

    private List<INews> getNewsFromLink(INews newsItem, boolean newsSaved) {
        return this.searchNews(newsItem, false, newsSaved);
    }

    private List<INews> getNewsFromGuid(INews newsItem, boolean newsSaved) {
        return this.searchNews(newsItem, true, newsSaved);
    }

    @Override
    public void saveAll(Collection<INews> news) {
        IdentityHashMap<INews, INews> map = new IdentityHashMap<INews, INews>();
        for (INews newsItem : news) {
            map.put(newsItem, newsItem);
        }
        super.saveAll(map.keySet());
    }

    private List<INews> searchNews(INews newsItem, boolean guid, boolean newsSaved) {
        List<INews> news = this.doSearchNews(newsItem, guid);
        if (!newsSaved) {
            return news;
        }
        if (news.contains(newsItem)) {
            return news;
        }
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {}
        news = this.doSearchNews(newsItem, guid);
        if (!news.contains(newsItem)) {
            news.add(newsItem);
        }
        return news;
    }

    private List<INews> doSearchNews(INews newsItem, boolean guid) {
        ModelSearchImpl modelSearch = (ModelSearchImpl)Owl.getPersistenceService().getModelSearch();
        List<NewsReference> hits = guid ? modelSearch.searchNewsByGuid(newsItem.getGuid(), false) : modelSearch.searchNewsByLink(newsItem.getLink(), false);
        ArrayList<INews> news = new ArrayList<INews>(hits.size());
        for (NewsReference hit : hits) {
            if (newsItem.getId() != null && hit.getId() == newsItem.getId().longValue()) {
                news.add(newsItem);
                continue;
            }
            INews resolvedNewsItem = hit.resolve();
            if (resolvedNewsItem != null && resolvedNewsItem.isVisible()) {
                news.add(resolvedNewsItem);
                continue;
            }
            CoreUtils.reportIndexIssue();
        }
        return news;
    }

    private Set<INews> setState(Collection<INews> news, INews.State state, boolean force) {
        HashSet<INews> changedNews = new HashSet<INews>(news.size());
        for (INews newsItem : news) {
            if (newsItem.getState() == state && !force) continue;
            newsItem.setState(state);
            changedNews.add(newsItem);
        }
        return changedNews;
    }

    @Override
    public Collection<INews> loadAll(FeedLinkReference feedRef, Set<INews.State> states) {
        Assert.isNotNull((Object)feedRef, (String)"feedRef");
        Assert.isNotNull(states, (String)"states");
        if (states.isEmpty()) {
            return new ArrayList<INews>(0);
        }
        try {
            Query query = this.fDb.query();
            query.constrain(News.class);
            query.descend("fFeedLink").constrain((Object)feedRef.getLink().toString());
            query.descend("fParentId").constrain((Object)0);
            if (!states.containsAll(EnumSet.allOf(INews.State.class))) {
                Constraint constraint = null;
                for (INews.State state : states) {
                    constraint = constraint == null ? query.descend("fStateOrdinal").constrain((Object)state.ordinal()) : query.descend("fStateOrdinal").constrain((Object)state.ordinal()).or(constraint);
                }
            }
            List news = this.getList(query);
            this.activateAll(news);
            return new ArrayList<INews>(news);
        }
        catch (Db4oException e) {
            throw new PersistenceException(e);
        }
    }

    @Override
    public void setState(Set<INews.State> originalStates, INews.State state, boolean affectEquivalentNews) throws PersistenceException {
        Assert.isNotNull(originalStates, (String)"states");
        Assert.isNotNull((Object)((Object)state), (String)"state");
        if (originalStates.isEmpty()) {
            return;
        }
        try {
            Query query = this.fDb.query();
            query.constrain(News.class);
            if (!originalStates.containsAll(EnumSet.allOf(INews.State.class))) {
                Constraint constraint = null;
                for (INews.State originalState : originalStates) {
                    constraint = constraint == null ? query.descend("fStateOrdinal").constrain((Object)originalState.ordinal()) : query.descend("fStateOrdinal").constrain((Object)originalState.ordinal()).or(constraint);
                }
            }
            List<INews> news = this.getList(query);
            this.activateAll(news);
            this.setState(news, state, affectEquivalentNews, false);
        }
        catch (Db4oException e) {
            throw DBHelper.rollbackAndPE(this.fDb, (Exception)((Object)e));
        }
    }
}

