/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist;

import org.eclipse.core.runtime.Assert;
import org.rssowl.core.internal.persist.AbstractEntity;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.reference.LabelReference;
import org.rssowl.core.util.StringUtils;

public class Label
extends AbstractEntity
implements ILabel {
    private String fName;
    private String fColor;
    private int fOrder;

    public Label(Long id, String name) {
        super(id);
        Assert.isNotNull((Object)name, (String)"The type Label requires a Name that is not NULL");
        this.fName = name;
    }

    protected Label() {
    }

    public synchronized String getColor() {
        return this.fColor;
    }

    public synchronized void setColor(String color) {
        Assert.isLegal((boolean)StringUtils.isValidRGB(color), (String)"Color must be using the format \"R,G,B\", for example \"255,255,127\"");
        this.fColor = color;
    }

    public synchronized String getName() {
        return this.fName;
    }

    public synchronized void setName(String name) {
        Assert.isNotNull((Object)name, (String)"The type Label requires a Name that is not NULL");
        this.fName = name;
    }

    public synchronized int getOrder() {
        return this.fOrder;
    }

    public synchronized void setOrder(int order) {
        this.fOrder = order;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isIdentical(ILabel label) {
        if (this == label) {
            return true;
        }
        if (!(label instanceof Label)) {
            return false;
        }
        ILabel iLabel = label;
        synchronized (iLabel) {
            Label l = (Label)label;
            return (this.getId() == null ? l.getId() == null : this.getId().equals(l.getId())) && this.fName.equals(l.fName) && (this.fColor == null ? l.fColor == null : this.fColor.equals(l.fColor)) && this.getOrder() == l.getOrder() && (this.getProperties() == null ? l.getProperties() == null : this.getProperties().equals(l.getProperties()));
        }
    }

    public synchronized String toString() {
        return String.valueOf(super.toString()) + "Name = " + this.fName + ", Color = " + this.fColor + ")";
    }

    public LabelReference toReference() {
        return new LabelReference(this.getIdAsPrimitive());
    }
}

