/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.query.result;

import com.db4o.foundation.Algorithms4;
import com.db4o.foundation.IntArrayList;
import com.db4o.foundation.IntIterator4;
import com.db4o.foundation.QuickSortable4;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.Buffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.ClassMetadataIterator;
import com.db4o.internal.Transaction;
import com.db4o.internal.TreeInt;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.classindex.BTreeClassIndexStrategy;
import com.db4o.internal.classindex.ClassIndexStrategy;
import com.db4o.internal.query.processor.QCandidate;
import com.db4o.internal.query.processor.QQuery;
import com.db4o.internal.query.result.AbstractQueryResult;
import com.db4o.query.QueryComparator;
import com.db4o.reflect.ReflectClass;

public class IdListQueryResult
extends AbstractQueryResult
implements Visitor4 {
    private Tree _candidates;
    private boolean _checkDuplicates;
    public IntArrayList _ids;

    public IdListQueryResult(Transaction transaction, int n) {
        super(transaction);
        this._ids = new IntArrayList(n);
    }

    public IdListQueryResult(Transaction transaction) {
        this(transaction, 0);
    }

    public IntIterator4 iterateIDs() {
        return this._ids.intIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(int n) {
        Object object = this.lock();
        synchronized (object) {
            return this.activatedObject(this.getId(n));
        }
    }

    public int getId(int n) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this._ids.get(n);
    }

    public final void checkDuplicates() {
        this._checkDuplicates = true;
    }

    public void visit(Object object) {
        QCandidate qCandidate = (QCandidate)object;
        if (qCandidate.include()) {
            this.addKeyCheckDuplicates(qCandidate._key);
        }
    }

    public void addKeyCheckDuplicates(int n) {
        if (this._checkDuplicates) {
            TreeInt treeInt = new TreeInt(n);
            this._candidates = Tree.add(this._candidates, treeInt);
            if (treeInt._size == 0) {
                return;
            }
        }
        this.add(n);
    }

    public void sort(final QueryComparator queryComparator) {
        Algorithms4.qsort(new QuickSortable4(){

            public void swap(int n, int n2) {
                IdListQueryResult.this._ids.swap(n, n2);
            }

            public int size() {
                return IdListQueryResult.this.size();
            }

            public int compare(int n, int n2) {
                return queryComparator.compare(IdListQueryResult.this.get(n), IdListQueryResult.this.get(n2));
            }
        });
    }

    public void loadFromClassIndex(ClassMetadata classMetadata) {
        ClassIndexStrategy classIndexStrategy = classMetadata.index();
        if (classIndexStrategy instanceof BTreeClassIndexStrategy) {
            BTree bTree = ((BTreeClassIndexStrategy)classIndexStrategy).btree();
            this._ids = new IntArrayList(bTree.size(this.transaction()));
        }
        classIndexStrategy.traverseAll(this._transaction, new Visitor4(){

            public void visit(Object object) {
                IdListQueryResult.this.add((Integer)object);
            }
        });
    }

    public void loadFromQuery(QQuery qQuery) {
        qQuery.executeLocal(this);
    }

    public void loadFromClassIndexes(ClassMetadataIterator classMetadataIterator) {
        final Tree.ByRef byRef = new Tree.ByRef();
        while (classMetadataIterator.moveNext()) {
            ReflectClass reflectClass;
            ClassMetadata classMetadata = classMetadataIterator.currentClass();
            if (classMetadata.getName() == null || (reflectClass = classMetadata.classReflector()) != null && this.stream().i_handlers.ICLASS_INTERNAL.isAssignableFrom(reflectClass)) continue;
            ClassIndexStrategy classIndexStrategy = classMetadata.index();
            classIndexStrategy.traverseAll(this._transaction, new Visitor4(){

                public void visit(Object object) {
                    int n = (Integer)object;
                    TreeInt treeInt = new TreeInt(n);
                    byRef.value = Tree.add(byRef.value, treeInt);
                    if (treeInt.size() != 0) {
                        IdListQueryResult.this.add(n);
                    }
                }
            });
        }
    }

    public void loadFromIdReader(Buffer buffer) {
        int n = buffer.readInt();
        for (int i = 0; i < n; ++i) {
            this.add(buffer.readInt());
        }
    }

    public void add(int n) {
        this._ids.add(n);
    }

    public int indexOf(int n) {
        return this._ids.indexOf(n);
    }

    public int size() {
        return this._ids.size();
    }
}

