/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.query;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.foundation.Iterator4Impl;
import com.db4o.foundation.List4;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.diagnostic.DiagnosticProcessor;
import com.db4o.internal.query.Db4oEnhancedFilter;
import com.db4o.internal.query.Db4oNQOptimizer;
import com.db4o.internal.query.Db4oQueryExecutionListener;
import com.db4o.internal.query.NQOptimizationInfo;
import com.db4o.internal.query.PredicateEvaluation;
import com.db4o.query.Predicate;
import com.db4o.query.Query;
import com.db4o.query.QueryComparator;

public class NativeQueryHandler {
    private static final String OPTIMIZER_IMPL_NAME = "com.db4o.nativequery.optimization.Db4oOnTheFlyEnhancer";
    public static final String UNOPTIMIZED = "UNOPTIMIZED";
    public static final String PREOPTIMIZED = "PREOPTIMIZED";
    public static final String DYNOPTIMIZED = "DYNOPTIMIZED";
    private ObjectContainer _container;
    private Db4oNQOptimizer _enhancer;
    private List4 _listeners;

    public NativeQueryHandler(ObjectContainer objectContainer) {
        this._container = objectContainer;
        this.loadQueryOptimizer();
    }

    public void addListener(Db4oQueryExecutionListener db4oQueryExecutionListener) {
        this._listeners = new List4(this._listeners, db4oQueryExecutionListener);
    }

    public void clearListeners() {
        this._listeners = null;
    }

    public ObjectSet execute(Predicate predicate, QueryComparator queryComparator) {
        return this.configureQuery(predicate, queryComparator).execute();
    }

    private Query configureQuery(Predicate predicate, QueryComparator queryComparator) {
        DiagnosticProcessor diagnosticProcessor;
        Query query = this._container.query();
        if (queryComparator != null) {
            query.sortBy(queryComparator);
        }
        query.constrain(predicate.extentType());
        if (predicate instanceof Db4oEnhancedFilter) {
            ((Db4oEnhancedFilter)((Object)predicate)).optimizeQuery(query);
            this.notifyListeners(predicate, PREOPTIMIZED, null);
            return query;
        }
        try {
            if (this.shouldOptimize()) {
                Object object = this._enhancer.optimize(query, predicate);
                this.notifyListeners(predicate, DYNOPTIMIZED, object);
                return query;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        query.constrain(new PredicateEvaluation(predicate));
        this.notifyListeners(predicate, UNOPTIMIZED, null);
        if (this.shouldOptimize() && (diagnosticProcessor = ((ObjectContainerBase)this._container).i_handlers._diagnosticProcessor).enabled()) {
            diagnosticProcessor.nativeQueryUnoptimized(predicate);
        }
        return query;
    }

    private boolean shouldOptimize() {
        return this._container.ext().configure().optimizeNativeQueries() && this._enhancer != null;
    }

    private void notifyListeners(Predicate predicate, String string, Object object) {
        NQOptimizationInfo nQOptimizationInfo = new NQOptimizationInfo(predicate, string, object);
        Iterator4Impl iterator4Impl = new Iterator4Impl(this._listeners);
        while (iterator4Impl.moveNext()) {
            ((Db4oQueryExecutionListener)iterator4Impl.current()).notifyQueryExecuted(nQOptimizationInfo);
        }
    }

    private void loadQueryOptimizer() {
        try {
            Class<?> clazz = Class.forName(OPTIMIZER_IMPL_NAME);
            this._enhancer = (Db4oNQOptimizer)clazz.newInstance();
        }
        catch (Throwable throwable) {
            this._enhancer = null;
        }
    }
}

