/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.CorruptionException;
import com.db4o.internal.Buffer;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.SlotReader;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.marshall.ObjectHeaderAttributes;
import com.db4o.internal.marshall.StringMarshaller;

public class StringMarshaller1
extends StringMarshaller {
    private static final int DEFRAGMENT_INCREMENT_OFFSET = 8;

    public boolean inlinedStrings() {
        return true;
    }

    public void calculateLengths(Transaction transaction, ObjectHeaderAttributes objectHeaderAttributes, boolean bl, Object object, boolean bl2) {
        if (bl) {
            objectHeaderAttributes.addBaseLength(this.linkLength());
            objectHeaderAttributes.prepareIndexedPayLoadEntry(transaction);
        } else if (bl2) {
            objectHeaderAttributes.addPayLoadLength(this.linkLength());
        }
        if (object == null) {
            return;
        }
        objectHeaderAttributes.addPayLoadLength(transaction.stream().stringIO().length((String)object));
    }

    public Object writeNew(Object object, boolean bl, StatefulBuffer statefulBuffer, boolean bl2) {
        ObjectContainerBase objectContainerBase = statefulBuffer.getStream();
        String string = (String)object;
        if (!bl2) {
            if (string != null) {
                StringMarshaller1.writeShort(objectContainerBase, string, statefulBuffer);
            }
            return string;
        }
        if (string == null) {
            statefulBuffer.writeEmbeddedNull();
            return null;
        }
        int n = objectContainerBase.stringIO().length(string);
        StatefulBuffer statefulBuffer2 = new StatefulBuffer(statefulBuffer.getTransaction(), n);
        StringMarshaller1.writeShort(objectContainerBase, string, statefulBuffer2);
        statefulBuffer.writePayload(statefulBuffer2, bl);
        return statefulBuffer2;
    }

    public Buffer readIndexEntry(StatefulBuffer statefulBuffer) throws CorruptionException {
        int n = statefulBuffer.readInt();
        int n2 = statefulBuffer.readInt();
        if (n == 0) {
            return null;
        }
        return statefulBuffer.readPayloadWriter(n, n2);
    }

    public Buffer readSlotFromParentSlot(ObjectContainerBase objectContainerBase, Buffer buffer) throws CorruptionException {
        int n = buffer.readInt();
        int n2 = buffer.readInt();
        if (n == 0) {
            return null;
        }
        return buffer.readPayloadReader(n, n2);
    }

    public void defrag(SlotReader slotReader) {
        slotReader.incrementOffset(8);
    }
}

