/*
 * Decompiled with CFR 0.152.
 */
package msearch.filmeSuchen.sender;

import msearch.daten.DatenFilm;
import msearch.filmeSuchen.MSFilmeSuchen;
import msearch.filmeSuchen.MSGetUrl;
import msearch.filmeSuchen.sender.MediathekReader;
import msearch.tool.MSConfig;
import msearch.tool.MSLog;
import msearch.tool.MSStringBuilder;

public class MediathekZdf
extends MediathekReader
implements Runnable {
    public static final String SENDERNAME = "ZDF";
    private MSStringBuilder seite = new MSStringBuilder(65536);
    private static final int ANZAHL_ZDF_ALLE = 500;
    private static final int ANZAHL_ZDF_MITTEL = 50;
    private static final int ANZAHL_ZDF_UPDATE = 20;
    private static final int ANZAHL_ZDF_KURZ = 10;

    public MediathekZdf(MSFilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 4, 250, startPrio);
    }

    @Override
    public void addToList() {
        this.listeThemen.clear();
        this.meldungStart();
        String addr = "http://www.zdf.de/ZDFmediathek/hauptnavigation/sendung-a-bis-z/saz";
        for (int i = 0; i <= 8; ++i) {
            this.addToList_addr(addr + i, MSConfig.loadLongMax() ? 500 : 20);
        }
        this.addToList_addr("http://www.zdf.de/ZDFmediathek/senderstartseite/sst1/1209122", MSConfig.loadLongMax() ? 500 : 20);
        this.addToList_addr("http://www.zdf.de/ZDFmediathek/senderstartseite/sst1/1209120", MSConfig.loadLongMax() ? 500 : 20);
        this.addToList_addr("http://www.zdf.de/ZDFmediathek/senderstartseite/sst1/1317640", MSConfig.loadLongMax() ? 500 : 20);
        if (MSConfig.loadLongMax()) {
            this.addToList_Rubrik("http://www.zdf.de/ZDFmediathek/hauptnavigation/rubriken");
        }
        this.addThemenliste("http://www.zdf.de/ZDFmediathek/hauptnavigation/sendung-verpasst/day0", "http://www.zdf.de/ZDFmediathek/hauptnavigation/sendung-verpasst/day0", "");
        this.addThemenliste("http://www.zdf.de/ZDFmediathek/hauptnavigation/sendung-verpasst/day1", "http://www.zdf.de/ZDFmediathek/hauptnavigation/sendung-verpasst/day1", "");
        this.addThemenliste("http://www.zdf.de/ZDFmediathek/hauptnavigation/sendung-verpasst/day2", "http://www.zdf.de/ZDFmediathek/hauptnavigation/sendung-verpasst/day2", "");
        this.addThemenliste("http://www.zdf.de/ZDFmediathek/hauptnavigation/sendung-verpasst/day3", "http://www.zdf.de/ZDFmediathek/hauptnavigation/sendung-verpasst/day3", "");
        this.addThemenliste("http://www.zdf.de/ZDFmediathek/hauptnavigation/sendung-verpasst/day4", "http://www.zdf.de/ZDFmediathek/hauptnavigation/sendung-verpasst/day4", "");
        this.addThemenliste("http://www.zdf.de/ZDFmediathek/hauptnavigation/sendung-verpasst/day5", "http://www.zdf.de/ZDFmediathek/hauptnavigation/sendung-verpasst/day5", "");
        this.addThemenliste("http://www.zdf.de/ZDFmediathek/hauptnavigation/sendung-verpasst/day6", "http://www.zdf.de/ZDFmediathek/hauptnavigation/sendung-verpasst/day6", "");
        this.addThemenliste("http://www.zdf.de/ZDFmediathek/hauptnavigation/sendung-verpasst/day7", "http://www.zdf.de/ZDFmediathek/hauptnavigation/sendung-verpasst/day7", "");
        if (MSConfig.loadLongMax()) {
            this.addThemenliste("http://www.zdf.de/ZDFmediathek/senderstartseite/1209114", "http://www.zdf.de/ZDFmediathek/senderstartseite/1209114", "");
            this.addThemenliste("http://www.zdf.de/ZDFmediathek/senderstartseite/sst0/1209122?teaserListIndex=50", "http://www.zdf.de/ZDFmediathek/senderstartseite/sst0/1209122?teaserListIndex=50", "");
            this.addThemenliste("http://www.zdf.de/ZDFmediathek/senderstartseite/sst0/1317640?teaserListIndex=50", "http://www.zdf.de/ZDFmediathek/senderstartseite/sst0/1317640?teaserListIndex=50", "");
            this.addThemenliste("http://www.zdf.de/ZDFmediathek/senderstartseite/sst0/1209120?teaserListIndex=50", "http://www.zdf.de/ZDFmediathek/senderstartseite/sst0/1209120?teaserListIndex=50", "");
        } else {
            this.addThemenliste("http://www.zdf.de/ZDFmediathek/senderstartseite/1209114", "http://www.zdf.de/ZDFmediathek/senderstartseite/1209114", "");
            this.addThemenliste("http://www.zdf.de/ZDFmediathek/senderstartseite/1209122", "http://www.zdf.de/ZDFmediathek/senderstartseite/1209122", "");
            this.addThemenliste("http://www.zdf.de/ZDFmediathek/senderstartseite/1317640", "http://www.zdf.de/ZDFmediathek/senderstartseite/1317640", "");
            this.addThemenliste("http://www.zdf.de/ZDFmediathek/senderstartseite/1209120", "http://www.zdf.de/ZDFmediathek/senderstartseite/1209120", "");
        }
        if (MSConfig.getStop()) {
            this.meldungThreadUndFertig();
        } else if (this.listeThemen.size() == 0) {
            this.meldungThreadUndFertig();
        } else {
            this.meldungAddMax(this.listeThemen.size());
            for (int t = 0; t < this.maxThreadLaufen; ++t) {
                Thread th = new Thread(new ThemaLaden());
                th.setName(SENDERNAME + t);
                th.start();
            }
        }
    }

    private void addToList_Rubrik(String addr) {
        String MUSTER_URL = "<p><b><a href=\"/ZDFmediathek/kanaluebersicht/aktuellste/";
        MSGetUrl getUrl = new MSGetUrl(this.wartenSeiteLaden);
        MSStringBuilder seiteR = new MSStringBuilder(65536);
        if ((seiteR = getUrl.getUri(SENDERNAME, addr, "UTF-8", 6, seiteR, "")).length() == 0) {
            MSLog.fehlerMeldung(774200364, "Leere Seite f\u00fcr URL: " + addr);
        }
        int pos = 0;
        String url = "";
        while ((pos = seiteR.indexOf("<p><b><a href=\"/ZDFmediathek/kanaluebersicht/aktuellste/", pos)) != -1) {
            int pos1 = pos += "<p><b><a href=\"/ZDFmediathek/kanaluebersicht/aktuellste/".length();
            int pos2 = seiteR.indexOf("?", pos);
            int pos3 = seiteR.indexOf("\"", pos);
            if (pos1 != -1 && pos2 != -1 && pos3 != -1 && pos2 < pos3) {
                url = seiteR.substring(pos1, pos2);
            }
            if (url.equals("")) {
                MSLog.fehlerMeldung(754126900, "keine URL: " + addr);
                continue;
            }
            url = "http://www.zdf.de/ZDFmediathek/kanaluebersicht/aktuellste/" + url + "?bc=rub";
            this.addToList_addr(url, 20);
        }
    }

    private void addToList_addr(String addr, int anz) {
        String MUSTER_URL = "<p><b><a href=\"/ZDFmediathek/kanaluebersicht/aktuellste/";
        MSGetUrl getUrl = new MSGetUrl(this.wartenSeiteLaden);
        this.seite = getUrl.getUri(SENDERNAME, addr, "UTF-8", 6, this.seite, "");
        if (this.seite.length() == 0) {
            MSLog.fehlerMeldung(596004563, "Leere Seite f\u00fcr URL: " + addr);
        }
        int pos = 0;
        String url = "";
        String thema = "";
        while ((pos = this.seite.indexOf("<p><b><a href=\"/ZDFmediathek/kanaluebersicht/aktuellste/", pos)) != -1) {
            int pos1 = pos += "<p><b><a href=\"/ZDFmediathek/kanaluebersicht/aktuellste/".length();
            int pos2 = this.seite.indexOf("?", pos);
            int pos3 = this.seite.indexOf("\"", pos);
            if (pos1 != -1 && pos2 != -1 && pos3 != -1 && pos2 < pos3) {
                url = this.seite.substring(pos1, pos2);
            } else {
                pos2 = this.seite.indexOf("\"", pos);
                pos3 = this.seite.indexOf("<", pos);
                if (pos1 != -1 && pos2 != -1 && pos3 != -1 && pos2 < pos3) {
                    url = this.seite.substring(pos1, pos2);
                }
            }
            pos1 = this.seite.indexOf("\">", pos);
            pos2 = this.seite.indexOf("<", pos);
            if (pos1 != -1 && pos2 != -1) {
                thema = this.seite.substring(pos1 + 2, pos2);
            }
            if (url.equals("")) {
                MSLog.fehlerMeldung(946325890, "keine URL: " + addr);
                continue;
            }
            String urlThema = url = "http://www.zdf.de/ZDFmediathek/kanaluebersicht/aktuellste/" + url;
            url = url + "?teaserListIndex=" + anz;
            this.addThemenliste(url, urlThema, thema);
        }
    }

    private synchronized void addThemenliste(String url, String urlThema, String thema) {
        String[] add = new String[]{url, urlThema, thema};
        this.listeThemen.addUrl(add);
    }

    public static void urlTauschen(DatenFilm film, String urlSeite, MSFilmeSuchen mSFilmeSuchen) {
        String l;
        String url_;
        if (film.arr[12].endsWith("1456k_p13v11.mp4")) {
            url_ = film.arr[12].substring(0, film.arr[12].lastIndexOf("1456k_p13v11.mp4")) + "2256k_p14v11.mp4";
            film.arr[9] = l = mSFilmeSuchen.listeFilmeAlt.getDateiGroesse(url_, film.arr[1]);
            film.arr[12] = url_;
        }
        if (film.arr[12].endsWith("1456k_p13v12.mp4")) {
            url_ = film.arr[12].substring(0, film.arr[12].lastIndexOf("1456k_p13v12.mp4")) + "2256k_p14v12.mp4";
            film.arr[9] = l = mSFilmeSuchen.listeFilmeAlt.getDateiGroesse(url_, film.arr[1]);
            film.arr[12] = url_;
            if (!l.isEmpty()) {
                film.arr[9] = l;
                film.arr[12] = url_;
            } else if (MediathekZdf.urlExists(url_)) {
                film.arr[12] = url_;
            } else {
                MSLog.fehlerMeldung(945120369, "urlTauschen: " + urlSeite);
            }
        }
    }

    public static DatenFilm filmHolenId(MSGetUrl getUrl, MSStringBuilder strBuffer, String sender, String thema, String titel, String filmWebsite, String urlId) {
        String urlKlein;
        long laengeL;
        String laenge;
        String BESCHREIBUNG = "<detail>";
        String LAENGE_SEC = "<lengthSec>";
        String LAENGE = "<length>";
        String DATUM = "<airtime>";
        String THEMA = "<originChannelTitle>";
        String zeit = "";
        if ((strBuffer = getUrl.getUri_Utf(sender, urlId, strBuffer, "URL-Filmwebsite: " + filmWebsite)).length() == 0) {
            MSLog.fehlerMeldung(398745601, "url: " + urlId);
            return null;
        }
        String subtitle = strBuffer.extract("<caption>", "<url>http://", "<", "http://");
        String beschreibung = strBuffer.extract("<detail>", "<");
        if (beschreibung.isEmpty()) {
            beschreibung = strBuffer.extract("<detail>", "</");
            beschreibung = beschreibung.replace("<![CDATA[", "");
            if ((beschreibung = beschreibung.replace("]]>", "")).isEmpty()) {
                MSLog.fehlerMeldung(945123074, "url: " + urlId);
            }
        }
        if (thema.isEmpty()) {
            thema = strBuffer.extract("<originChannelTitle>", "<");
        }
        if (!(laenge = strBuffer.extract("<lengthSec>", "<")).isEmpty()) {
            laengeL = MediathekZdf.extractDurationSec(laenge);
        } else {
            laenge = strBuffer.extract("<length>", "<");
            if (laenge.contains(".")) {
                laenge = laenge.substring(0, laenge.indexOf("."));
            }
            laengeL = MediathekZdf.extractDuration(laenge);
        }
        String datum = strBuffer.extract("<airtime>", "<");
        if (datum.contains(" ")) {
            zeit = datum.substring(datum.lastIndexOf(" ")).trim() + ":00";
            datum = datum.substring(0, datum.lastIndexOf(" ")).trim();
        }
        String[] QU_WIDTH_HD = new String[]{"1280"};
        String[] QU_WIDTH = new String[]{"1024", "852", "720", "688", "480", "432", "320"};
        String[] QU_WIDTH_KL = new String[]{"688", "480", "432", "320"};
        String tmp = "";
        String urlHd = MediathekZdf.getUrl(strBuffer, QU_WIDTH_HD, tmp, true);
        String url = MediathekZdf.getUrl(strBuffer, QU_WIDTH, tmp, true);
        if (url.equals(urlKlein = MediathekZdf.getUrl(strBuffer, QU_WIDTH_KL, tmp, false))) {
            urlKlein = "";
        }
        if (url.isEmpty()) {
            url = urlKlein;
            urlKlein = "";
        }
        if (urlHd.isEmpty()) {
            // empty if block
        }
        if (urlKlein.isEmpty()) {
            // empty if block
        }
        if (url.isEmpty()) {
            MSLog.fehlerMeldung(397002891, "keine URL: " + filmWebsite);
            return null;
        }
        DatenFilm film = new DatenFilm(sender, thema, filmWebsite, titel, url, "", datum, zeit, laengeL, beschreibung);
        if (!subtitle.isEmpty()) {
            film.addUrlSubtitle(subtitle);
        }
        film.addUrlKlein(urlKlein, "");
        film.addUrlHd(urlHd, "");
        return film;
    }

    private static String getUrl(MSStringBuilder strBuffer, String[] arr, String tmp, boolean hd) {
        String URL_ANFANG = "<formitaet basetype=\"h264_aac_mp4_http_na_na\"";
        String URL_ENDE = "</formitaet>";
        String URL2 = "<url>";
        String WIDTH = "<width>";
        String ret = "";
        tmp = "";
        block0: for (String qual : arr) {
            int posEnde;
            int posAnfang = 0;
            while ((posAnfang = strBuffer.indexOf("<formitaet basetype=\"h264_aac_mp4_http_na_na\"", posAnfang)) != -1 && (posEnde = strBuffer.indexOf("</formitaet>", posAnfang += "<formitaet basetype=\"h264_aac_mp4_http_na_na\"".length())) != -1) {
                tmp = strBuffer.extract("<url>", "<", posAnfang, posEnde);
                if (!strBuffer.extract("<width>", "<", posAnfang, posEnde).equals(qual) || (ret = hd ? MediathekZdf.checkUrlHD(tmp) : MediathekZdf.checkUrl(tmp)).isEmpty()) continue;
                break block0;
            }
        }
        if (ret.startsWith("http://tvdl.zdf.de")) {
            ret = ret.replace("http://tvdl.zdf.de", "http://nrodl.zdf.de");
        }
        return ret;
    }

    private static String checkUrlHD(String url) {
        String ret = "";
        if (url.startsWith("http") && url.endsWith("mp4") && (ret = url).startsWith("http://www.metafilegenerator.de/ondemand/zdf/hbbtv/")) {
            ret = ret.replaceFirst("http://www.metafilegenerator.de/ondemand/zdf/hbbtv/", "http://nrodl.zdf.de/");
        }
        return ret;
    }

    private static String checkUrl(String url) {
        String ret = "";
        if (url.startsWith("http") && url.endsWith("mp4") && !url.startsWith("http://www.metafilegenerator.de/")) {
            ret = url;
        }
        return ret;
    }

    private class ThemaLaden
    implements Runnable {
        MSGetUrl getUrl;
        private MSStringBuilder seite1;
        private final MSStringBuilder seite2;

        private ThemaLaden() {
            this.getUrl = new MSGetUrl(MediathekZdf.this.wartenSeiteLaden);
            this.seite1 = new MSStringBuilder(65536);
            this.seite2 = new MSStringBuilder(65536);
        }

        @Override
        public void run() {
            try {
                String[] link;
                MediathekZdf.this.meldungAddThread();
                while (!MSConfig.getStop() && (link = this.getListeThemen()) != null) {
                    this.seite1.setLength(0);
                    this.addFilme(link[0], link[1], link[2]);
                    MediathekZdf.this.meldungProgress(link[0]);
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(496583200, ex);
            }
            MediathekZdf.this.meldungThreadUndFertig();
        }

        private void addFilme(String url, String urlThema, String thema) {
            String MUSTER_URL_1 = "<p><b><a href=\"/ZDFmediathek/beitrag/video/";
            String titel = "";
            int pos = 0;
            int anz = 0;
            try {
                this.seite1 = this.getUrl.getUri_Utf(MediathekZdf.SENDERNAME, url, this.seite1, "Thema: " + thema);
                while (!MSConfig.getStop() && (pos = this.seite1.indexOf("<p><b><a href=\"/ZDFmediathek/beitrag/video/", pos)) != -1) {
                    boolean ok = false;
                    if (MSConfig.loadLongMax() || ++anz <= 10) {
                        int pos1 = pos += "<p><b><a href=\"/ZDFmediathek/beitrag/video/".length();
                        int pos2 = this.seite1.indexOf("?", pos);
                        int pos3 = this.seite1.indexOf("\"", pos);
                        String urlFilm = pos1 != -1 && pos2 != -1 && pos3 != -1 && pos2 < pos3 ? this.seite1.substring(pos1, pos2) : this.seite1.substring(pos1, pos3);
                        pos1 = this.seite1.indexOf("\">", pos);
                        pos2 = this.seite1.indexOf("<", pos);
                        if (pos1 != -1 && pos2 != -1) {
                            titel = this.seite1.substring(pos1 + 2, pos2);
                        }
                        if (urlFilm.isEmpty()) {
                            MSLog.fehlerMeldung(643269690, "keine URL: " + url);
                            continue;
                        }
                        urlFilm = "http://www.zdf.de/ZDFmediathek/beitrag/video/" + urlFilm;
                        String urlId = "";
                        pos1 = urlFilm.indexOf("/ZDFmediathek/beitrag/video/");
                        if (pos1 != -1 && (pos2 = urlFilm.indexOf("/", pos1 += "/ZDFmediathek/beitrag/video/".length())) != -1) {
                            urlId = urlFilm.substring(pos1, pos2);
                        }
                        if (!urlId.isEmpty()) {
                            urlId = "http://www.zdf.de/ZDFmediathek/xmlservice/web/beitragsDetails?ak=web&id=" + urlId;
                            MediathekZdf.this.meldung(urlId);
                            DatenFilm film = MediathekZdf.filmHolenId(this.getUrl, this.seite2, MediathekZdf.SENDERNAME, thema, titel, urlFilm, urlId);
                            if (film != null) {
                                MediathekZdf.urlTauschen(film, url, MediathekZdf.this.mSearchFilmeSuchen);
                                MediathekZdf.this.addFilm(film);
                                ok = true;
                            }
                        }
                        if (ok) continue;
                        MSLog.fehlerMeldung(398012379, "auf die alte Art: " + urlFilm);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(796325800, ex, url);
            }
        }

        private synchronized String[] getListeThemen() {
            return (String[])MediathekZdf.this.listeThemen.pollFirst();
        }
    }
}

