/*
 * Decompiled with CFR 0.152.
 */
package mediathek;

import java.awt.SplashScreen;
import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import mediathek.controller.IoXmlLesen;
import mediathek.controller.Log;
import mediathek.daten.Daten;
import mediathek.daten.DatenDownload;
import mediathek.tool.MVListeFilme;
import msearch.filmeSuchen.MSListenerFilmeLaden;
import msearch.filmeSuchen.MSListenerFilmeLadenEvent;
import msearch.filmlisten.MSFilmlisteLesen;

public class MediathekAuto {
    private Daten daten;
    private String pfad = "";
    private boolean bFastAuto = false;
    private static final int SLEEP_VALUE = 2000;
    private static final int SLEEP_VALUE_TIMES_TWO = 4000;

    public MediathekAuto(String[] ar) {
        if (ar != null && ar.length > 0 && !ar[0].startsWith("-")) {
            if (!ar[0].endsWith(File.separator)) {
                ar[0] = ar[0] + File.separator;
            }
            this.pfad = ar[0];
        }
        try {
            SplashScreen splash = SplashScreen.getSplashScreen();
            if (splash != null) {
                splash.close();
            }
        }
        catch (Exception ignored) {
            Log.systemMeldung("NoSplashscreen");
        }
    }

    public void setFastAuto(boolean bFastAuto) {
        this.bFastAuto = bFastAuto;
    }

    public void starten() {
        this.daten = new Daten(this.pfad, null);
        Daten.auto = true;
        Log.startMeldungen();
        if (!IoXmlLesen.einstellungenExistieren()) {
            Log.fehlerMeldung(834986137, "Das Programm muss erst mit der Gui-Version eingerichtet werden!");
            System.exit(1);
        }
        Path xmlFilePath = Daten.getMediathekXmlFilePath();
        Log.systemMeldung("Einstellungen laden: " + xmlFilePath.toString());
        if (!IoXmlLesen.datenLesen(xmlFilePath)) {
            Log.fehlerMeldung(834986137, "Einstellungen konnten nicht geladen werden: " + xmlFilePath.toString());
            System.exit(1);
        }
        MSFilmlisteLesen filmList = new MSFilmlisteLesen();
        if (this.bFastAuto) {
            MSFilmlisteLesen.setWorkMode((MSFilmlisteLesen.WorkMode)MSFilmlisteLesen.WorkMode.FASTAUTO);
        }
        filmList.readFilmListe(Daten.getDateiFilmliste(), Daten.listeFilme, Integer.parseInt(Daten.mVConfig.get("system-anz-tage-filmilste")));
        if (Daten.listeFilme.isTooOld()) {
            Log.systemMeldung("Neue Filmliste laden");
            Daten.filmeLaden.addAdListener(new MSListenerFilmeLaden(){

                public void fertig(MSListenerFilmeLadenEvent event) {
                    MediathekAuto.this.download();
                }
            });
            Daten.filmeLaden.importFilmliste("", true);
        } else {
            Log.systemMeldung("aktuelle Filmliste verwenden");
            Daten.listeAbo.setAboFuerFilm(Daten.listeFilme, false);
            MVListeFilme.checkBlacklist();
            this.download();
        }
    }

    private synchronized void download() {
        try {
            Log.playerMeldungenAus = true;
            Daten.listeDownloads.abosSuchen(null);
            Log.systemMeldung(Daten.listeDownloads.size() + " Filme zum Laden");
            Log.systemMeldung("");
            int i = 1;
            for (DatenDownload d : Daten.listeDownloads) {
                Log.systemMeldung("Film " + i++ + ": ");
                Log.systemMeldung("\tSender: " + d.arr[3]);
                Log.systemMeldung("\tThema: " + d.arr[4]);
                Log.systemMeldung("\tTitel: " + d.arr[5]);
                Log.systemMeldung("");
            }
            Log.systemMeldung("###########################################################");
            for (DatenDownload d : Daten.listeDownloads) {
                d.startDownload(this.daten);
            }
            while (Daten.listeDownloads.getNumberOfStartsNotFinished() > 0) {
                long remTime = Daten.listeDownloads.getMaximumFinishTimeOfRunningStarts();
                if (remTime == 0L || remTime < 10L) {
                    remTime = 2000L;
                } else {
                    remTime = TimeUnit.MILLISECONDS.convert(remTime, TimeUnit.SECONDS);
                    if ((remTime /= 2L) < 4000L) {
                        remTime = 2000L;
                    }
                }
                Thread.sleep(remTime);
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(769325469, ex);
        }
        this.daten.allesSpeichern();
        Log.printEndeMeldung();
        System.exit(0);
    }
}

