/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.juife.event.TaskEvent;
import net.sf.juife.event.TaskListener;
import org.jsampler.CC;
import org.jsampler.task.InstrumentsDb;
import org.jsampler.view.std.JSDbDirectoryChooser;
import org.jsampler.view.std.StdI18n;
import org.linuxsampler.lscp.DbDirectoryInfo;
import org.linuxsampler.lscp.DbInstrumentInfo;
import org.linuxsampler.lscp.DbSearchQuery;

public abstract class JSDbSearchPane
extends JPanel {
    private final JLabel lName = new JLabel(StdI18n.i18n.getLabel("JSDbSearchPane.lName"));
    private final JTextField tfName = new JTextField();
    private final JLabel lDescription = new JLabel(StdI18n.i18n.getLabel("JSDbSearchPane.lDescription"));
    private final JTextField tfDescription = new JTextField();
    private final JLabel lLookIn = new JLabel(StdI18n.i18n.getLabel("JSDbSearchPane.lLookIn"));
    private final JTextField tfLookIn = new JTextField();
    private JButton btnBrowse = new JButton(CC.getViewConfig().getInstrumentsDbTreeView().getOpenIcon());
    private TypeCriteriaPane typeCriteriaPane = new TypeCriteriaPane();
    private DateCriteriaPane dateCreatedPane = new DateCriteriaPane();
    private DateCriteriaPane dateModifiedPane = new DateCriteriaPane();
    private SizeCriteriaPane sizeCriteriaPane = new SizeCriteriaPane();
    private IsDrumCriteriaPane isDrumCriteriaPane = new IsDrumCriteriaPane();
    private MoreCriteriasPane moreCriteriasPane = new MoreCriteriasPane();
    private JButton btnFind = new JButton(StdI18n.i18n.getButtonLabel("JSDbSearchPane.btnFind"));
    private Frame owner;
    private final Vector<ChangeListener> listeners = new Vector();
    private DbDirectoryInfo[] directoryResults = null;
    private DbInstrumentInfo[] instrumentResults = null;
    private final JPanel mainPane;
    private final Handler eventHandler = new Handler();

    public JSDbSearchPane(final Frame frame) {
        this.owner = frame;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        this.lName.setAlignmentX(0.0f);
        jPanel2.add(this.lName);
        jPanel2.add(Box.createRigidArea(new Dimension(0, 3)));
        this.tfName.setAlignmentX(0.0f);
        jPanel2.add(this.tfName);
        jPanel2.add(Box.createRigidArea(new Dimension(0, 6)));
        this.lDescription.setAlignmentX(0.0f);
        jPanel2.add(this.lDescription);
        jPanel2.add(Box.createRigidArea(new Dimension(0, 3)));
        this.tfDescription.setAlignmentX(0.0f);
        jPanel2.add(this.tfDescription);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(3, 0, 6, 6));
        int n = jPanel2.getPreferredSize().height;
        jPanel2.setMaximumSize(new Dimension(Short.MAX_VALUE, n));
        jPanel2.setOpaque(false);
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        this.lLookIn.setAlignmentX(0.0f);
        jPanel.add(this.lLookIn);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        this.tfLookIn.setText("/");
        jPanel2.add(this.tfLookIn);
        jPanel2.add(Box.createRigidArea(new Dimension(6, 0)));
        this.btnBrowse.setMargin(new Insets(0, 0, 0, 0));
        jPanel2.add(this.btnBrowse);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(3, 0, 6, 6));
        n = jPanel2.getPreferredSize().height;
        jPanel2.setMaximumSize(new Dimension(Short.MAX_VALUE, n));
        jPanel2.setOpaque(false);
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        String string = StdI18n.i18n.getLabel("JSDbSearchPane.typeCriteria");
        jPanel.add(this.createCriteriaPane(string, this.typeCriteriaPane));
        jPanel.add(Box.createRigidArea(new Dimension(0, 6)));
        string = StdI18n.i18n.getLabel("JSDbSearchPane.modifiedCriteria");
        jPanel.add(this.createCriteriaPane(string, this.dateModifiedPane));
        jPanel.add(Box.createRigidArea(new Dimension(0, 6)));
        string = StdI18n.i18n.getLabel("JSDbSearchPane.createdCriteria");
        jPanel.add(this.createCriteriaPane(string, this.dateCreatedPane));
        jPanel.add(Box.createRigidArea(new Dimension(0, 6)));
        string = StdI18n.i18n.getLabel("JSDbSearchPane.sizeCriteria");
        jPanel.add(this.createCriteriaPane(string, this.sizeCriteriaPane));
        jPanel.add(Box.createRigidArea(new Dimension(0, 6)));
        string = StdI18n.i18n.getLabel("JSDbSearchPane.isDrumCriteria");
        jPanel.add(this.createCriteriaPane(string, this.isDrumCriteriaPane));
        jPanel.add(Box.createRigidArea(new Dimension(0, 6)));
        string = StdI18n.i18n.getLabel("JSDbSearchPane.moreCriterias");
        jPanel.add(this.createCriteriaPane(string, this.moreCriteriasPane));
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createGlue());
        jPanel2.add(this.btnFind);
        n = jPanel2.getPreferredSize().height;
        jPanel2.setMaximumSize(new Dimension(Short.MAX_VALUE, n));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(12, 0, 6, 6));
        jPanel2.setOpaque(false);
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setOpaque(false);
        jPanel.add(jPanel2);
        jPanel.setBorder(BorderFactory.createEmptyBorder(3, 6, 3, 3));
        this.mainPane = jPanel;
        this.add(new JScrollPane(jPanel));
        this.tfName.addActionListener(this.getHandler());
        this.tfName.getDocument().addDocumentListener(this.getHandler());
        this.tfDescription.addActionListener(this.getHandler());
        this.tfDescription.getDocument().addDocumentListener(this.getHandler());
        this.tfLookIn.getDocument().addDocumentListener(this.getHandler());
        this.btnFind.addActionListener(this.getHandler());
        this.btnFind.setEnabled(false);
        this.btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSDbDirectoryChooser jSDbDirectoryChooser = new JSDbDirectoryChooser(frame);
                String string = JSDbSearchPane.this.tfLookIn.getText();
                if (string.length() > 0) {
                    jSDbDirectoryChooser.setSelectedDirectory(string);
                }
                jSDbDirectoryChooser.setVisible(true);
                if (jSDbDirectoryChooser.isCancelled()) {
                    return;
                }
                JSDbSearchPane.this.tfLookIn.setText(jSDbDirectoryChooser.getSelectedDirectory());
            }
        });
    }

    public void setBackgroundColor(Color color) {
        this.mainPane.setBackground(color);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void fireSearchResultsChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public DbDirectoryInfo[] getDirectoryResults() {
        return this.directoryResults;
    }

    public DbInstrumentInfo[] getInstrumentResults() {
        return this.instrumentResults;
    }

    public void setSearchPath(String string) {
        this.tfLookIn.setText(string);
    }

    private void setSearchResults(DbDirectoryInfo[] dbDirectoryInfoArray, DbInstrumentInfo[] dbInstrumentInfoArray) {
        this.directoryResults = dbDirectoryInfoArray;
        this.instrumentResults = dbInstrumentInfoArray;
        this.fireSearchResultsChanged();
    }

    protected abstract JComponent createCriteriaPane(String var1, JComponent var2);

    private void find() {
        InstrumentsDb.FindDirectories findDirectories;
        InstrumentsDb.FindInstruments findInstruments;
        if (!this.btnFind.isEnabled()) {
            return;
        }
        this.btnFind.setEnabled(false);
        DbSearchQuery dbSearchQuery = new DbSearchQuery();
        dbSearchQuery.name = this.tfName.getText();
        dbSearchQuery.description = this.tfDescription.getText();
        dbSearchQuery.createdAfter = this.dateCreatedPane.getDateAfter();
        dbSearchQuery.createdBefore = this.dateCreatedPane.getDateBefore();
        dbSearchQuery.modifiedAfter = this.dateModifiedPane.getDateAfter();
        dbSearchQuery.modifiedBefore = this.dateModifiedPane.getDateBefore();
        dbSearchQuery.minSize = this.sizeCriteriaPane.getMinSize();
        dbSearchQuery.maxSize = this.sizeCriteriaPane.getMaxSize();
        dbSearchQuery.product = this.moreCriteriasPane.getProduct();
        dbSearchQuery.artists = this.moreCriteriasPane.getArtists();
        dbSearchQuery.keywords = this.moreCriteriasPane.getKeywords();
        dbSearchQuery.instrumentType = this.isDrumCriteriaPane.getInstrumentType();
        if (this.typeCriteriaPane.getSearchInstruments()) {
            findInstruments = new InstrumentsDb.FindInstruments(this.tfLookIn.getText(), dbSearchQuery);
            findInstruments.addTaskListener(new TaskListener(){

                @Override
                public void taskPerformed(TaskEvent taskEvent) {
                    if (!JSDbSearchPane.this.typeCriteriaPane.getSearchDirectories()) {
                        JSDbSearchPane.this.updateState();
                        if (findInstruments.doneWithErrors()) {
                            return;
                        }
                        JSDbSearchPane.this.setSearchResults(null, (DbInstrumentInfo[])findInstruments.getResult());
                    }
                }
            });
        } else {
            findInstruments = null;
        }
        if (this.typeCriteriaPane.getSearchDirectories()) {
            findDirectories = new InstrumentsDb.FindDirectories(this.tfLookIn.getText(), dbSearchQuery);
            findDirectories.addTaskListener(new TaskListener(){

                @Override
                public void taskPerformed(TaskEvent taskEvent) {
                    JSDbSearchPane.this.updateState();
                    if (findDirectories.doneWithErrors()) {
                        return;
                    }
                    if (findInstruments == null) {
                        JSDbSearchPane.this.setSearchResults((DbDirectoryInfo[])findDirectories.getResult(), null);
                    } else {
                        JSDbSearchPane.this.setSearchResults((DbDirectoryInfo[])findDirectories.getResult(), (DbInstrumentInfo[])findInstruments.getResult());
                    }
                }
            });
        } else {
            findDirectories = null;
        }
        if (findInstruments != null) {
            CC.getTaskQueue().add(findInstruments);
        }
        if (findDirectories != null) {
            CC.getTaskQueue().add(findDirectories);
        }
    }

    private void updateState() {
        boolean bl = this.tfName.getText().length() != 0 || this.tfDescription.getText().length() != 0;
        bl = bl && this.tfLookIn.getText().length() != 0;
        this.btnFind.setEnabled(bl);
    }

    private Handler getHandler() {
        return this.eventHandler;
    }

    class MoreCriteriasPane
    extends JPanel {
        private final JLabel lProduct = new JLabel(StdI18n.i18n.getLabel("MoreCriteriasPane.lProduct"));
        private final JLabel lArtists = new JLabel(StdI18n.i18n.getLabel("MoreCriteriasPane.lArtists"));
        private final JLabel lKeywords = new JLabel(StdI18n.i18n.getLabel("MoreCriteriasPane.lKeywords"));
        private final JTextField tfProduct = new JTextField();
        private final JTextField tfArtists = new JTextField();
        private final JTextField tfKeywords = new JTextField();

        MoreCriteriasPane() {
            this.setOpaque(false);
            this.setLayout(new BoxLayout(this, 1));
            this.lProduct.setAlignmentX(0.0f);
            this.add(this.lProduct);
            this.add(Box.createRigidArea(new Dimension(0, 3)));
            this.tfProduct.setAlignmentX(0.0f);
            this.add(this.tfProduct);
            this.add(Box.createRigidArea(new Dimension(0, 3)));
            this.lArtists.setAlignmentX(0.0f);
            this.add(this.lArtists);
            this.add(Box.createRigidArea(new Dimension(0, 3)));
            this.tfArtists.setAlignmentX(0.0f);
            this.add(this.tfArtists);
            this.add(Box.createRigidArea(new Dimension(0, 3)));
            this.lKeywords.setAlignmentX(0.0f);
            this.add(this.lKeywords);
            this.add(Box.createRigidArea(new Dimension(0, 3)));
            this.tfKeywords.setAlignmentX(0.0f);
            this.add(this.tfKeywords);
            this.setBorder(BorderFactory.createEmptyBorder(0, 9, 0, 9));
        }

        public String getProduct() {
            return this.tfProduct.getText();
        }

        public String getArtists() {
            return this.tfArtists.getText();
        }

        public String getKeywords() {
            return this.tfKeywords.getText();
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.tfProduct.setEnabled(bl);
            this.tfArtists.setEnabled(bl);
            this.tfKeywords.setEnabled(bl);
        }
    }

    class IsDrumCriteriaPane
    extends JPanel {
        private JRadioButton rbBoth = new JRadioButton(StdI18n.i18n.getLabel("IsDrumCriteriaPane.rbBoth"));
        private JRadioButton rbChromatic = new JRadioButton(StdI18n.i18n.getLabel("IsDrumCriteriaPane.rbChromatic"));
        private JRadioButton rbDrum = new JRadioButton(StdI18n.i18n.getLabel("IsDrumCriteriaPane.rbDrum"));

        IsDrumCriteriaPane() {
            this.setOpaque(false);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.rbBoth);
            buttonGroup.add(this.rbChromatic);
            buttonGroup.add(this.rbDrum);
            this.rbBoth.doClick(0);
            this.setLayout(new BoxLayout(this, 1));
            this.rbBoth.setAlignmentX(0.0f);
            this.rbBoth.setOpaque(false);
            this.add(this.rbBoth);
            this.rbChromatic.setAlignmentX(0.0f);
            this.rbChromatic.setOpaque(false);
            this.add(this.rbChromatic);
            this.rbDrum.setAlignmentX(0.0f);
            this.rbDrum.setOpaque(false);
            this.add(this.rbDrum);
            this.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 9));
        }

        public DbSearchQuery.InstrumentType getInstrumentType() {
            if (this.rbChromatic.isSelected()) {
                return DbSearchQuery.InstrumentType.CHROMATIC;
            }
            if (this.rbDrum.isSelected()) {
                return DbSearchQuery.InstrumentType.DRUM;
            }
            return DbSearchQuery.InstrumentType.BOTH;
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.rbBoth.setEnabled(bl);
            this.rbChromatic.setEnabled(bl);
            this.rbDrum.setEnabled(bl);
        }
    }

    class FormatCriteriaPane
    extends JPanel
    implements ItemListener {
        private JCheckBox checkAllFormats = new JCheckBox(StdI18n.i18n.getLabel("FormatCriteriaPane.checkAllFormats"));
        private JCheckBox checkGigFormat = new JCheckBox(StdI18n.i18n.getLabel("FormatCriteriaPane.checkGigFormat"));

        FormatCriteriaPane() {
            this.setOpaque(false);
            this.setLayout(new BoxLayout(this, 1));
            this.checkAllFormats.setAlignmentX(0.0f);
            this.checkAllFormats.setOpaque(false);
            this.add(this.checkAllFormats);
            JPanel jPanel = new JPanel();
            jPanel.setOpaque(false);
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.setAlignmentX(0.0f);
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 0));
            jPanel.add(this.checkGigFormat);
            this.add(jPanel);
            this.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 9));
            this.checkAllFormats.addItemListener(this);
            this.checkGigFormat.addItemListener(this);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            if (itemSelectable == this.checkAllFormats || itemSelectable == this.checkGigFormat) {
                // empty if block
            }
        }
    }

    class SizeCriteriaPane
    extends JPanel
    implements ActionListener {
        private JRadioButton rbDontRemember = new JRadioButton(StdI18n.i18n.getLabel("SizeCriteriaPane.rbDontRemember"));
        private JRadioButton rbSpecifySize = new JRadioButton(StdI18n.i18n.getLabel("SizeCriteriaPane.rbSpecifySize"));
        private JSpinner spinnerFrom = new JSpinner(new SpinnerNumberModel());
        private JSpinner spinnerTo = new JSpinner(new SpinnerNumberModel());
        private final JComboBox cbEntity = new JComboBox();

        SizeCriteriaPane() {
            this.setOpaque(false);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.rbDontRemember);
            buttonGroup.add(this.rbSpecifySize);
            this.rbDontRemember.doClick(0);
            this.setLayout(new BoxLayout(this, 1));
            this.rbDontRemember.setAlignmentX(0.0f);
            this.rbDontRemember.setOpaque(false);
            this.add(this.rbDontRemember);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.setAlignmentX(0.0f);
            this.rbSpecifySize.setOpaque(false);
            jPanel.add(this.rbSpecifySize);
            jPanel.add(Box.createRigidArea(new Dimension(3, 0)));
            jPanel.add(this.cbEntity);
            this.add(jPanel);
            jPanel.setOpaque(false);
            this.cbEntity.addItem("KB");
            this.cbEntity.addItem("MB");
            this.cbEntity.addItem("GB");
            this.cbEntity.setSelectedIndex(1);
            this.cbEntity.setMaximumSize(this.cbEntity.getPreferredSize());
            jPanel = new JPanel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            jPanel.setLayout(gridBagLayout);
            gridBagConstraints.fill = 0;
            JLabel jLabel = new JLabel(StdI18n.i18n.getLabel("SizeCriteriaPane.from"));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(3, 18, 3, 3);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
            jLabel = new JLabel(StdI18n.i18n.getLabel("SizeCriteriaPane.to"));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
            this.spinnerFrom.setEnabled(false);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(this.spinnerFrom, gridBagConstraints);
            jPanel.add(this.spinnerFrom);
            this.spinnerTo.setEnabled(false);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagLayout.setConstraints(this.spinnerTo, gridBagConstraints);
            jPanel.add(this.spinnerTo);
            jPanel.setAlignmentX(0.0f);
            jPanel.setOpaque(false);
            this.add(jPanel);
            this.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 9));
            this.rbDontRemember.addActionListener(this);
            this.rbSpecifySize.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = this.rbSpecifySize.isSelected();
            this.spinnerFrom.setEnabled(bl);
            this.spinnerTo.setEnabled(bl);
        }

        public long getMinSize() {
            if (!this.rbSpecifySize.isSelected()) {
                return -1L;
            }
            return this.calcSize(Long.parseLong(this.spinnerFrom.getValue().toString()));
        }

        public long getMaxSize() {
            if (!this.rbSpecifySize.isSelected()) {
                return -1L;
            }
            return this.calcSize(Long.parseLong(this.spinnerTo.getValue().toString()));
        }

        private long calcSize(long l) {
            switch (this.cbEntity.getSelectedIndex()) {
                case 0: {
                    l *= 1024L;
                    break;
                }
                case 1: {
                    l *= 0x100000L;
                    break;
                }
                case 2: {
                    l *= 0x40000000L;
                }
            }
            return l;
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.rbDontRemember.setEnabled(bl);
            this.rbSpecifySize.setEnabled(bl);
            this.spinnerFrom.setEnabled(bl);
            this.spinnerTo.setEnabled(bl);
            this.cbEntity.setEnabled(bl);
            if (bl) {
                this.actionPerformed(null);
            }
        }
    }

    class DateCriteriaPane
    extends JPanel
    implements ActionListener {
        private JRadioButton rbDontRemember = new JRadioButton(StdI18n.i18n.getLabel("DateCriteriaPane.rbDontRemember"));
        private JRadioButton rbSpecifyDates = new JRadioButton(StdI18n.i18n.getLabel("DateCriteriaPane.rbSpecifyDates"));
        private JSpinner spinnerBefore = new JSpinner(new SpinnerDateModel());
        private JSpinner spinnerAfter = new JSpinner(new SpinnerDateModel());

        DateCriteriaPane() {
            this.setOpaque(false);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.rbDontRemember);
            buttonGroup.add(this.rbSpecifyDates);
            this.rbDontRemember.doClick(0);
            this.setLayout(new BoxLayout(this, 1));
            this.rbDontRemember.setAlignmentX(0.0f);
            this.rbDontRemember.setOpaque(false);
            this.add(this.rbDontRemember);
            this.rbSpecifyDates.setAlignmentX(0.0f);
            this.rbSpecifyDates.setOpaque(false);
            this.add(this.rbSpecifyDates);
            JPanel jPanel = new JPanel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            jPanel.setLayout(gridBagLayout);
            gridBagConstraints.fill = 0;
            JLabel jLabel = new JLabel(StdI18n.i18n.getLabel("DateCriteriaPane.from"));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(3, 18, 3, 3);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
            jLabel = new JLabel(StdI18n.i18n.getLabel("DateCriteriaPane.to"));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
            this.spinnerAfter.setEnabled(false);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(this.spinnerAfter, gridBagConstraints);
            jPanel.add(this.spinnerAfter);
            this.spinnerBefore.setEnabled(false);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagLayout.setConstraints(this.spinnerBefore, gridBagConstraints);
            jPanel.add(this.spinnerBefore);
            jPanel.setAlignmentX(0.0f);
            jPanel.setOpaque(false);
            this.add(jPanel);
            this.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 9));
            this.rbDontRemember.addActionListener(this);
            this.rbSpecifyDates.addActionListener(this);
            Calendar calendar = Calendar.getInstance();
            calendar.add(2, -1);
            this.spinnerAfter.setValue(calendar.getTime());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = this.rbSpecifyDates.isSelected();
            this.spinnerAfter.setEnabled(bl);
            this.spinnerBefore.setEnabled(bl);
        }

        public Date getDateAfter() {
            if (!this.rbSpecifyDates.isSelected()) {
                return null;
            }
            return (Date)this.spinnerAfter.getValue();
        }

        public Date getDateBefore() {
            if (!this.rbSpecifyDates.isSelected()) {
                return null;
            }
            return (Date)this.spinnerBefore.getValue();
        }
    }

    class TypeCriteriaPane
    extends JPanel
    implements ActionListener {
        private JRadioButton rbInstruments = new JRadioButton(StdI18n.i18n.getLabel("TypeCriteriaPane.rbInstruments"));
        private JRadioButton rbDirectories = new JRadioButton(StdI18n.i18n.getLabel("TypeCriteriaPane.rbDirectories"));
        private JRadioButton rbBoth = new JRadioButton(StdI18n.i18n.getLabel("TypeCriteriaPane.rbBoth"));

        TypeCriteriaPane() {
            this.setOpaque(false);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.rbInstruments);
            buttonGroup.add(this.rbDirectories);
            buttonGroup.add(this.rbBoth);
            this.rbInstruments.doClick(0);
            this.setLayout(new BoxLayout(this, 1));
            this.rbInstruments.setAlignmentX(0.0f);
            this.rbInstruments.setOpaque(false);
            this.add(this.rbInstruments);
            this.rbDirectories.setAlignmentX(0.0f);
            this.rbDirectories.setOpaque(false);
            this.add(this.rbDirectories);
            this.rbBoth.setAlignmentX(0.0f);
            this.rbBoth.setOpaque(false);
            this.add(this.rbBoth);
            this.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 9));
            this.rbInstruments.addActionListener(this);
            this.rbDirectories.addActionListener(this);
            this.rbBoth.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = !this.rbDirectories.isSelected();
            JSDbSearchPane.this.sizeCriteriaPane.setEnabled(bl);
            JSDbSearchPane.this.isDrumCriteriaPane.setEnabled(bl);
            JSDbSearchPane.this.moreCriteriasPane.setEnabled(bl);
        }

        public boolean getSearchInstruments() {
            return this.rbInstruments.isSelected() || this.rbBoth.isSelected();
        }

        public boolean getSearchDirectories() {
            return this.rbDirectories.isSelected() || this.rbBoth.isSelected();
        }
    }

    private class Handler
    implements DocumentListener,
    ActionListener {
        private Handler() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            JSDbSearchPane.this.updateState();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            JSDbSearchPane.this.updateState();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            JSDbSearchPane.this.updateState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JSDbSearchPane.this.find();
        }
    }
}

