/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso;

import com.pugh.sockso.Properties;
import com.pugh.sockso.Utils;
import com.pugh.sockso.events.LatestVersionEvent;
import com.pugh.sockso.events.LatestVersionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class VersionChecker {
    private static final Logger log = Logger.getLogger(VersionChecker.class);
    private final Properties p;
    private final Vector<LatestVersionListener> listeners;

    public VersionChecker(Properties p) {
        this.p = p;
        this.listeners = new Vector();
    }

    public void addLatestVersionListener(LatestVersionListener listener) {
        this.listeners.add(listener);
    }

    public void fireLatestVersionEvent(String version) {
        LatestVersionEvent evt = new LatestVersionEvent(version);
        for (LatestVersionListener listener : this.listeners) {
            listener.latestVersionReceived(evt);
        }
    }

    public void fetchLatestVersion() {
        try {
            String latestUrl = "http://sockso.pu-gh.com/version/latest";
            URL url = new URL("http://sockso.pu-gh.com/version/latest");
            HttpURLConnection cnn = (HttpURLConnection)url.openConnection();
            cnn.setRequestMethod("GET");
            this.fetchLatestVersionFrom(cnn);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchLatestVersionFrom(HttpURLConnection cnn) {
        if (this.p.get("version.checkDisabled").equals("yes")) {
            return;
        }
        try {
            BufferedReader in;
            block5: {
                in = null;
                try {
                    in = new BufferedReader(new InputStreamReader(cnn.getInputStream()));
                    String s = in.readLine();
                    Matcher m = Pattern.compile("\\d+.\\d+.?\\d*").matcher(s);
                    log.debug((Object)("Latest version response: " + s));
                    if (!m.matches()) break block5;
                    this.fireLatestVersionEvent(s);
                }
                catch (Throwable throwable) {
                    Utils.close(in);
                    throw throwable;
                }
            }
            Utils.close(in);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }
}

