/*
 * Decompiled with CFR 0.152.
 */
package plugins.script;

import freemind.common.BooleanProperty;
import freemind.common.ScriptEditorProperty;
import freemind.common.SeparatorProperty;
import freemind.common.StringProperty;
import freemind.common.TextTranslator;
import freemind.controller.actions.generated.instance.Pattern;
import freemind.controller.actions.generated.instance.ScriptEditorWindowConfigurationStorage;
import freemind.controller.actions.generated.instance.WindowConfigurationStorage;
import freemind.extensions.HookRegistration;
import freemind.main.HtmlTools;
import freemind.main.Tools;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.ApplyPatternAction;
import freemind.preferences.FreemindPropertyContributor;
import freemind.preferences.layout.OptionPanel;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JDialog;
import plugins.script.ScriptEditorPanel;
import plugins.script.ScriptingEngine;

public class ScriptingRegistration
implements HookRegistration,
ApplyPatternAction.ExternalPatternAction {
    private final MindMapController controller;
    private final MindMap mMap;
    private ScriptEditorProperty.ScriptEditorStarter mScriptEditorStarter;
    private HashMap mScriptCookies = new HashMap();
    private ScriptingPluginPropertyContributor mScriptingPluginPropertyContributor;

    public ScriptingRegistration(ModeController controller, MindMap map) {
        this.controller = (MindMapController)controller;
        this.mMap = map;
        ScriptingEngine.logger = controller.getFrame().getLogger(this.getClass().getName());
    }

    public void register() {
        this.controller.registerPlugin((MindMapController.MindMapControllerPlugin)this);
        this.mScriptEditorStarter = new ScriptEditorProperty.ScriptEditorStarter(){

            public String startEditor(String pScriptInput) {
                ScriptingEngine.logger.info("Start to edit script..." + pScriptInput);
                PatternScriptModel patternScriptModel = new PatternScriptModel(pScriptInput);
                ScriptEditorPanel scriptEditorPanel = new ScriptEditorPanel(patternScriptModel, ScriptingRegistration.this.controller.getFrame(), false);
                scriptEditorPanel.setVisible(true);
                return patternScriptModel.getScript();
            }
        };
        this.controller.registerPlugin((MindMapController.MindMapControllerPlugin)this.mScriptEditorStarter);
        this.mScriptingPluginPropertyContributor = new ScriptingPluginPropertyContributor(this.controller);
        OptionPanel.addContributor((FreemindPropertyContributor)this.mScriptingPluginPropertyContributor);
    }

    public void deRegister() {
        this.controller.deregisterPlugin((MindMapController.MindMapControllerPlugin)this);
        this.controller.deregisterPlugin((MindMapController.MindMapControllerPlugin)this.mScriptEditorStarter);
        OptionPanel.removeContributor((FreemindPropertyContributor)this.mScriptingPluginPropertyContributor);
    }

    public void act(MindMapNode node, Pattern pattern) {
        if (pattern.getPatternScript() != null && pattern.getPatternScript().getValue() != null) {
            ScriptingEngine.executeScript(node, new Tools.BooleanHolder(false), HtmlTools.unescapeHTMLUnicodeEntity((String)pattern.getPatternScript().getValue()), this.controller, new ScriptingEngine.ErrorHandler(){

                public void gotoLine(int pLineNumber) {
                }
            }, System.out, this.getScriptCookies());
        }
    }

    public HashMap getScriptCookies() {
        return this.mScriptCookies;
    }

    private final class PatternScriptModel
    implements ScriptEditorPanel.ScriptModel {
        private String mScript;
        private String mOriginalScript;

        public PatternScriptModel(String pScript) {
            this.mScript = pScript;
            this.mOriginalScript = pScript;
        }

        public ScriptEditorWindowConfigurationStorage decorateDialog(ScriptEditorPanel pPanel, String pWindow_preference_storage_property) {
            return (ScriptEditorWindowConfigurationStorage)ScriptingRegistration.this.controller.decorateDialog((JDialog)pPanel, pWindow_preference_storage_property);
        }

        public void endDialog(boolean pIsCanceled) {
            if (pIsCanceled) {
                this.mScript = this.mOriginalScript;
            }
        }

        public boolean executeScript(int pIndex, PrintStream pOutStream, ScriptingEngine.ErrorHandler pErrorHandler) {
            return ScriptingEngine.executeScript(ScriptingRegistration.this.controller.getSelected(), new Tools.BooleanHolder(true), this.mScript, ScriptingRegistration.this.controller, pErrorHandler, pOutStream, ScriptingRegistration.this.getScriptCookies());
        }

        public int getAmountOfScripts() {
            return 1;
        }

        public ScriptEditorPanel.ScriptHolder getScript(int pIndex) {
            return new ScriptEditorPanel.ScriptHolder("Script", this.mScript);
        }

        public boolean isDirty() {
            return !Tools.safeEquals((String)this.mScript, (String)this.mOriginalScript);
        }

        public void setScript(int pIndex, ScriptEditorPanel.ScriptHolder pScript) {
            this.mScript = pScript.getScript();
        }

        public void storeDialogPositions(ScriptEditorPanel pPanel, ScriptEditorWindowConfigurationStorage pStorage, String pWindow_preference_storage_property) {
            ScriptingRegistration.this.controller.storeDialogPositions((JDialog)pPanel, (WindowConfigurationStorage)pStorage, pWindow_preference_storage_property);
        }

        public String getScript() {
            return this.mScript;
        }

        public int addNewScript() {
            return 0;
        }
    }

    private static final class ScriptingPluginPropertyContributor
    implements FreemindPropertyContributor {
        private final MindMapController modeController;

        public ScriptingPluginPropertyContributor(MindMapController modeController) {
            this.modeController = modeController;
        }

        public List getControls(TextTranslator pTextTranslator) {
            Vector<Object> controls = new Vector<Object>();
            controls.add(new OptionPanel.NewTabProperty("plugins/scripting/tab_name"));
            controls.add(new SeparatorProperty("plugins/scripting/separatorPropertyName"));
            controls.add(new BooleanProperty("resources_execute_scripts_without_file_restriction.tooltip", "resources_execute_scripts_without_file_restriction"));
            controls.add(new BooleanProperty("resources_execute_scripts_without_network_restriction.tooltip", "resources_execute_scripts_without_network_restriction"));
            controls.add(new BooleanProperty("resources_execute_scripts_without_exec_restriction.tooltip", "resources_execute_scripts_without_exec_restriction"));
            controls.add(new BooleanProperty("resources_signed_script_are_trusted.tooltip", "resources_signed_script_are_trusted"));
            controls.add(new StringProperty("resources_script_user_key_name_for_signing.tooltip", "resources_script_user_key_name_for_signing"));
            return controls;
        }
    }
}

