/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.CSSWriter;
import com.lightdev.app.shtm.DocNameMissingException;
import com.lightdev.app.shtm.SHTMLDocument;
import com.lightdev.app.shtm.SHTMLEditorKit;
import com.lightdev.app.shtm.SHTMLEditorPane;
import com.lightdev.app.shtm.SHTMLPanelImpl;
import com.lightdev.app.shtm.SHTMLWriter;
import com.lightdev.app.shtm.SyntaxPane;
import com.lightdev.app.shtm.Util;
import com.sun.demo.ExampleFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

class DocumentPane
extends JPanel
implements DocumentListener,
ChangeListener {
    private SHTMLEditorPane editorPane;
    private SyntaxPane sourceEditorPane;
    private File docTempDir = null;
    public Thread saveThread = null;
    public boolean saveSuccessful = false;
    private boolean documentChanged = false;
    private boolean htmlChanged = false;
    private String docName;
    private File loadedStyleSheet = null;
    private URL sourceUrl = null;
    private JComponent paneHoldingScrollPanes;
    private JScrollPane richViewScrollPane;
    private JScrollPane sourceViewScrollPane;
    public static final int VIEW_TAB_LAYOUT = 0;
    public static final int VIEW_TAB_HTML = 1;
    private URL savedUrl = null;
    private boolean loadedFromFile = false;
    private String DEFAULT_DOC_NAME = "Untitled";
    public static String DEFAULT_STYLE_SHEET_NAME = "style.css";
    private int newDocNo;
    private int activeView;
    private Vector dpListeners = new Vector();

    private void setDocumentChanged(boolean documentChanged) {
        this.documentChanged = documentChanged;
    }

    private boolean isDocumentChanged() {
        return this.documentChanged;
    }

    private void setHtmlChanged(boolean htmlChanged) {
        this.htmlChanged = htmlChanged;
    }

    private boolean isHtmlChanged() {
        return this.htmlChanged;
    }

    public DocumentPane() {
        this.editorPane = new SHTMLEditorPane();
        SHTMLEditorKit kit = new SHTMLEditorKit();
        this.editorPane.setEditorKit(kit);
        this.richViewScrollPane = new JScrollPane();
        this.richViewScrollPane.getViewport().setView(this.editorPane);
        this.sourceEditorPane = new SyntaxPane();
        this.sourceEditorPane.setFont(new Font("Monospaced", 0, 12));
        this.sourceViewScrollPane = new JScrollPane();
        this.sourceViewScrollPane.getViewport().setView(this.sourceEditorPane);
        if (Util.showViewsInTabs()) {
            this.paneHoldingScrollPanes = new JTabbedPane();
            this.paneHoldingScrollPanes.add((Component)this.richViewScrollPane, 0);
            this.paneHoldingScrollPanes.add((Component)this.sourceViewScrollPane, 1);
            JTabbedPane tabbedPane = (JTabbedPane)this.paneHoldingScrollPanes;
            tabbedPane.setTabPlacement(3);
            tabbedPane.setTitleAt(0, Util.getResourceString("layoutTabTitle"));
            tabbedPane.setTitleAt(1, Util.getResourceString("htmlTabTitle"));
            tabbedPane.addChangeListener(this);
            this.setLayout(new BorderLayout());
            this.add((Component)this.paneHoldingScrollPanes, "Center");
        } else {
            this.paneHoldingScrollPanes = new JPanel(new BorderLayout());
            this.paneHoldingScrollPanes.add((Component)this.richViewScrollPane, "Center");
            this.activeView = 0;
            this.setLayout(new BorderLayout());
            this.add((Component)this.paneHoldingScrollPanes, "Center");
        }
        this.setDocumentChanged(false);
        this.setPreferredSize(new Dimension(550, 550));
    }

    public DocumentPane(URL docToLoad, int newDocNo) {
        this();
        this.DEFAULT_DOC_NAME = Util.getResourceString("defaultDocName");
        if (docToLoad != null) {
            this.loadDocument(docToLoad);
        } else {
            this.newDocNo = newDocNo;
            this.createNewDocument();
        }
    }

    public SHTMLEditorPane getEditor() {
        return this.editorPane;
    }

    public SyntaxPane getHtmlEditor() {
        return this.sourceEditorPane;
    }

    public int getSelectedTab() {
        if (this.paneHoldingScrollPanes instanceof JTabbedPane) {
            return ((JTabbedPane)this.paneHoldingScrollPanes).getSelectedIndex();
        }
        return this.activeView;
    }

    public void createNewDocument() {
        try {
            SHTMLEditorKit kit = (SHTMLEditorKit)this.editorPane.getEditorKit();
            SHTMLDocument doc = (SHTMLDocument)kit.createDefaultDocument();
            doc.addDocumentListener(this);
            doc.setBase(this.createTempDir());
            this.editorPane.setDocument(doc);
            boolean useStyle = Util.useSteStyleSheet();
            if (useStyle) {
                doc.insertStyleRef();
            }
        }
        catch (Exception e) {
            Util.errMsg(this, e.getMessage(), e);
        }
    }

    public void setDocument(Document docToSet) {
        try {
            SHTMLEditorKit kit = (SHTMLEditorKit)this.editorPane.getEditorKit();
            HTMLDocument doc = (HTMLDocument)this.getDocument();
            if (doc != null) {
                doc.removeDocumentListener(this);
            }
            docToSet.addDocumentListener(this);
            this.editorPane.setDocument(docToSet);
        }
        catch (Exception e) {
            Util.errMsg(this, e.getMessage(), e);
        }
    }

    private URL createTempDir() throws MalformedURLException {
        this.docTempDir = new File(SHTMLPanelImpl.getAppTempDir().getAbsolutePath() + File.separator + this.getDocumentName() + File.separator);
        return this.docTempDir.toURL();
    }

    public void deleteTempDir() {
        if (this.docTempDir != null) {
            Util.deleteDir(this.docTempDir);
            this.docTempDir = null;
        }
    }

    public void loadDocument(URL url) {
        try {
            SHTMLEditorKit kit = (SHTMLEditorKit)this.editorPane.getEditorKit();
            SHTMLDocument doc = (SHTMLDocument)kit.createEmptyDocument();
            doc.putProperty("IgnoreCharsetDirective", new Boolean(true));
            doc.setBase(new File(url.getPath()).getParentFile().toURL());
            InputStream in = url.openStream();
            kit.read(in, (Document)doc, 0);
            in.close();
            doc.addDocumentListener(this);
            this.editorPane.setDocument(doc);
            this.setSource(url);
            this.loadedFromFile = true;
        }
        catch (Exception ex) {
            Util.errMsg(this, "An exception occurred while loading the file", ex);
            ex.printStackTrace();
        }
    }

    private StyleSheet loadStyleSheet(File cssFile) throws MalformedURLException, IOException {
        StyleSheet s = new StyleSheet();
        s.importStyleSheet(cssFile.toURL());
        return s;
    }

    public void saveDocument() throws DocNameMissingException {
        if (!this.saveInProgress()) {
            this.saveThread = Thread.currentThread();
            this.saveSuccessful = false;
            File file = null;
            try {
                if (this.sourceUrl != null) {
                    if (this.getSelectedTab() == 1) {
                        this.editorPane.setText(this.sourceEditorPane.getText());
                    }
                    SHTMLDocument doc = (SHTMLDocument)this.getDocument();
                    FileOutputStream os = new FileOutputStream(this.sourceUrl.getPath());
                    OutputStreamWriter osw = new OutputStreamWriter(os);
                    SHTMLWriter hw = new SHTMLWriter((Writer)osw, doc);
                    hw.write();
                    osw.flush();
                    osw.close();
                    os.flush();
                    ((OutputStream)os).close();
                    if (doc.hasStyleRef()) {
                        this.saveStyleSheet();
                    }
                } else {
                    this.saveThread = null;
                    throw new DocNameMissingException();
                }
                this.saveImages();
                this.setDocumentChanged(false);
                file = new File(this.sourceUrl.getPath()).getParentFile();
                ((HTMLDocument)this.getDocument()).setBase(file.toURL());
                this.deleteTempDir();
                this.saveSuccessful = true;
            }
            catch (MalformedURLException mue) {
                if (file != null) {
                    Util.errMsg(this, "Can not create a valid URL for\n" + file.getAbsolutePath(), mue);
                } else {
                    Util.errMsg(this, mue.getMessage(), mue);
                }
            }
            catch (Exception e) {
                if (this.savedUrl != null) {
                    this.sourceUrl = this.savedUrl;
                }
                Util.errMsg(this, "An exception occurred while saving the file", e);
            }
            this.saveThread = null;
            this.savedUrl = this.sourceUrl;
        }
    }

    public File getImageDir() {
        File srcDir = null;
        srcDir = this.savedUrl == null && this.newDocNo > 0 ? new File(this.docTempDir + File.separator + "images" + File.separator) : (this.savedUrl == null ? new File(new File(this.sourceUrl.getPath()).getParent() + File.separator + "images" + File.separator) : new File(new File(this.savedUrl.getPath()).getParent() + File.separator + "images" + File.separator));
        return srcDir;
    }

    private void saveImages() {
        File srcDir = this.getImageDir();
        File destDir = new File(new File(this.sourceUrl.getPath()).getParent() + File.separator + "images" + File.separator);
        try {
            if (srcDir.exists()) {
                ExampleFileFilter filter = new ExampleFileFilter();
                filter.addExtension("gif");
                filter.addExtension("jpg");
                filter.addExtension("jpeg");
                File[] imgFiles = srcDir.listFiles();
                for (int i = 0; i < imgFiles.length; ++i) {
                    Util.copyFile(imgFiles[i], new File(destDir.getAbsolutePath() + File.separator + imgFiles[i].getName()));
                }
            }
        }
        catch (Exception e) {
            Util.errMsg(this, e.getMessage(), e);
        }
    }

    public boolean saveInProgress() {
        return this.saveThread != null;
    }

    public void saveStyleSheet() throws IOException {
        SHTMLDocument doc = (SHTMLDocument)this.getDocument();
        StyleSheet styles = doc.getStyleSheet();
        String styleSheetName = this.getStyleSheetName();
        if (styleSheetName != null) {
            File styleSheetFile = new File(new URL(styleSheetName).getFile());
            if (!styleSheetFile.exists()) {
                styleSheetFile.createNewFile();
            } else if (this.loadedFromFile) {
                if (this.savedUrl == null || !this.savedUrl.getPath().equals(this.sourceUrl.getPath())) {
                    this.mergeStyleSheets(this.loadStyleSheet(styleSheetFile), styles);
                } else {
                    styleSheetFile.delete();
                    styleSheetFile.createNewFile();
                }
            } else {
                this.mergeStyleSheets(this.loadStyleSheet(styleSheetFile), styles);
            }
            FileOutputStream os = new FileOutputStream(styleSheetFile);
            OutputStreamWriter osw = new OutputStreamWriter(os);
            CSSWriter cssWriter = new CSSWriter(osw, styles);
            cssWriter.write();
            osw.close();
            ((OutputStream)os).close();
        }
    }

    private void mergeStyleSheets(StyleSheet sourceStyleSheet, StyleSheet destinationStyleSheet) throws IOException {
        Vector srcNames = Util.getStyleNames(sourceStyleSheet);
        Vector destNames = Util.getStyleNames(destinationStyleSheet);
        StringWriter sw = new StringWriter();
        StringBuffer buf = sw.getBuffer();
        CSSWriter cssWriter = new CSSWriter(sw, null);
        for (int i = 0; i < srcNames.size(); ++i) {
            Object elem = srcNames.get(i);
            String name = elem.toString();
            if (destNames.indexOf(elem) >= 0) continue;
            buf.delete(0, buf.length());
            cssWriter.writeRule(name, sourceStyleSheet.getStyle(name));
            destinationStyleSheet.removeStyle(name);
            destinationStyleSheet.addRule(buf.toString());
        }
    }

    private String getStyleSheetName() throws MalformedURLException {
        String name = DEFAULT_STYLE_SHEET_NAME;
        SHTMLDocument doc = (SHTMLDocument)this.getDocument();
        String styleRef = doc.getStyleRef();
        File file = new File(this.sourceUrl.getPath()).getParentFile();
        String newDocBase = null;
        try {
            newDocBase = file.toURL().toString();
        }
        catch (Exception e) {
            if (file != null) {
                Util.errMsg(this, "Can not create a valid URL for\n" + file.getAbsolutePath(), e);
            }
            Util.errMsg(this, e.getMessage(), e);
        }
        name = styleRef != null ? Util.resolveRelativePath(styleRef, newDocBase) : null;
        return name;
    }

    public String getDocumentName() {
        String theName = this.docName == null || this.docName.length() < 1 ? this.DEFAULT_DOC_NAME + " " + Integer.toString(this.newDocNo) : this.docName;
        return theName;
    }

    public boolean needsSaving() {
        return this.isDocumentChanged();
    }

    public void setSource(URL source) {
        this.savedUrl = this.sourceUrl;
        this.sourceUrl = source;
        String fName = source.getFile();
        this.docName = fName.substring(fName.lastIndexOf("/") + 1);
        this.fireNameChanged();
    }

    public URL getOldSource() {
        if (this.savedUrl == null) {
            return this.sourceUrl;
        }
        return this.savedUrl;
    }

    public URL getSource() {
        return this.sourceUrl;
    }

    public boolean isNewDoc() {
        return this.sourceUrl == null;
    }

    public Document getDocument() {
        return this.editorPane.getDocument();
    }

    HTMLDocument getHTMLDocument() {
        return (HTMLDocument)this.sourceEditorPane.getDocument();
    }

    public void switchViews() {
        if (this.paneHoldingScrollPanes instanceof JTabbedPane) {
            return;
        }
        if (this.activeView == 0) {
            this.setHTMLView();
            this.paneHoldingScrollPanes.remove(this.richViewScrollPane);
            this.paneHoldingScrollPanes.add(this.sourceViewScrollPane);
            this.activeView = 1;
        } else {
            this.setLayoutView();
            this.paneHoldingScrollPanes.remove(this.sourceViewScrollPane);
            this.paneHoldingScrollPanes.add(this.richViewScrollPane);
            this.activeView = 0;
        }
    }

    private void setHTMLView() {
        try {
            this.editorPane.getDocument().removeDocumentListener(this);
            StringWriter stringWriter = new StringWriter();
            this.editorPane.getEditorKit().write(stringWriter, this.editorPane.getDocument(), 0, this.editorPane.getDocument().getLength());
            stringWriter.close();
            String newText = stringWriter.toString();
            if (!Util.preferenceIsTrue("writeHead", "true")) {
                newText = newText.replaceAll("(?ims)<head>.*?(<body)", "$1");
            }
            this.sourceEditorPane.setText(newText);
            this.sourceEditorPane.getDocument().addDocumentListener(this);
            this.sourceEditorPane.addCaretListener(this.sourceEditorPane);
            this.setHtmlChanged(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void setLayoutView() {
        this.sourceEditorPane.getDocument().removeDocumentListener(this);
        this.sourceEditorPane.removeCaretListener(this.sourceEditorPane);
        if (this.isHtmlChanged()) {
            this.editorPane.setText(this.sourceEditorPane.getText());
        }
        this.editorPane.setCaretPosition(0);
        this.editorPane.getDocument().addDocumentListener(this);
        this.editorPane.requestFocus();
    }

    String getDocumentText() {
        if (this.getSelectedTab() == 1) {
            this.editorPane.setText(this.sourceEditorPane.getText());
        }
        return this.editorPane.getText();
    }

    void setDocumentText(String sText) {
        switch (this.getSelectedTab()) {
            case 0: {
                this.editorPane.setText(sText);
                break;
            }
            case 1: {
                this.sourceEditorPane.setText(sText);
                this.setHtmlChanged(true);
            }
        }
    }

    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        if (src.equals(this.paneHoldingScrollPanes)) {
            switch (this.getSelectedTab()) {
                case 0: {
                    this.setLayoutView();
                    break;
                }
                case 1: {
                    this.setHTMLView();
                }
            }
        }
        SHTMLPanelImpl.getOwnerSHTMLPanel(this).updateActions();
    }

    public void insertUpdate(DocumentEvent e) {
        if (this.getSelectedTab() == 1) {
            this.setHtmlChanged(true);
        }
        this.setDocumentChanged(true);
    }

    public void removeUpdate(DocumentEvent e) {
        if (this.getSelectedTab() == 1) {
            this.setHtmlChanged(true);
        }
        this.setDocumentChanged(true);
    }

    public void changedUpdate(DocumentEvent e) {
        if (this.getSelectedTab() == 0) {
            this.editorPane.updateInputAttributes();
            this.setDocumentChanged(true);
        }
    }

    public void addDocumentPaneListener(DocumentPaneListener listener) {
        if (!this.dpListeners.contains(listener)) {
            this.dpListeners.addElement(listener);
        }
    }

    public void removeDocumentPaneListener(DocumentPaneListener listener) {
        this.dpListeners.remove(listener);
    }

    public void fireNameChanged() {
        Enumeration listenerList = this.dpListeners.elements();
        while (listenerList.hasMoreElements()) {
            ((DocumentPaneListener)listenerList.nextElement()).nameChanged(new DocumentPaneEvent(this));
        }
    }

    public void fireActivated() {
        Enumeration listenerList = this.dpListeners.elements();
        while (listenerList.hasMoreElements()) {
            ((DocumentPaneListener)listenerList.nextElement()).activated(new DocumentPaneEvent(this));
        }
    }

    public void removeAllListeners() {
        this.dpListeners.clear();
    }

    public JEditorPane getMostRecentFocusOwner() {
        switch (this.getSelectedTab()) {
            case 0: {
                return this.editorPane;
            }
            case 1: {
                return this.sourceEditorPane;
            }
        }
        return null;
    }

    public void setContentPanePreferredSize(Dimension prefSize) {
        this.setPreferredSize(null);
        this.paneHoldingScrollPanes.setPreferredSize(null);
        for (int i = 0; i < this.paneHoldingScrollPanes.getComponentCount(); ++i) {
            JScrollPane scrollPane = (JScrollPane)this.paneHoldingScrollPanes.getComponent(i);
            scrollPane.setPreferredSize(prefSize);
            scrollPane.invalidate();
        }
    }

    class DocumentPaneEvent
    extends EventObject {
        public DocumentPaneEvent(Object source) {
            super(source);
        }
    }

    public static interface DocumentPaneListener {
        public void nameChanged(DocumentPaneEvent var1);

        public void activated(DocumentPaneEvent var1);
    }
}

